/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.retention.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.framework.service.replica.factory.ReplicaFactoryManager;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;

public final class CheckReplicaTools {
    private static final Log logger = LogFactory.getInstance(CheckReplicaTools.class);

    public static boolean checkSnapshotCorrect(String replicaId) {
        if (null == replicaId || replicaId.isEmpty()) {
            throw new LegoCheckedException(1073947393L, "replicaId is empty.");
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        if (null == replica) {
            logger.error((Object)("replica is not found:" + replicaId));
            throw new LegoCheckedException(201L);
        }
        IReplicaFactory factory = ReplicaFactoryManager.getInstance().getReplicaFactory(replica.getType());
        return factory.validReplica(replica, false);
    }

    public static void disableProtectGroupReplicas(String protectGroupId) {
        logger.debug((Object)("begin to disableProtectGroupReplicas:" + protectGroupId));
        if (null == protectGroupId || protectGroupId.isEmpty()) {
            throw new LegoCheckedException(1073947393L, "protectGroupId is empty.");
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        List replicas = replicaService.queryProtectGroupReplicaByGroup(protectGroupId, null, true, null);
        if (VerifyUtil.isEmpty((Collection)replicas)) {
            return;
        }
        for (ProtectGroupReplica replica : replicas) {
            if (DrmEnumDefine.REPLICA_STATUS.ERROR_STATUS.getValue() == replica.getStatus()) {
                logger.debug((Object)("replica(" + replica.getId() + ")'s status is" + replica.getStatus() + ", and not need check."));
                continue;
            }
            try {
                IReplicaFactory factory;
                if (replica.isStorageReplicationReplica() || (factory = ReplicaFactoryManager.getInstance().getReplicaFactory(replica.getType())).validReplica(replica, true)) continue;
                logger.info((Object)("replica(" + replica.getId() + ") is not correct."));
                boolean status = CheckReplicaTools.disableProtectGroupReplica(replica.getId());
                logger.debug((Object)("disable incorrect local replica. success: " + status));
            }
            catch (Exception e) {
                logger.error((Object)("process protect group replica failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }

    private static boolean disableProtectGroupReplica(String replicaId) {
        logger.debug((Object)("begin to disableProtectGroupReplica:" + replicaId));
        String sql = "update ti_protectgroupreplica set replicastatus = ? where id = ?";
        try {
            int records = CommonDAOLocator.getBaseDao().update(sql, new Object[]{DrmEnumDefine.REPLICA_STATUS.ERROR_STATUS.getValue(), replicaId});
            if (records == 0) {
                logger.warn((Object)("no protect group replica to disable. replica id: " + replicaId));
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("disable protect group replica failed. replica id: " + replicaId + ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
    }

    public static boolean updateProtectGroupReplicaStatus(String replicaId, int status) {
        logger.debug((Object)("begin to updateProtectGroupReplicaStatus:" + replicaId + " status:" + status));
        String sql = "update ti_protectgroupreplica set replicastatus = ? where id = ?";
        try {
            int records = CommonDAOLocator.getBaseDao().update(sql, new Object[]{status, replicaId});
            if (records == 0) {
                logger.warn((Object)("no protect group replica to update. replica id: " + replicaId));
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("update protect group replica failed. replica id: " + replicaId + " status:" + status + ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
    }
}

