/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.schedule;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.service.IScheduleService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;

@Service(Name="com.huawei.ism.drm.protection.schedule.sdk.service.IScheduleService", Desc="", Interface=IScheduleService.class)
public class ScheduleServiceImpl
extends BaseService
implements IScheduleService {
    private static Log logger = LogFactory.getInstance(ScheduleServiceImpl.class);
    private IBaseDao<Object, Serializable> dao;

    public IBaseDao<Object, Serializable> getDao() {
        return this.dao;
    }

    public void setDao(IBaseDao<Object, Serializable> dao) {
        this.dao = dao;
    }

    public void addSchedule(Schedule schedule) {
        if (null == schedule) {
            logger.error((Object)"schedule is null");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            this.dao.save((Object)schedule);
        }
        catch (DataAccessException e) {
            logger.error((Object)("save schedule error!schedule Id:" + schedule.getScheduleId()));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void addSchedules(Set<Schedule> schedules) {
        if (null == schedules) {
            logger.error((Object)"schedules is null");
            throw new LegoCheckedException(1073947393L);
        }
        for (Schedule schedule : schedules) {
            this.addSchedule(schedule);
        }
    }

    public void deleteSchedule(String scheduleId) {
        Schedule schedule = this.getSchedule(scheduleId);
        if (null == schedule) {
            logger.error((Object)"schedule is null");
            throw new LegoCheckedException(1073947394L);
        }
        try {
            this.dao.getHibernateTemplate().delete((Object)schedule);
        }
        catch (DataAccessException e) {
            logger.error((Object)("delete schedule error!schedule Id:" + scheduleId));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void deleteSchedules(List<String> scheduleIds) {
        if (null == scheduleIds) {
            logger.error((Object)"scheduleIds is null");
            throw new LegoCheckedException(1073947393L);
        }
        for (String scheduleId : scheduleIds) {
            this.deleteSchedule(scheduleId);
        }
    }

    public void deleteAll() {
        String hql = "delete from Schedule";
        Session session = null;
        try {
            session = this.dao.getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            session.createQuery(hql).executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"delete all schedule error!");
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
    }

    public void updateSchedule(Schedule schedule) {
        if (null == schedule) {
            logger.error((Object)"schedule is null");
            throw new LegoCheckedException(1073947393L);
        }
        Schedule tmpSchedule = this.getSchedule(schedule.getScheduleId());
        if (null == tmpSchedule) {
            logger.error((Object)"tmpSchedule is null");
            throw new LegoCheckedException(1073947394L);
        }
        try {
            this.dao.getHibernateTemplate().update((Object)schedule);
        }
        catch (DataAccessException e) {
            logger.error((Object)("delete schedule error!schedule Id:" + schedule.getScheduleId()));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public Schedule getSchedule(String scheduleId) {
        Schedule schedule = null;
        try {
            schedule = (Schedule)this.dao.getHibernateTemplate().get(Schedule.class, (Serializable)((Object)scheduleId));
        }
        catch (DataAccessException e) {
            logger.error((Object)("delete schedule error!schedule Id:" + scheduleId));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return schedule;
    }

    public List<Schedule> getAllSchedules() {
        List schedules = null;
        String scheduleHQL = "from Schedule as s order by s.scheduleId";
        try {
            schedules = this.dao.getHibernateTemplate().find(scheduleHQL, new Object[0]);
        }
        catch (DataAccessException e) {
            logger.error((Object)"get All Schedules error!");
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return schedules;
    }

    public boolean isScheduleExist(String name, String policyId) {
        boolean bl;
        List policyScheduleIds;
        Session session;
        block8: {
            if (VerifyUtil.isEmpty((String)name) || VerifyUtil.isEmpty((String)policyId)) {
                logger.warn((Object)("name:" + name + ", policyId:" + policyId));
                return false;
            }
            session = null;
            session = this.dao.getHibernateTemplate().getSessionFactory().openSession();
            String sql = "select ps.SCHEDULEID from ti_pp_r_schedule ps where ps.PPID = :ppid";
            policyScheduleIds = session.createSQLQuery(sql).setParameter("ppid", (Object)policyId).list();
            if (!VerifyUtil.isEmpty((Collection)policyScheduleIds)) break block8;
            boolean bl2 = false;
            DBOperationUtil.closeSession(session);
            return bl2;
        }
        try {
            Object[] psIds = policyScheduleIds.toArray();
            StringBuilder queryScheduleNameByScheduleId = new StringBuilder("select s.name from Schedule s where (");
            int psLength = psIds.length;
            for (int i = 0; i < psLength; ++i) {
                queryScheduleNameByScheduleId.append("s.scheduleId = ? ");
                if (i == psLength - 1) continue;
                queryScheduleNameByScheduleId.append("or ");
            }
            queryScheduleNameByScheduleId.append(") and s.name = ?");
            Query query = session.createQuery(queryScheduleNameByScheduleId.toString());
            for (int i = 0; i < psLength; ++i) {
                query.setParameter(i, psIds[i]);
            }
            query.setParameter(psLength, (Object)name);
            List scheduleName = query.list();
            bl = !VerifyUtil.isEmpty((Collection)scheduleName);
        }
        catch (HibernateException e) {
            try {
                logger.error((Object)("query schedule error!name:" + name + ", policyId:" + policyId));
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return bl;
    }
}

