/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectionTaskExecutor;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class ProtectionBackTaskHandler {
    private static final ProtectionBackTaskHandler HANDLER = new ProtectionBackTaskHandler();
    private static final String CLOUD_BACKP_THREAD_POOL_NAME = "Cloud_Backup_Task";
    private static final String COMMON_PROTECTION_TASK_THREAD_POOL_NAME = "Protection_Task";
    private final Log logger = LogFactory.getInstance(ProtectionBackTaskHandler.class);

    private ProtectionBackTaskHandler() {
    }

    public static ProtectionBackTaskHandler getInstance() {
        return HANDLER;
    }

    public synchronized long submitTask(ProtectionTaskExecutor task) {
        this.logger.debug((Object)"Begin to submit protection task");
        if (null == task) {
            this.logger.error((Object)"ProtectionExecutor cannot be null");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectionTask protectionTask = task.getTask();
        Schedule schedule = protectionTask.getSchedule();
        if (null == schedule) {
            this.logger.error((Object)"Schedule cannot be empty when submitting a protection task");
            throw new LegoCheckedException(1073947393L);
        }
        this.logger.debug((Object)"The task id to be submitted is %s ,schedule id is %s and the protection type is %s", new Object[]{task.getTaskId(), schedule.getScheduleId(), String.valueOf(schedule.getProtectedType())});
        return this.getBackTaskService(schedule.getProtectedType()).submitTask((AbstractBackTask)task);
    }

    private BackTaskService getBackTaskService(int protectedType) {
        if (ScheduleProtectedType.CLOUD_BACKUP.getValue() == protectedType) {
            return BackTaskService.getBackTaskService((String)CLOUD_BACKP_THREAD_POOL_NAME);
        }
        return BackTaskService.getBackTaskService((String)COMMON_PROTECTION_TASK_THREAD_POOL_NAME);
    }
}

