/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.checker;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RollbackProcessChecker
implements IRecoveryProcessChecker {
    private static Log logger = LogFactory.getInstance(RollbackProcessChecker.class);
    private static final List<Integer> AVAILABLE_EXECUTE_TYPE = new ArrayList<Integer>();

    public void check(RecoveryProcessorContext context, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        if (null == context || null == procType) {
            logger.error((Object)"Invalid parameters.");
            return;
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.debug((Object)"Invalid parameters.");
            return;
        }
        Set protectGroups = recoveryPlan.getProtectGroups();
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (null == replica) {
            logger.debug((Object)"Invalid parameters.");
            return;
        }
        for (ProtectGroup pg : protectGroups) {
            if (!AVAILABLE_EXECUTE_TYPE.contains(procType.getValue())) continue;
            this.checkReplicaStorageInfo(pg, replica);
            this.chceckReplicaLocation(pg, replica);
        }
    }

    private void checkReplicaStorageInfo(ProtectGroup protectGroup, ProtectGroupReplica replica) {
        Set set = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)set)) {
            return;
        }
        if (10 != ((ProtectObject)CommonUtil.getFirstElement((Collection)set)).getPoType()) {
            return;
        }
        List storageInfos = protectGroup.distinctStorageInfo();
        if (VerifyUtil.isEmpty((Collection)storageInfos)) {
            return;
        }
        HashMap<String, Set<String>> wwnMap = new HashMap<String, Set<String>>();
        for (ProtectObjectStorageInfo storageInfo : storageInfos) {
            String mountPoint = storageInfo.getMountPoint();
            if (VerifyUtil.isEmpty((String)mountPoint) || VerifyUtil.isEmpty((String)storageInfo.getLunWWN())) continue;
            HashSet<String> wwnList = (HashSet<String>)wwnMap.get(mountPoint);
            if (null == wwnList) {
                wwnList = new HashSet<String>();
            }
            wwnList.add(storageInfo.getLunWWN());
            wwnMap.put(mountPoint, wwnList);
        }
        if (VerifyUtil.isEmpty((Collection)replica.getReplicas())) {
            return;
        }
        HashSet<String> replicaWwns = new HashSet<String>();
        for (ProtectObjectReplica repilica : replica.getReplicas()) {
            for (RelicaStorageInfo info : repilica.getStorageInfos()) {
                replicaWwns.add(info.getProtectObjectStorageWwn());
            }
        }
        this.checkWwn(wwnMap, replicaWwns);
    }

    private void checkWwn(Map<String, Set<String>> wwnMap, Set<String> replicaWwns) {
        for (Map.Entry<String, Set<String>> entry : wwnMap.entrySet()) {
            Set<String> wwnList = entry.getValue();
            boolean isExists = false;
            boolean isNotAllExists = false;
            for (String wwn : wwnList) {
                if (replicaWwns.contains(wwn)) {
                    isExists = true;
                    continue;
                }
                isNotAllExists = true;
            }
            if (!isExists || !isNotAllExists) continue;
            throw new LegoCheckedException(1073948255L);
        }
    }

    private void chceckReplicaLocation(ProtectGroup pg, ProtectGroupReplica replica) {
        if (32 == pg.getTemplate().getType() && replica.getProtectLocation() == DrmEnumDefine.PROTECT_LOCATION.B.getValue()) {
            throw new LegoCheckedException(1073948754L);
        }
    }

    public String getName() {
        logger.trace((Object)"getName");
        return this.getClass().getName();
    }

    static {
        AVAILABLE_EXECUTE_TYPE.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.getValue());
    }
}

