/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.IRecoveryTaskInterceptor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.framework.util.SyncLockManager;
import com.huawei.ism.drm.recovery.process.IInitialChildProcessor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BaseRecoveryProcessor
extends RecoveryProcessor {
    protected static final boolean CONTINUE_RECOVERY_PROCESS = true;
    protected static final boolean EXIT_RECOVERY_PROCESS = false;
    protected static final long LOG_CODE = -1L;
    protected static final long NO_SUB_PROCESSOR = Long.MAX_VALUE;
    private static final long serialVersionUID = -4384869125323015228L;
    private static Log logger = LogFactory.getInstance(BaseRecoveryProcessor.class);
    private static final String PARAM_PROC_NAME_PARAMS = "ProcNameParams";
    private static final String PARAM_PROC_NAME = "ProcName";
    private static final String PARAM_PROC_ID = "ProcId";
    private static final String PARAM_PREVIOUS_PROC_ID = "PreviousProcId";
    private static final String PARAM_NEXT_PROC_ID = "NextProcId";
    private static final String PARAM_PROC_STATUS = "ProcessStatus";
    private static final String PREPPARE_CLASS = "prepareclass";
    private static final String REF_PROC_TYPE = "refproctype";
    private RecoveryProcessorContext contextRef = null;
    private boolean asyncExecute = false;
    private String recoveryTasksKey = "recoveryTasks";
    private IRecoveryTaskInterceptor taskInterceptor;

    public RecoveryProcessorContext getContextRef() {
        logger.trace((Object)"enter getContextRef");
        return this.contextRef;
    }

    public boolean success() {
        return this.success(null, null);
    }

    public boolean success(String detail, String[] detailParams) {
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        this.updateProcessDetail(detail, detailParams);
        return true;
    }

    public boolean failure() {
        return this.failure(null, null);
    }

    public boolean failure(String failureDetails, String[] failureParams) {
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        this.updateProcessDetail(failureDetails, failureParams);
        return false;
    }

    public boolean failure(LegoCheckedException ex) {
        return this.failure(ex.getErrorMessageKey(), ex.getParameters());
    }

    public void setContextRef(RecoveryProcessorContext contextRef) {
        logger.trace((Object)"enter setContextRef");
        this.contextRef = contextRef;
    }

    public boolean isAsyncExecute() {
        logger.trace((Object)"enter isAsyncExecute");
        return this.asyncExecute;
    }

    public void setAsyncExecute(boolean asyncExecute) {
        logger.trace((Object)"enter setAsyncExecute");
        this.asyncExecute = asyncExecute;
    }

    public String getRecoveryTasksKey() {
        return this.recoveryTasksKey;
    }

    public void setRecoveryTasksKey(String recoveryTasksKey) {
        this.recoveryTasksKey = recoveryTasksKey;
    }

    public final boolean process(RecoveryProcessorContext context) {
        logger.trace((Object)"enter process");
        this.contextRef = context;
        boolean result = false;
        this.updateProcessName();
        this.beforeExecRecoveryProcessor();
        this.updateProcNameParams();
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        String extAttributes = (String)recoveryPlan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus() && String.valueOf(DrmEnumDefine.RECOVERY_EXTEND_ATTRIBUTES.REFACTOR_CONFIGURATION_SUCCESS.getValue()).equals(extAttributes)) {
            logger.trace((Object)("the process is in reprotect and refactor success: " + recoveryPlan.getName()));
            result = true;
        } else {
            result = this.executeRecoveryProcessor();
        }
        if (!this.isAsyncExecute()) {
            this.endRecoveryProcessor();
        }
        return result;
    }

    public void updateProcessName(String processName) {
        logger.trace((Object)"enter updateProcessName");
        if (!this.getIsNeedCreateDetail().booleanValue()) {
            logger.trace((Object)("no need to update: " + processName));
            return;
        }
        RecoveryProcessorDetail detail = this.getCurProcessDetail();
        detail.setProcessName(processName);
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        recoveryProcessService.updateRecoveryProcessDetail(detail);
    }

    public void updateProcessNameParams(String[] procNameParams) {
        logger.debug((Object)"Enter updateProcessNameParams");
        if (!this.getIsNeedCreateDetail().booleanValue()) {
            logger.info((Object)"No need to update detail.");
            return;
        }
        RecoveryProcessorDetail detail = this.getCurProcessDetail();
        detail.setProcessNameParams(RecoveryProcessUtil.constructParamsString(procNameParams));
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        recoveryProcessService.updateRecoveryProcessDetail(detail);
    }

    public void updateProcessDetail(LegoCheckedException ex) {
        this.updateProcessDetail(ex.getErrorMessageKey(), ex.getParameters());
    }

    public void updateProcessDetail(String procDetail, String[] procDetailParams) {
        logger.trace((Object)"enter updateProcessDetail");
        this.setProcDetail(procDetail);
        this.setProcDetailParams(procDetailParams);
        if (!this.getIsNeedCreateDetail().booleanValue()) {
            logger.trace((Object)"no need to updatedetail and param");
            return;
        }
        RecoveryProcessorDetail detail = this.getCurProcessDetail();
        detail.setProcessDetail(procDetail);
        detail.setProcessDetailParams(RecoveryProcessUtil.constructParamsString(procDetailParams));
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        recoveryProcessService.updateRecoveryProcessDetail(detail);
    }

    public void setProcessDetailIsSkipped(Boolean isSkipped) {
        logger.trace((Object)"set skip begin");
        RecoveryProcessorDetail detail = this.getCurProcessDetail();
        detail.setIsSkipped(Boolean.valueOf(true));
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        recoveryProcessService.updateRecoveryProcessDetail(detail);
    }

    public RecoveryProcessorDetail createRecoveryProcessorDetail(String logId, String parentProcDetailId, String procId, String procName, String previousProcId, String nextProcId) {
        logger.trace((Object)"enter createRecoveryProcessorDetail");
        HashMap<String, Object> procParams = new HashMap<String, Object>();
        procParams.put(PARAM_PROC_ID, procId);
        procParams.put(PARAM_PROC_NAME, procName);
        procParams.put(PARAM_PROC_NAME_PARAMS, null);
        procParams.put(PARAM_PREVIOUS_PROC_ID, previousProcId);
        procParams.put(PARAM_NEXT_PROC_ID, nextProcId);
        String detailId = this.createRecoveryProcessorDetail(logId, parentProcDetailId, procParams, new Date().getTime());
        RecoveryProcessorDetail procDetail = null;
        if (null != detailId) {
            logger.trace((Object)("detailId is : " + detailId));
            IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
            procDetail = planService.getRecoveryProcessorDetail(detailId);
        }
        return procDetail;
    }

    public void createRecoveryProcessorDetail(RecoveryProcessorDetail procDetail) {
        HashMap<String, Object> procParams = new HashMap<String, Object>();
        procParams.put(PARAM_PROC_ID, procDetail.getProcId());
        procParams.put(PARAM_PROC_NAME, procDetail.getProcessName());
        procParams.put(PARAM_PROC_NAME_PARAMS, null);
        procParams.put(PARAM_PREVIOUS_PROC_ID, procDetail.getPreviousProcId());
        procParams.put(PARAM_NEXT_PROC_ID, procDetail.getNextProcId());
        procParams.put(PARAM_PROC_STATUS, procDetail.getProcessStatus());
        this.createRecoveryProcessorDetail(procDetail.getLogId(), procDetail.getParentDetailId(), procParams, new Date().getTime());
    }

    public int getAssociatedPoType(RecoveryProcessorContext context) {
        if (null == context) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null or getProtectGroups is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        Set pgs = recoveryPlan.getProtectGroups();
        Iterator iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        int poType = ((ProtectGroup)iterator.next()).getPoType();
        return poType;
    }

    protected abstract boolean execute(RecoveryProcessorContext var1);

    protected boolean executeSubProcessor(RecoveryProcessorContext context) {
        List<? extends IProcessor> processors = RecoveryServiceUtil.sortAndUpdateProcessorRation(this.getChildProc());
        RecoveryProcessConcurrentExecutor concurrentExecutor = RecoveryProcessConcurrentExecutor.createExecutor(processors);
        concurrentExecutor.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    protected String generateResultKey() {
        return null;
    }

    protected Set<AbstractMap.SimpleEntry<String, Boolean>> getPoRecoveryStatus(RecoveryProcessorContext context) {
        logger.trace((Object)"enter getPoRecoveryStatus");
        return new HashSet<AbstractMap.SimpleEntry<String, Boolean>>();
    }

    protected void checkIfHasSubProcessor() {
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            logger.trace((Object)"childroc is null");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            throw new LegoCheckedException(Long.MAX_VALUE);
        }
    }

    protected DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E calcProcStatusBySubProc(Set<RecoveryProcessor> rProcesses) {
        logger.trace((Object)"begin calcProcStatus start");
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS;
        boolean hasFailed = false;
        boolean hasPartSuccessed = false;
        boolean hasSuccess = false;
        if (!VerifyUtil.isEmpty(rProcesses)) {
            for (RecoveryProcessor process : rProcesses) {
                if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue() == process.getProcStatus()) {
                    hasFailed = true;
                    continue;
                }
                if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == process.getProcStatus()) {
                    hasPartSuccessed = true;
                    continue;
                }
                if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != process.getProcStatus()) continue;
                if (this.calcCascadeProcessResult(process, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS)) {
                    hasPartSuccessed = true;
                    continue;
                }
                if (this.calcCascadeProcessResult(process, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED)) {
                    hasFailed = true;
                    continue;
                }
                hasSuccess = true;
            }
        }
        procStatus = this.getProcStatus(procStatus, hasFailed, hasPartSuccessed, hasSuccess);
        return procStatus;
    }

    private DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E getProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus, boolean hasFailed, boolean hasPartSuccessed, boolean hasSuccess) {
        logger.trace((Object)"enter getProcStatus");
        if (hasPartSuccessed || hasFailed && hasSuccess) {
            procStatus = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS;
            this.setContextProcessStatusFailed();
        } else if (hasFailed && !hasSuccess) {
            procStatus = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED;
            this.setContextProcessStatusFailed();
        } else if (!hasFailed && hasSuccess) {
            procStatus = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS;
        }
        return procStatus;
    }

    protected void setContextProcessStatusFailed() {
        if (null == this.contextRef) {
            logger.error((Object)"the contextRef is null");
            return;
        }
        this.contextRef.setProcessStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue() == procStatus.getValue()) {
            logger.debug((Object)"the status is failed");
            return false;
        }
        return true;
    }

    protected void updateSubProcessors(Set<RecoveryProcessor> newSubProcessors) {
        if (null == newSubProcessors || newSubProcessors.isEmpty() || null == this.getChildProc() || this.getChildProc().isEmpty()) {
            logger.trace((Object)"param is null");
            return;
        }
        Set<RecoveryProcessor> processes = RecoveryTaskUtil.getRootRecoveryProcessors(this.getChildProc());
        Iterator<RecoveryProcessor> preIterator = processes.iterator();
        Iterator<RecoveryProcessor> newIterator = newSubProcessors.iterator();
        IRecoveryProcessService rProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        while (preIterator.hasNext()) {
            RecoveryProcessor preProcessor = preIterator.next();
            boolean isExist = false;
            while (newIterator.hasNext()) {
                RecoveryProcessor newProcessor = newIterator.next();
                if (!this.isSameProcessor(preProcessor, newProcessor)) continue;
                this.updateProcessorData(preProcessor, newProcessor);
                this.updateCascadeProcessors(preProcessor, newProcessor);
                newIterator.remove();
                newIterator = newSubProcessors.iterator();
                isExist = true;
                break;
            }
            if (isExist) continue;
            rProcessService.deleteRecoveryProcessor(preProcessor.getProcId());
            preIterator.remove();
            preIterator = processes.iterator();
        }
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor recoveryProcess : processes) {
            subProcessors.add(recoveryProcess);
        }
        for (RecoveryProcessor recoveryProcess : newSubProcessors) {
            subProcessors.add(recoveryProcess);
        }
        this.setChildProc(subProcessors);
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess && null == newProcess) {
            logger.trace((Object)"param is null");
            return true;
        }
        if (null != oldProcess) {
            return oldProcess.equals((Object)newProcess);
        }
        return false;
    }

    protected void updateProcessorData(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        logger.trace((Object)"enter updateProcessorData");
    }

    public void endRecoveryProcessor() {
        this.recordProcessResult(this.contextRef);
        this.recordPoRecoveryStatus(this.contextRef);
        this.updateRecoveryPlanProgress(this.contextRef.getRecoveryPlan().getPlanId(), this.getProgressRatio());
        if (this.getIsNeedCreateDetail().booleanValue()) {
            RecoveryProcessorDetail processDetail = this.getCurProcessDetail();
            if (null == processDetail) {
                logger.error((Object)("the processDetail is null: " + this.contextRef.getRecoveryPlan().getPlanId()), 1L);
                return;
            }
            processDetail.setEndTime(String.valueOf(new Date().getTime()));
            processDetail.setProcessStatus(this.getProcStatus());
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.updateRecoveryProcessDetail(processDetail);
            if (null != this.taskInterceptor) {
                this.taskInterceptor.after();
            }
        }
    }

    protected List<RecoveryProcessor> getRecoveryProcessors(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType, Class<? extends RecoveryProcessor> cls) {
        return BaseRecoveryProcessor.getRecoveryPlanRecoveryProcessors(recoveryPlan, execType, cls);
    }

    public static List<RecoveryProcessor> getRecoveryPlanRecoveryProcessors(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType, Class<? extends RecoveryProcessor> cls) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null or getProtectGroups is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        conditions.add(new QueryCondition("procType", (Object)execType.getValue()));
        IRecoveryProcessService rProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        List recoveryProcessors = rProcessService.getRecoveryProcessors(recoveryPlan.getPlanId(), conditions, cls);
        return recoveryProcessors;
    }

    private void recordPoRecoveryStatus(RecoveryProcessorContext context) {
        RecoveryProcessResult processResult = context.getProcessResult();
        try {
            Set<AbstractMap.SimpleEntry<String, Boolean>> poRecoveryStatusEntries = this.getPoRecoveryStatus(context);
            if (VerifyUtil.isEmpty(poRecoveryStatusEntries)) {
                return;
            }
            for (AbstractMap.SimpleEntry<String, Boolean> entry : poRecoveryStatusEntries) {
                String key = entry.getKey();
                Boolean value = entry.getValue();
                if (processResult == null) {
                    throw new LegoCheckedException("Result of process is null.");
                }
                Boolean preValue = processResult.getValue(key);
                if (null == preValue) {
                    processResult.addProcessResult(key, value.booleanValue());
                } else {
                    processResult.addProcessResult(key, value != false && preValue != false);
                }
                logger.debug((Object)("Po Recovery Status: Key=" + key + ",Value=" + value + ",PreValue:" + preValue), 90160758784000L);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting protect object recovery status failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    private void recordProcessResult(RecoveryProcessorContext context) {
        RecoveryProcessResult processResult = context.getProcessResult();
        try {
            String resultKey = this.generateResultKey();
            if (null == resultKey || resultKey.trim().isEmpty()) {
                return;
            }
            if (processResult == null) {
                throw new LegoCheckedException("Result of process is null.");
            }
            processResult.addProcessResult(resultKey, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus());
        }
        catch (LegoUnsupportedOperationException e) {
            logger.error((Object)e.getMessage(), 90160758784001L);
        }
        catch (Exception e) {
            logger.error((Object)("Generating result key failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRecoveryPlanProgress(String recoveryPlanId, int progressRatio) {
        ReentrantLock lock = SyncLockManager.getSyncLock(recoveryPlanId);
        if (null == lock) {
            logger.error((Object)("try to lock failed planid: " + recoveryPlanId));
            return;
        }
        lock.lock();
        try {
            if (0 < progressRatio && 100 >= progressRatio && (null == this.getParentProc() || this.getParentProc() instanceof IInitialChildProcessor)) {
                IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
                recoveryProcessService.updateRecoveryPlanProgress(recoveryPlanId, progressRatio);
            }
        }
        finally {
            lock.unlock();
            logger.trace((Object)("unlock planid: " + recoveryPlanId));
        }
    }

    private boolean executeRecoveryProcessor() {
        boolean result = true;
        try {
            logger.debug((Object)"Begin to execute processor: %s", new Object[]{((Object)((Object)this)).getClass().getName()});
            result = this.execute(this.contextRef);
            logger.debug((Object)"Execute processor successful....");
        }
        catch (LegoCheckedException e) {
            if (Long.MAX_VALUE == e.getErrorCode()) {
                logger.warn((Object)("The processor has not sub processor. ProcName:" + this.getProcName()), 90160758784001L);
            } else {
                logger.error((Object)"Executing recovery process[%s] failed.", (Throwable)e, new Object[]{((Object)((Object)this)).getClass().getName()});
                this.updateProcessDetail(e);
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                result = false;
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Executing recovery process[%s] failed." + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{((Object)((Object)this)).getClass().getName()});
            this.updateProcessDetail("lego.err.-1", new String[0]);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            result = false;
        }
        return result;
    }

    public void beforeExecRecoveryProcessor() {
        if (this.getIsNeedCreateDetail().booleanValue()) {
            String parentDetailId = null;
            if (null != this.getParentProc()) {
                parentDetailId = this.getParentProc().getCurProcessDetail().getDetailId();
            }
            RecoveryProcessor preProcessor = RecoveryProcessUtil.getValidPreviousProcessor(this);
            RecoveryProcessor nextProcessor = RecoveryProcessUtil.getValidNextProcessor(this);
            String previousProcId = null != preProcessor ? preProcessor.getProcId() : null;
            String nextProcId = null != nextProcessor ? nextProcessor.getProcId() : null;
            RecoveryProcessorDetail procDetail = this.createRecoveryProcessorDetail(this.contextRef.getRecoveryLogId(), parentDetailId, this.getProcId(), this.getProcName(), previousProcId, nextProcId);
            this.setCurProcessDetail(procDetail);
        }
        this.prepare();
    }

    private void prepare() {
        String prepareClassName = (String)this.getProps().get(PREPPARE_CLASS);
        String refProcType = (String)this.getProps().get(REF_PROC_TYPE);
        if (null == prepareClassName) {
            return;
        }
        try {
            Class<?> cls = Class.forName(prepareClassName);
            Constructor<?> cons = cls.getConstructor(BaseRecoveryProcessor.class);
            Object interceptor = cons.newInstance(new Object[]{this});
            if (!(interceptor instanceof IRecoveryTaskInterceptor)) {
                return;
            }
            this.taskInterceptor = (IRecoveryTaskInterceptor)interceptor;
            if (null != refProcType) {
                this.taskInterceptor.setRefProcType(refProcType);
            } else {
                this.taskInterceptor.setRefProcType(String.valueOf(this.getProcType()));
            }
            this.taskInterceptor.before();
        }
        catch (Exception e) {
            logger.error((Object)("Construct prepare instance failed, error message :" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private void deleteCascadeProcessors(RecoveryProcessor processor) {
        if (null == processor) {
            logger.trace((Object)"processor is null");
            return;
        }
        if (null == processor.getNextCascadeProcessor()) {
            IRecoveryProcessService rProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            rProcessService.deleteRecoveryProcessor(processor.getProcId());
            return;
        }
        this.deleteCascadeProcessors(processor.getNextCascadeProcessor());
    }

    private void updateCascadeProcessors(RecoveryProcessor preProcessor, RecoveryProcessor newProcessor) {
        if (null == newProcessor.getNextCascadeProcessor()) {
            logger.trace((Object)"param is null");
            return;
        }
        if (null == preProcessor.getNextCascadeProcessor()) {
            preProcessor.setNextCascadeProcessor(newProcessor.getNextCascadeProcessor());
            return;
        }
        if (this.isSameProcessor(preProcessor.getNextCascadeProcessor(), newProcessor.getNextCascadeProcessor())) {
            this.updateProcessorData(preProcessor.getNextCascadeProcessor(), newProcessor.getNextCascadeProcessor());
            this.updateCascadeProcessors(preProcessor.getNextCascadeProcessor(), newProcessor.getNextCascadeProcessor());
        } else {
            this.deleteCascadeProcessors(preProcessor.getNextCascadeProcessor());
            preProcessor.setNextCascadeProcessor(newProcessor.getNextCascadeProcessor());
        }
    }

    private boolean calcCascadeProcessResult(RecoveryProcessor processor, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E resultType) {
        if (null == processor) {
            logger.trace((Object)"processor is null");
            return false;
        }
        if (resultType.getValue() == processor.getProcStatus()) {
            return true;
        }
        if (null != processor.getNextCascadeProcessor()) {
            return this.calcCascadeProcessResult(processor.getNextCascadeProcessor(), resultType);
        }
        return false;
    }

    private String createRecoveryProcessorDetail(String logId, String parentProcDetailId, Map<String, Object> procParams, long startTime) {
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        boolean isUpdate = true;
        RecoveryProcessorDetail procDetail = null;
        String procId = String.valueOf(procParams.get(PARAM_PROC_ID));
        if (null == parentProcDetailId) {
            logger.trace((Object)("parentProcDetailId is null: " + logId));
            procDetail = recoveryProcessService.getRecoveryProcessDetail(logId, procId);
        }
        if (null == procDetail) {
            procDetail = new RecoveryProcessorDetail();
            procDetail.setDetailId(UUIDGenerator.getUUID());
            isUpdate = false;
        }
        procDetail.setStartTime(String.valueOf(startTime));
        procDetail.setProcId(procId);
        if (null != procParams.get(PARAM_PREVIOUS_PROC_ID)) {
            procDetail.setPreviousProcId(String.valueOf(procParams.get(PARAM_PREVIOUS_PROC_ID)));
        }
        if (null != procParams.get(PARAM_NEXT_PROC_ID)) {
            procDetail.setNextProcId(String.valueOf(procParams.get(PARAM_NEXT_PROC_ID)));
        }
        procDetail.setProcessName(String.valueOf(procParams.get(PARAM_PROC_NAME)));
        if (procParams.get(PARAM_PROC_STATUS) != null) {
            procDetail.setProcessStatus(((Integer)procParams.get(PARAM_PROC_STATUS)).intValue());
        } else {
            procDetail.setProcessStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.RUNNING.getValue());
        }
        procDetail.setLogId(logId);
        String[] procNameParams = null;
        Object procNameParamsObj = procParams.get(PARAM_PROC_NAME_PARAMS);
        if (null != procNameParamsObj) {
            procNameParams = (String[])procNameParamsObj;
        }
        String params = RecoveryProcessUtil.constructParamsString(procNameParams);
        procDetail.setProcessNameParams(params);
        procDetail.setParentDetailId(parentProcDetailId);
        String detailId = recoveryProcessService.createRecoveryProcessDetail(procDetail, isUpdate);
        return detailId;
    }

    protected String getVstoreId(RecoveryProcessorContext context) {
        logger.trace((Object)("not support" + context));
        return null;
    }

    protected boolean serialExcuteChildProc(RecoveryProcessorContext context) {
        Set subProcessors = this.getChildProc();
        if (null == subProcessors || subProcessors.isEmpty()) {
            return true;
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(new ArrayList(subProcessors), execType);
        recoveryTemplate.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        return executeResult;
    }

    protected boolean updateSubProcessors(RecoveryProcessor processor) {
        if (null != this.getChildProc()) {
            this.getChildProc().clear();
        }
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        this.initProcessor(processor);
        subProcessors.add(processor);
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected void initProcessor(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }
}

