/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.framework.service.replica.retention.util.CheckReplicaTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class BeginLocalRecoveryProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6543915804736380219L;
    private static final Log logger = LogFactory.getInstance(BeginLocalRecoveryProcessor.class);

    public BeginLocalRecoveryProcessor() {
        this.setProcName(this.getName());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        this.setProcName(this.calcProcessName());
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan) {
            logger.error((Object)"recoveryPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).setPoRepToRecoveryPlan(recoveryPlan);
        RecoveryProcessUtil.presetCheck(context, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType()));
        this.saveInfoToContextParams(context);
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() != this.getProcType()) {
            Collection recoveryTasks = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler().getLocalRecoveryTasks(context);
            if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("ism.drm.drp.localprepare.err", null);
                return false;
            }
            context.setAttribute("recoveryTasks", (Object)recoveryTasks);
        } else {
            if (VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
                logger.error((Object)"ProtectGroups is empty.");
                throw new LegoCheckedException(1073947393L);
            }
            Iterator iterator = recoveryPlan.getProtectGroups().iterator();
            if (!iterator.hasNext()) {
                throw new LegoCheckedException(1073947393L);
            }
            int templateType = ((ProtectGroup)iterator.next()).getTemplate().getType();
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
            conditions.add(new QueryCondition("procType", (Object)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue()));
            conditions.add(new QueryCondition("protectionType", (Object)templateType));
            IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            List mountBeginProcess = rpService.getRecoveryProcessors(recoveryPlan.getPlanId(), conditions, BeginLocalRecoveryProcessor.class);
            if (!mountBeginProcess.isEmpty()) {
                recoveryPlan.getGlobalSettings().put("REPLICA_ID", ((RecoveryProcessor)mountBeginProcess.get(0)).getProps().get("REPLICA_ID"));
            }
        }
        String replicaId = (String)recoveryPlan.getGlobalSettings().get("REPLICA_ID");
        context.setAttribute("REPLICA_ID", (Object)replicaId);
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() != this.getProcType() && !CheckReplicaTools.checkSnapshotCorrect(replicaId)) {
            throw new LegoCheckedException(1073948459L);
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    private void saveInfoToContextParams(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan) {
            return;
        }
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        if (null == protectGroup) {
            return;
        }
        PolicyTemplate policyTemplate = protectGroup.getTemplate();
        if (null == policyTemplate) {
            return;
        }
        int poType = protectGroup.getPoType();
        int ptType = policyTemplate.getType();
        if (11 != poType || 2 != ptType) {
            return;
        }
    }

    @Override
    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected String calcProcessName() {
        String processName = null;
        processName = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.getValue() == this.getProcType() ? "ism.drm.recovery.prepare.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() == this.getProcType() ? "ism.drm.testing.prepare.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA.getValue() == this.getProcType() ? "ism.drm.mountReplica.prepare.process.name" : (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.UMOUNT_REPLICA.getValue() == this.getProcType() ? "ism.drm.umountReplica.prepare.process.name" : "ism.drm.clean.prepare.process.name")));
        return processName;
    }

    public void updateDescription() {
        this.setDescription("ism.drm.recovery.prepare.process.des");
    }

    public String getStepPosition() {
        return "Prepare";
    }
}

