/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ProtectGroupExecuteStatusChecker {
    private static final Log logger = LogFactory.getInstance(ProtectGroupExecuteStatusChecker.class);
    private static final int CHECK_INTERVAL = 3000;
    private boolean checkLoopFlag = true;
    private ProtectGroup protectGroup;
    private BaseRecoveryProcessor relatedProcessor;
    private String disasterSiteId;

    public ProtectGroupExecuteStatusChecker(ProtectGroup protectGroup, BaseRecoveryProcessor relatedProcessor) {
        this.protectGroup = protectGroup;
        this.relatedProcessor = relatedProcessor;
    }

    public ProtectGroupExecuteStatusChecker(ProtectGroup protectGroup, BaseRecoveryProcessor relatedProcessor, String disasterSiteId) {
        this.protectGroup = protectGroup;
        this.relatedProcessor = relatedProcessor;
        this.disasterSiteId = disasterSiteId;
    }

    public boolean startProcess() {
        return this.syncReplicationByProtectGroup();
    }

    private boolean syncReplicationByProtectGroup() {
        try {
            this.executeProtectGroup();
            this.checkProtectGroupExecuteResult();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Executing protect group failed.", (Throwable)e, 90160758784001L);
            this.relatedProcessor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            String productionSiteId = this.protectGroup.getProductSiteId();
            ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
            Site productionSite = siteService.getSiteById(productionSiteId);
            ProtectGroup curProtectGroup = this.getProtectGroup(this.protectGroup.getUuid(), productionSite);
            if (null == curProtectGroup) {
                throw new LegoCheckedException(1073947418L);
            }
            String lastExecParams = curProtectGroup.getLastExecParam();
            if (VerifyUtil.isEmpty((String)lastExecParams)) {
                this.relatedProcessor.updateProcessDetail(e);
                return false;
            }
            String[] execParams = new String[]{};
            if (!VerifyUtil.isEmpty((String)lastExecParams)) {
                execParams = lastExecParams.split(";");
            }
            this.relatedProcessor.updateProcessDetail(curProtectGroup.getLastExecErrorDetail(), execParams);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Executing protect group failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.relatedProcessor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.relatedProcessor.updateProcessDetail("lego.err.1073947418", new String[0]);
            return false;
        }
        this.relatedProcessor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    private void checkProtectGroupExecuteResult() {
        String productionSiteId = this.protectGroup.getProductSiteId();
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site productionSite = siteService.getSiteById(productionSiteId);
        int normalCount = 0;
        int runningCount = 0;
        while (this.checkLoopFlag) {
            ProtectGroup curProtectGroup = this.getProtectGroup(this.protectGroup.getUuid(), productionSite);
            if (null == curProtectGroup) {
                throw new LegoCheckedException(1073947418L);
            }
            if (curProtectGroup.isRunning()) {
                normalCount = 0;
                ++runningCount;
                CommUtil.pauseThread((long)3000L);
                continue;
            }
            if (curProtectGroup.isNormal()) {
                if (!this.checkRunningCount(runningCount, curProtectGroup) || !this.checkNormalCount(normalCount, curProtectGroup)) break;
                ++normalCount;
                CommUtil.pauseThread((long)3000L);
                continue;
            }
            throw new LegoCheckedException(1073947418L);
        }
    }

    private boolean checkNormalCount(int normalCount, ProtectGroup curProtectGroup) {
        boolean isNeedContinue = false;
        if (5 > normalCount) {
            isNeedContinue = true;
        } else {
            if (curProtectGroup.getLastExecResult() == null) {
                return 100 > normalCount;
            }
            if (1 != curProtectGroup.getLastExecResult()) {
                throw new LegoCheckedException(1073947418L);
            }
        }
        return isNeedContinue;
    }

    private boolean checkRunningCount(int runningCount, ProtectGroup curProtectGroup) {
        boolean isNeedContinue = true;
        if (0 < runningCount) {
            if (curProtectGroup.getLastExecResult() == null) {
                return isNeedContinue;
            }
            if (1 == curProtectGroup.getLastExecResult()) {
                isNeedContinue = false;
            } else {
                throw new LegoCheckedException(1073947418L);
            }
        }
        return isNeedContinue;
    }

    private void executeProtectGroup() {
        String productionSiteId;
        ISiteService siteService;
        Site productionSite;
        String sourceSiteId = this.getSourceSiteId();
        if (null == sourceSiteId || null == this.disasterSiteId) {
            logger.error((Object)"sourceSiteId Site Id or disaster Site Id is null");
            throw new LegoCheckedException(1073947393L);
        }
        List types = Arrays.stream(ScheduleProtectedType.values()).map(item -> item.getValue()).collect(Collectors.toList());
        Schedule schedule = this.protectGroup.getTemplate().getSchedules().stream().filter(item -> this.split(item.getSourceSiteId()).contains(sourceSiteId) && this.split(item.getTargetSiteId()).contains(this.disasterSiteId) && !types.contains(item.getProtectedType())).findFirst().orElse(null);
        if (null == schedule) {
            logger.error((Object)"Cannot find schedule by production site id[%s] and disaster site id[%s]", new Object[]{sourceSiteId, this.disasterSiteId});
            throw new LegoCheckedException(1073947394L);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("backupTypeAfterSync", -1);
        parameters.put("SYNC_EXECUTE_IN_RECOVERY_PROCESS", this.relatedProcessor.getProcType());
        Schedule targetSchedule = this.protectGroup.findFirstSchedule(schedule);
        if (!schedule.getScheduleId().equals(targetSchedule.getScheduleId())) {
            parameters.put("MergeProtectAction", "true");
        }
        if (1 == (productionSite = (siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(productionSiteId = this.protectGroup.getProductSiteId())).getSiteType()) {
            RestClient client = SiteUtil.initClient(productionSite);
            JSONObject message = JSONObject.fromObject(parameters);
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", this.protectGroup.getUuid());
            uriVariables.put("scheduleId", targetSchedule.getScheduleId());
            client.put("/ws/protectgroups/{protectGroupId}/schedules/{scheduleId}/action/run", message.toString(), uriVariables);
        } else {
            IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            protectGroupService.runSchedule(this.protectGroup.getUuid(), targetSchedule.getScheduleId(), parameters);
        }
    }

    private String getSourceSiteId() {
        List repList = this.protectGroup.getReplicationRelationByRecoverySiteId(this.disasterSiteId);
        if (null == repList || repList.isEmpty()) {
            return null;
        }
        ReplicationRelationBo replicationRelationBo = (ReplicationRelationBo)repList.stream().findFirst().get();
        String srcDeviceSn = replicationRelationBo.getSrcDeviceSn();
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site site = siteService.getSiteByDeviceSn(srcDeviceSn);
        if (null == site) {
            return null;
        }
        return site.getSiteId();
    }

    private Collection<String> split(String siteIds) {
        if (siteIds == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(siteIds.split(":"));
    }

    private ProtectGroup getProtectGroup(String protectGroupId, Site productionSite) {
        ProtectGroup curProtectGroup = null;
        if (1 == productionSite.getSiteType()) {
            RestClient client = SiteUtil.initClient(productionSite);
            String result = client.get("/ws/protectgroups/" + protectGroupId, null);
            try {
                JSONObject jsonObject = JSONObject.fromObject((Object)result);
                curProtectGroup = new ProtectGroup();
                curProtectGroup.setUuid(jsonObject.getString("pgId"));
                curProtectGroup.setStatus(jsonObject.getInt("status"));
                try {
                    curProtectGroup.setLastExecResult(Integer.valueOf(jsonObject.getInt("lastExecResult")));
                }
                catch (Exception e) {
                    logger.error((Object)("getProtectGroup setLastExecResult failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                    curProtectGroup.setLastExecResult(null);
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"getProtectGroup LegoCheckedException.", (Throwable)e, 90160758784001L);
                ExceptionUtil.rethrowException((Exception)((Object)e), null, (long)-1L, (String[])new String[0]);
            }
        } else {
            IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            curProtectGroup = protectGroupService.getProtectGroupByID(protectGroupId, false);
        }
        return curProtectGroup;
    }
}

