/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.recovery.process.IProtectGroupLockingCustomPreProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryPreProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public class ProtectGroupLockingPreProcessor
implements IRecoveryPreProcessor {
    private static final Log logger = LogFactory.getInstance(ProtectGroupLockingPreProcessor.class);
    private Map<String, IProtectGroupLockingCustomPreProcessor> customPreProcessors = new HashMap<String, IProtectGroupLockingCustomPreProcessor>();

    public Map<String, Object> process(RecoveryPlan plan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType) {
        if (null == plan || null == execType) {
            logger.error((Object)("plan=" + plan + ", execType=" + execType));
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupLockingCustomPreProcessor processor = this.customPreProcessors.get(execType.name());
        if (null == processor) {
            logger.info((Object)("processor is null , planId=" + plan.getUuid() + ", execType=" + execType));
            return null;
        }
        Map processResult = processor.process(plan);
        if (null == processResult) {
            return null;
        }
        logger.info((Object)(processor + ", processResult=" + processResult));
        Object lockValue = processResult.get("LockProtectGroup");
        if (null != lockValue && !((Boolean)lockValue).booleanValue()) {
            logger.error((Object)("lock ProtectGroup failed, rpId=" + plan.getUuid()));
            throw new LegoCheckedException(102401L);
        }
        return processResult;
    }

    public void clean(RecoveryPlan plan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType, Map<String, Object> preProcessResults) {
        logger.debug((Object)"preprocess.");
    }

    public void onBind(IProtectGroupLockingCustomPreProcessor preProcessor, Map<?, ?> properties) {
        this.customPreProcessors.put(preProcessor.getType(), preProcessor);
    }

    public void onUnbind(IProtectGroupLockingCustomPreProcessor preProcessor, Map<?, ?> properties) {
        this.customPreProcessors.remove(preProcessor.getType());
    }
}

