/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.recovery.process.IRecoveryPreProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Map;

public class RecoveryPreProcessorManager {
    private static final Log logger = LogFactory.getInstance(RecoveryPreProcessorManager.class);
    private static RecoveryPreProcessorManager instance = new RecoveryPreProcessorManager();
    private Map<String, IRecoveryPreProcessor> preProcessors = new HashMap<String, IRecoveryPreProcessor>();

    private RecoveryPreProcessorManager() {
    }

    public static RecoveryPreProcessorManager getInstance() {
        return instance;
    }

    public Map<String, Object> process(RecoveryPlan plan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            for (IRecoveryPreProcessor next : this.preProcessors.values()) {
                Map rst = next.process(plan, execType);
                logger.info((Object)(next + ", " + rst));
                if (null == rst) continue;
                results.putAll(rst);
            }
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("PreProcess failed, PreProcess results=" + results), (Throwable)ex);
            this.clean(plan, execType, results);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)("PreProcess failed, PreProcess results=" + results + ExceptionUtil.getErrorMessage((Throwable)ex)));
            this.clean(plan, execType, results);
            throw new LegoCheckedException(1053L, (Throwable)ex);
        }
        finally {
            logger.info((Object)("PreProcess results=" + results));
        }
        return results;
    }

    private void clean(RecoveryPlan plan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType, Map<String, Object> preProcessResults) {
        logger.info((Object)("start clean, planId=" + plan.getUuid() + ", execType=" + execType + ", results=" + preProcessResults));
        for (IRecoveryPreProcessor next : this.preProcessors.values()) {
            try {
                logger.info((Object)("call processor=" + next));
                next.clean(plan, execType, preProcessResults);
            }
            catch (Exception ex) {
                logger.error((Object)("clean failed." + ExceptionUtil.getErrorMessage((Throwable)ex)));
            }
            logger.info((Object)("step results=" + preProcessResults));
        }
        logger.info((Object)("finish clean, results=" + preProcessResults));
    }

    public void onBind(IRecoveryPreProcessor preProcessor, Map<?, ?> properties) {
        this.preProcessors.put(preProcessor.getClass().getName(), preProcessor);
    }

    public void onUnbind(IRecoveryPreProcessor preProcessor, Map<?, ?> properties) {
        this.preProcessors.remove(preProcessor.getClass().getName());
    }
}

