/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.process.IReplicationRecoveryTaskConstructor;
import com.huawei.ism.drm.recovery.framework.process.ParameterEntity;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RecoveryProcessHandler
implements IRecoveryProcessHandler,
IReplicationRecoveryTaskConstructor {
    private static Log logger = LogFactory.getInstance(RecoveryProcessHandler.class);
    private ISiteService siteService;
    private IRecoveryPlanService recoveryPlanService;
    private IRecoveryResourceService recoveryService;
    private IMoDao moDao;
    private IReplicationRecoveryTaskConstructor replicationRecoveryTaskConstructor;

    public void setSiteService(ISiteService siteService) {
        logger.trace((Object)"enter setSiteService");
        this.siteService = siteService;
    }

    public void setRecoveryPlanService(IRecoveryPlanService recoveryPlanService) {
        logger.trace((Object)"enter setRecoveryPlanService");
        this.recoveryPlanService = recoveryPlanService;
    }

    public IRecoveryPlanService getRecoveryPlanService() {
        logger.trace((Object)"enter getRecoveryPlanService");
        return this.recoveryPlanService;
    }

    public ISiteService getSiteService() {
        logger.trace((Object)"enter getSiteService");
        return this.siteService;
    }

    public void setMoDao(IMoDao moDao) {
        logger.trace((Object)"enter setMoDao");
        this.moDao = moDao;
    }

    public IMoDao getMoDao() {
        logger.trace((Object)"enter getMoDao");
        return this.moDao;
    }

    public void setRecoveryService(IRecoveryResourceService recoveryService) {
        logger.trace((Object)"enter setRecoveryService");
        this.recoveryService = recoveryService;
    }

    public IRecoveryResourceService getRecoveryService() {
        logger.trace((Object)"enter getRecoveryService");
        return this.recoveryService;
    }

    public IReplicationRecoveryTaskConstructor getReplicationRecoveryTaskConstructor() {
        return this.replicationRecoveryTaskConstructor;
    }

    public void setReplicationRecoveryTaskConstructor(IReplicationRecoveryTaskConstructor replicationRecoveryTaskConstructor) {
        this.replicationRecoveryTaskConstructor = replicationRecoveryTaskConstructor;
    }

    public boolean lockProtectGroups(Set<ProtectGroup> pgs) {
        boolean result = false;
        if (VerifyUtil.isEmpty(pgs)) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            return result;
        }
        Iterator<ProtectGroup> iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = iterator.next();
        Site productionSite = this.siteService.getSiteById(pg.getProductSiteId());
        String[] pgIds = RecoveryProcessUtil.getProtectGroupIds(pgs);
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        result = 0 == productionSite.getSiteType() ? pgService.lockProtectGroup(pgIds) : this.lockRemoteProtectGroup(productionSite, pgIds);
        logger.info((Object)("lock protect groups. Result:" + result + ",Site:" + productionSite.getName() + "Pg:" + pg.getName()), 90160758784000L);
        return result;
    }

    public boolean unlockProtectGroups(Set<ProtectGroup> pgs) {
        boolean result = false;
        if (VerifyUtil.isEmpty(pgs)) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            return result;
        }
        String[] pgIds = RecoveryProcessUtil.getProtectGroupIds(pgs);
        Iterator<ProtectGroup> iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = iterator.next();
        Site productionSite = this.siteService.getSiteById(pg.getProductSiteId());
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        if (0 == productionSite.getSiteType()) {
            for (String pgId : pgIds) {
                ProtectionJobUtil.getInstance().releaseLockPg(pgId);
            }
            result = pgService.unlockProtectGroup(pgIds);
        } else {
            result = this.unlockRemoteProtectGroup(productionSite, pgIds);
        }
        logger.info((Object)("Unlock protect groups. Result:" + result + ",Site:" + productionSite.getName() + "Pg:" + pg.getName()), 90160758784000L);
        return result;
    }

    public Collection<RecoveryTask> getRecoveryTasks(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            return new ArrayList<RecoveryTask>();
        }
        Set protectGroups = recoveryPlan.getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            logger.error((Object)("There is no protect groups. planName:" + recoveryPlan.getName()), 90160758784001L);
            return new ArrayList<RecoveryTask>();
        }
        HashMap<String, String> poAndHostMap = new HashMap<String, String>();
        HashMap<String, Integer> poAndTypeMap = new HashMap<String, Integer>();
        Map<String, String> pgAndHostMap = this.getDisasterHostOrGroupSettings(recoveryPlan.getPlanId(), recoveryPlan.getRecoverySettings());
        for (ProtectGroup protectGroup : protectGroups) {
            String hostOrGroupId = pgAndHostMap.get(protectGroup.getUuid());
            Set protectObjs = protectGroup.getPolist();
            for (ProtectObject po : protectObjs) {
                poAndHostMap.put(po.getUuid(), hostOrGroupId);
                poAndTypeMap.put(po.getUuid(), po.getPoType());
            }
        }
        ParameterEntity paramEntity = new ParameterEntity();
        paramEntity.setRecoveryPlan(recoveryPlan);
        paramEntity.setPoAndHostMap(poAndHostMap);
        paramEntity.setPoAndTypeMap(poAndTypeMap);
        HashMap<String, RecoveryTask> recoveryTasks = new HashMap<String, RecoveryTask>();
        for (ProtectGroup protectGroup : protectGroups) {
            Site productionSite = this.siteService.getSiteById(protectGroup.getProductSiteId());
            paramEntity.setProductionSite(productionSite);
            this.constructRecoveryTasks(paramEntity, protectGroup, recoveryTasks);
        }
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        int templateType = pg.getTemplate().getType();
        if (templateType == 35 || templateType == 36) {
            this.calcTaskRelation(templateType, pg, recoveryTasks.values());
        } else {
            Collection<RecoveryTask> tasks = recoveryTasks.values();
            for (RecoveryTask task : tasks) {
                this.calcTaskCascadeRelation(tasks, task);
                this.calcTaskParallelRelation(tasks, task);
            }
        }
        return recoveryTasks.values();
    }

    private void calcTaskRelation(int templateType, ProtectGroup pg, Collection<RecoveryTask> tasks) {
        String siteInfoListStr = (String)pg.getProps().get("PROP_KEY_SITE_INFO");
        if (VerifyUtil.isEmpty((String)siteInfoListStr)) {
            logger.error((Object)("4DC no site info:" + pg.getName()));
            return;
        }
        List siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class);
        if (templateType == 35) {
            List oneTaskList = tasks.stream().filter(task -> ((SiteInfo)siteInfoList.get(1)).getSiteIdSet().contains(task.getDisasterSite().getSiteId())).collect(Collectors.toList());
            List twoTaskList = tasks.stream().filter(task -> ((SiteInfo)siteInfoList.get(2)).getSiteIdSet().contains(task.getDisasterSite().getSiteId())).collect(Collectors.toList());
            oneTaskList.stream().forEach(oneTask -> {
                RecoveryTask twoTask = this.getRecoveryTaskTwo((RecoveryTask)oneTask, twoTaskList);
                oneTask.getCascadeTasks().add(twoTask);
                twoTask.setAssociatedTask(oneTask);
            });
        } else if (templateType == 36) {
            List oneTaskList = tasks.stream().filter(task -> ((SiteInfo)siteInfoList.get(1)).getSiteIdSet().contains(task.getDisasterSite().getSiteId())).collect(Collectors.toList());
            List twoTaskList = tasks.stream().filter(task -> ((SiteInfo)siteInfoList.get(2)).getSiteIdSet().contains(task.getDisasterSite().getSiteId())).collect(Collectors.toList());
            oneTaskList.stream().forEach(oneTask -> {
                RecoveryTask twoTask = this.getRecoveryTaskTwo((RecoveryTask)oneTask, twoTaskList);
                oneTask.getParallelTasks().add(twoTask);
                twoTask.setAssociatedTask(oneTask);
            });
        }
    }

    private RecoveryTask getRecoveryTaskTwo(RecoveryTask oneTask, List<RecoveryTask> twoTaskList) {
        return twoTaskList.stream().filter(task -> {
            for (String srcStorageWwn : task.getSrcStorageWwns()) {
                if (!oneTask.getSrcStorageWwns().contains(srcStorageWwn)) continue;
                return true;
            }
            return false;
        }).findFirst().get();
    }

    @Override
    public void checkRecoveryTasks(Collection<RecoveryTask> recoveryTasks, RecoveryPlan recoveryPlan, RecoveryProcessor processor) {
        if (this.replicationRecoveryTaskConstructor != null) {
            this.replicationRecoveryTaskConstructor.checkRecoveryTasks(recoveryTasks, recoveryPlan, processor);
        }
    }

    public Collection<RecoveryTask> getLocalRecoveryTasks(RecoveryProcessorContext context) {
        HashMap<String, RecoveryTask> recoveryTasks = new HashMap<String, RecoveryTask>();
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectGroupReplica pgReplica = context.getProtectGroupReplica();
        if (null == recoveryPlan || null == protectGroup || null == pgReplica) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            return new ArrayList<RecoveryTask>();
        }
        String hostOrGroupId = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        Set<ProtectObject> poList = RecoveryProcessUtil.getRecoveryProtectObjects(protectGroup, pgReplica, null);
        Map<String, String> poAndHostMap = this.constructPoAndHostMap(poList, hostOrGroupId);
        Site productionSite = this.siteService.getSiteById(RecoveryServiceUtil.getProductSiteId(recoveryPlan));
        ParameterEntity paramEntity = new ParameterEntity();
        paramEntity.setRecoveryPlan(recoveryPlan);
        paramEntity.setProductionSite(productionSite);
        paramEntity.setDisasterSite(productionSite);
        paramEntity.setPoAndHostMap(poAndHostMap);
        paramEntity.setPgReplica(pgReplica);
        Set poReplicas = pgReplica.getReplicas();
        for (ProtectObjectReplica poReplica : poReplicas) {
            this.constructLocalRecoveryTasks(paramEntity, poReplica, recoveryTasks);
        }
        return recoveryTasks.values();
    }

    public boolean setProtectGroupsInvalid(Site productionSite, Set<ProtectGroup> protectGroups, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        logger.trace((Object)"enter setProtectGroupsInvalid");
        return this.setProtectGroupsValidStatus(productionSite, protectGroups, procType, false);
    }

    public boolean setProtectGroupsValid(Site productionSite, Set<ProtectGroup> protectGroups, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        logger.trace((Object)"enter setProtectGroupsValid");
        return this.setProtectGroupsValidStatus(productionSite, protectGroups, procType, true);
    }

    private boolean setProtectGroupsValidStatus(Site productionSite, Set<ProtectGroup> protectGroups, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, boolean isValid) {
        logger.trace((Object)"enter setProtectGroupsValidStatus");
        boolean result = false;
        if (null == productionSite || VerifyUtil.isEmpty(protectGroups) || null == procType) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            return result;
        }
        List localSites = this.siteService.getAllLocalSites();
        String[] pgIds = RecoveryProcessUtil.getProtectGroupIds(protectGroups);
        if (null != localSites && localSites.contains(productionSite)) {
            result = this.changeProtectGroupValidStatus(pgIds, isValid);
        } else {
            result = this.changeProtectGroupValidStatus(productionSite, pgIds, isValid);
            if (!result && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == procType.getValue()) {
                result = this.changeProtectGroupValidStatus(pgIds, isValid);
            }
        }
        Iterator<ProtectGroup> iterator = protectGroups.iterator();
        if (iterator.hasNext()) {
            logger.info((Object)("Set protect groups valid status. Result:" + result + ",Site:" + productionSite.getName() + "Pg:" + iterator.next().getName() + ",ProcType:" + procType.getValue() + ",Status:" + isValid), 90160758784000L);
        }
        return result;
    }

    private void constructRecoveryTasks(ParameterEntity paramEntity, ProtectGroup protectGroup, Map<String, RecoveryTask> recoveryTasks) {
        logger.trace((Object)("the pg is: " + protectGroup.getName()));
        Set pgReplicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            boolean isSyncOrAsync;
            if (ProtectGroupUtil.isLocalStorageReplica(pgReplica)) continue;
            Site disasterSite = this.siteService.getSiteById(pgReplica.getRecoverySite());
            paramEntity.setDisasterSite(disasterSite);
            boolean bl = isSyncOrAsync = 1 == pgReplica.getType() || 2 == pgReplica.getType();
            if (!isSyncOrAsync) continue;
            Set poReplicas = pgReplica.getReplicas();
            for (ProtectObjectReplica poReplica : poReplicas) {
                this.constructRecoveryTasks(paramEntity, poReplica, recoveryTasks);
            }
        }
    }

    private void constructRecoveryTasks(ParameterEntity paramEntity, ProtectObjectReplica poReplica, Map<String, RecoveryTask> recoveryTasks) {
        String disasterHostId = paramEntity.getPoAndHostMap().get(poReplica.getPoId());
        logger.trace((Object)("disasterHostId is: " + disasterHostId));
        Set remoteStorageReplicas = poReplica.getStorageInfos();
        IReplicationRecoveryTaskConstructor constructor = this.replicationRecoveryTaskConstructor;
        if (constructor == null) {
            constructor = this;
        }
        for (RelicaStorageInfo remoteStorageReplica : remoteStorageReplicas) {
            constructor.constructReplicationRecoveryTask(paramEntity, (RemoteStorageReplica)remoteStorageReplica, disasterHostId, recoveryTasks);
        }
    }

    private void constructLocalRecoveryTasks(ParameterEntity paramEntity, ProtectObjectReplica poReplica, Map<String, RecoveryTask> recoveryTasks) {
        String disasterHost = paramEntity.getPoAndHostMap().get(poReplica.getPoId());
        logger.trace((Object)("disasterHost is: " + disasterHost));
        Set storageReplicas = poReplica.getStorageInfos();
        for (RelicaStorageInfo storageReplica : storageReplicas) {
            this.constructLocalRecoveryTask(paramEntity, storageReplica, disasterHost, recoveryTasks);
        }
    }

    @Override
    public void constructReplicationRecoveryTask(ParameterEntity paramEntity, RemoteStorageReplica remoteStorageReplica, String associatedHostId, Map<String, RecoveryTask> recoveryTasks) {
        ProtectGroupReplica pgReplica;
        String poId;
        logger.trace((Object)"enter constructReplicationRecoveryTask");
        String key = RecoveryProcessHandler.generateRecoveryTaskKey(remoteStorageReplica);
        RecoveryTask task = recoveryTasks.get(key);
        if (null == task) {
            task = this.createRecoveryTask(paramEntity, remoteStorageReplica);
        }
        task.getSrcStorageIds().add(remoteStorageReplica.getSrcStorageProviderSN() + ":" + remoteStorageReplica.getSrcStorageId());
        task.getTgtStorageIds().add(remoteStorageReplica.getStorageProviderSN() + ":" + remoteStorageReplica.getStorageId());
        String slaveLunIdKey = RecoveryProcessUtil.generateLunAndHostMapKey(remoteStorageReplica);
        Map lunAndHostMap = task.getLunAndHostMap();
        ArrayList<String> hosts = (ArrayList<String>)lunAndHostMap.get(slaveLunIdKey);
        if (null == hosts) {
            hosts = new ArrayList<String>();
        }
        if (null != associatedHostId && !hosts.contains(associatedHostId)) {
            hosts.add(associatedHostId);
        }
        lunAndHostMap.put(slaveLunIdKey, hosts);
        Map lunAndPoMap = task.getLunAndPoMap();
        ArrayList<String> pos = (ArrayList<String>)lunAndPoMap.get(slaveLunIdKey);
        if (null == pos) {
            pos = new ArrayList<String>();
        }
        if (!pos.contains(poId = remoteStorageReplica.getPoReplica().getPoId())) {
            pos.add(poId);
        }
        lunAndPoMap.put(slaveLunIdKey, pos);
        Map lunAndPgMap = task.getLunAndPgMap();
        ArrayList<String> pgs = (ArrayList<String>)lunAndPgMap.get(slaveLunIdKey);
        if (null == pgs) {
            pgs = new ArrayList<String>();
        }
        if (null == (pgReplica = remoteStorageReplica.getPoReplica().getPgReplica())) {
            logger.error((Object)"ProtectGroupReplica is empty");
            return;
        }
        String pgId = pgReplica.getPg().getUuid();
        if (!pgs.contains(pgId)) {
            pgs.add(pgId);
        }
        lunAndPgMap.put(slaveLunIdKey, pgs);
        task.getResourceAndTypeMap().put(slaveLunIdKey, paramEntity.getPoAndTypeMap().get(poId));
        if (null != remoteStorageReplica.getProtectObjectStorageWwn()) {
            task.getSrcStorageWwns().add(remoteStorageReplica.getProtectObjectStorageWwn());
        }
        recoveryTasks.put(key, task);
    }

    private RecoveryTask createRecoveryTask(ParameterEntity paramEntity, RemoteStorageReplica remoteStorageReplica) {
        RecoveryTask task = new RecoveryTask();
        task.setRecoveryPlanId(paramEntity.getRecoveryPlan().getPlanId());
        task.setDisasterSite(paramEntity.getDisasterSite());
        task.setProductionSite(paramEntity.getProductionSite());
        task.setSrcDeviceId(remoteStorageReplica.getSrcStorageProviderSN());
        task.setTgtDevcieId(remoteStorageReplica.getStorageProviderSN());
        if (RecoveryProcessUtil.isConsistentGroup(remoteStorageReplica)) {
            task.setProtectType(ReplicationConstantDefine.ReplicationDescription.CONSISTENT_GROUP.getValue());
            task.setProtectId(remoteStorageReplica.getConsistentGroupId());
        } else if (RecoveryProcessUtil.isVstorePair(remoteStorageReplica)) {
            task.setProtectType(ReplicationConstantDefine.ReplicationDescription.VSTORE_PAIR.getValue());
            task.setProtectId(remoteStorageReplica.getVstorePairId());
        } else {
            task.setProtectType(ReplicationConstantDefine.ReplicationDescription.HYPER_MIRROR.getValue());
            task.setProtectId(remoteStorageReplica.getReplicationPairId());
        }
        logger.trace((Object)("task is: " + task.getRecoveryPlanId()));
        return task;
    }

    private void constructLocalRecoveryTask(ParameterEntity paramEntity, RelicaStorageInfo relicaStorageInfo, String associatedHostId, Map<String, RecoveryTask> recoveryTasks) {
        String key = relicaStorageInfo.getSrcStorageProviderSN() + ":" + relicaStorageInfo.getSrcStorageId() + ":" + relicaStorageInfo.getStorageId();
        logger.trace((Object)("key is: " + key));
        RecoveryTask task = recoveryTasks.get(key);
        if (null == task) {
            task = new RecoveryTask();
            task.setRecoveryPlanId(paramEntity.getRecoveryPlan().getPlanId());
            task.setDisasterSite(paramEntity.getDisasterSite());
            task.setProductionSite(paramEntity.getProductionSite());
            task.setSrcDeviceId(relicaStorageInfo.getSrcStorageProviderSN());
            task.setTgtDevcieId(relicaStorageInfo.getStorageProviderSN());
            task.getSrcStorageIds().add(relicaStorageInfo.getSrcStorageId());
            task.getSrcStorageWwns().add(relicaStorageInfo.getProtectObjectStorageWwn());
            task.setProtectType(ReplicationConstantDefine.ReplicationDescription.UNKNOW.getValue());
            task.setProtectId(relicaStorageInfo.getStorageId());
            if (relicaStorageInfo instanceof LocalStorageReplica) {
                task.setProtectName(((LocalStorageReplica)relicaStorageInfo).getSnapshotName());
                task.setConsistentGroupId(((LocalStorageReplica)relicaStorageInfo).getConsistentGroupId());
            }
            HashMap lunAndHostMap = new HashMap();
            task.setLunAndHostMap(lunAndHostMap);
            HashMap lunAndPoMap = new HashMap();
            task.setLunAndPoMap(lunAndPoMap);
            if (null != paramEntity.getPgReplica() && paramEntity.getPgReplica().getType() == 4) {
                task.setProtectType(ReplicationConstantDefine.LocalTaskType.HYPERCDP_GROUP.getValue());
            } else if (null != paramEntity.getPgReplica() && paramEntity.getPgReplica().getType() == 3) {
                if (!VerifyUtil.isEmpty((String)task.getConsistentGroupId())) {
                    task.setProtectType(ReplicationConstantDefine.LocalTaskType.SNAPSHOT_GROUP.getValue());
                } else {
                    task.setProtectType(ReplicationConstantDefine.LocalTaskType.SNAPSHOT.getValue());
                }
            }
        }
        String slaveLunIdKey = relicaStorageInfo.getStorageId();
        Map lunAndHostMap = task.getLunAndHostMap();
        ArrayList<String> hosts = (ArrayList<String>)lunAndHostMap.get(slaveLunIdKey);
        if (null == hosts) {
            hosts = new ArrayList<String>();
        }
        if (!hosts.contains(associatedHostId)) {
            hosts.add(associatedHostId);
        }
        lunAndHostMap.put(slaveLunIdKey, hosts);
        Map lunAndPoMap = task.getLunAndPoMap();
        ArrayList<String> pos = (ArrayList<String>)lunAndPoMap.get(slaveLunIdKey);
        if (null == pos) {
            pos = new ArrayList<String>();
        }
        if (!pos.contains(relicaStorageInfo.getPoReplica().getPoId())) {
            pos.add(relicaStorageInfo.getPoReplica().getPoId());
        }
        lunAndPoMap.put(slaveLunIdKey, pos);
        recoveryTasks.put(key, task);
    }

    public static String generateRecoveryTaskKey(RemoteStorageReplica remoteStorageReplica) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(remoteStorageReplica.getSrcStorageProviderSN());
        strBuilder.append(":");
        strBuilder.append(remoteStorageReplica.getStorageProviderSN());
        strBuilder.append(":");
        strBuilder.append(remoteStorageReplica.getSynchronization());
        if (RecoveryProcessUtil.isConsistentGroup(remoteStorageReplica)) {
            strBuilder.append(":");
            strBuilder.append(remoteStorageReplica.getConsistentGroupId());
            strBuilder.append(":");
            strBuilder.append(ReplicationConstantDefine.ReplicationDescription.CONSISTENT_GROUP.getValue());
        } else if (RecoveryProcessUtil.isVstorePair(remoteStorageReplica)) {
            strBuilder.append(":");
            strBuilder.append(remoteStorageReplica.getVstorePairId());
            strBuilder.append(":");
            strBuilder.append(ReplicationConstantDefine.ReplicationDescription.VSTORE_PAIR.getValue());
        } else {
            strBuilder.append(":");
            strBuilder.append(remoteStorageReplica.getReplicationPairId());
        }
        logger.trace((Object)("strBuilder: " + strBuilder.toString()));
        return strBuilder.toString();
    }

    private boolean lockRemoteProtectGroup(Site remoteSite, String[] pgIds) {
        RestClient client = SiteUtil.initClient(remoteSite);
        try {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", pgIds[0]);
            client.invoke("/ws/protectgroups/{protectGroupId}/action/lockProtectGroup", uriVariables, HttpMethod.PUT);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("lock remote protect groups failed, pgIds=" + Arrays.asList(pgIds)), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)("lock remote protect groups failed, pgIds=" + Arrays.asList(pgIds) + ExceptionUtil.getErrorMessage((Throwable)ex)));
            throw new LegoCheckedException(102401L, (Throwable)ex);
        }
        logger.info((Object)("lock remote protect groups success, pgIds=" + Arrays.asList(pgIds) + ", site:" + remoteSite.getName()));
        return true;
    }

    private boolean unlockRemoteProtectGroup(Site remoteSite, String[] pgIds) {
        boolean result = false;
        RestClient client = SiteUtil.initClient(remoteSite);
        try {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", pgIds[0]);
            client.invoke("/ws/protectgroups/{protectGroupId}/action/unlockProtectGroup", uriVariables, HttpMethod.PUT);
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)("change protect group lock status failed. Ids:" + StringUtil.arrayToString((Object[])pgIds) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        logger.info((Object)("Set remote protect groups lock status. Result:" + result + ",Site:" + remoteSite.getName() + "Pg:" + StringUtil.arrayToString((Object[])pgIds)), 90160758784000L);
        return result;
    }

    private boolean changeProtectGroupValidStatus(Site remoteSite, String[] pgIds, boolean isValid) {
        boolean result = false;
        RestClient client = SiteUtil.initClient(remoteSite);
        try {
            HashMap<String, Object> uriVariables = new HashMap<String, Object>();
            uriVariables.put("protectGroupId", pgIds[0]);
            DrmEnumDefine.PROTECT_GROUP_STATUS pgStatus = DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL;
            if (!isValid) {
                pgStatus = DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID;
            }
            uriVariables.put("status", pgStatus.getStatus());
            client.invoke("/ws/protectgroups/{protectGroupId}/action/updateProtectGroupStatus?status={status}", uriVariables, HttpMethod.PUT);
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)("Setting protect groups valid status failed. Ids:" + StringUtil.arrayToString((Object[])pgIds) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        logger.info((Object)("Set remote protect groups valid status. Result:" + result + ",Site:" + remoteSite.getName() + "Pg:" + StringUtil.arrayToString((Object[])pgIds) + ",IsValid:" + isValid), 90160758784000L);
        return result;
    }

    private boolean changeProtectGroupValidStatus(String[] pgIds, boolean isValid) {
        boolean result = false;
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        try {
            DrmEnumDefine.PROTECT_GROUP_STATUS pgStatus = DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL;
            if (!isValid) {
                pgStatus = DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID;
            }
            pgService.updateProtectGroupStatus(pgStatus, pgIds);
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)("Setting protect groups valid status failed. Ids:" + StringUtil.arrayToString((Object[])pgIds) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        logger.info((Object)("Set protect groups valid status. Result:" + result + "Pg:" + StringUtil.arrayToString((Object[])pgIds) + ",IsValid:" + isValid), 90160758784000L);
        return result;
    }

    private Map<String, String> getDisasterHostOrGroupSettings(String planId, Set<RecoverySetting> settings) {
        logger.trace((Object)"enter getDisasterHostOrGroupSettings");
        HashMap<String, String> pgAndHostMap = new HashMap<String, String>();
        for (RecoverySetting setting : settings) {
            if (!setting.getRecoveryPlan().getPlanId().equals(planId) || !setting.getName().equals("PG_DISASTER_HOST")) continue;
            pgAndHostMap.put(setting.getOwnerId(), setting.getValue());
        }
        return pgAndHostMap;
    }

    private String generateLogMsg(String replicationId, String srcDeviceId, String tgtDeviceId, boolean isConsistentGroup) {
        logger.trace((Object)"enter generateLogMsg");
        StringBuilder logMsg = new StringBuilder();
        logMsg.append("RepId:");
        logMsg.append(replicationId);
        logMsg.append(",SrcDevId:");
        logMsg.append(srcDeviceId);
        logMsg.append(",TgtDevId:");
        logMsg.append(tgtDeviceId);
        logMsg.append(",isCG:");
        logMsg.append(isConsistentGroup);
        return logMsg.toString();
    }

    private void calcTaskParallelRelation(Collection<RecoveryTask> tasks, RecoveryTask associatedTask) {
        logger.trace((Object)"enter calcTaskParallelRelation");
        Set srcStorageIds = associatedTask.getSrcStorageIds();
        for (RecoveryTask task : tasks) {
            if (task.getTaskId().equals(associatedTask.getTaskId())) {
                logger.trace((Object)("task id is same: " + task.getTaskId()));
                continue;
            }
            Set srcStorageIds2 = task.getSrcStorageIds();
            for (String storageId : srcStorageIds2) {
                if (!srcStorageIds.contains(storageId) || null != associatedTask.getAssociatedTask() && associatedTask.getAssociatedTask().getTaskId().equals(task.getTaskId())) continue;
                associatedTask.getParallelTasks().add(task);
                task.setAssociatedTask(associatedTask);
            }
        }
    }

    private void calcTaskCascadeRelation(Collection<RecoveryTask> tasks, RecoveryTask associatedTask) {
        Set tgtStorageIds = associatedTask.getTgtStorageIds();
        for (RecoveryTask task : tasks) {
            Set srcStorageIds = task.getSrcStorageIds();
            for (String storageId : srcStorageIds) {
                if (!tgtStorageIds.contains(storageId)) continue;
                associatedTask.getCascadeTasks().add(task);
                task.setAssociatedTask(associatedTask);
            }
        }
    }

    private void checkReplicationOperationParameters(String replicationId, String srcDeviceId, String tgtDeviceId, boolean isConsistentGroup) {
        if (VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)srcDeviceId) || VerifyUtil.isEmpty((String)tgtDeviceId)) {
            logger.error((Object)("Invalid parameter." + this.generateLogMsg(replicationId, srcDeviceId, tgtDeviceId, isConsistentGroup)), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private Map<String, String> constructPoAndHostMap(Set<ProtectObject> protectObjects, String hostOrGroupId) {
        HashMap<String, String> poAndHostMap = new HashMap<String, String>();
        if (VerifyUtil.isEmpty(protectObjects) || VerifyUtil.isEmpty((String)hostOrGroupId)) {
            logger.trace((Object)("Invalid Parameters. hostOrGroupId:" + hostOrGroupId));
            return poAndHostMap;
        }
        for (ProtectObject po : protectObjects) {
            poAndHostMap.put(po.getUuid(), hostOrGroupId);
        }
        return poAndHostMap;
    }
}

