/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.cdm.usedata.sdk.service.IUseCopyDataService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanCustomStepService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.task.ReplicaOperationTask;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateMountReplicaPlanTask
extends ReplicaOperationTask {
    private static Log logger = LogFactory.getInstance(CreateMountReplicaPlanTask.class);
    private static final String PREVIOUS_SCRIPT = "mountPreProcessor";
    private static final String POST_SCRIPT = "mountPostProcessor";
    private static final String SCRIPT_NAME = "scriptName";
    private MountConfiguration mountConfigs;

    public CreateMountReplicaPlanTask(ProtectGroupReplica replica, String mountHost, User operator, MountConfiguration mountConfigs) {
        super(replica, mountHost, operator, "ism.drm.create.mount.replica.plan", true);
        String taskDescription = "Mount replica[%s] to host or host group[%s] timeout.";
        this.setTaskDescription(taskDescription);
        this.mountConfigs = mountConfigs;
    }

    protected void doWork() {
        logger.info((Object)("MountReplicaTask: Begin to mount replica(" + this.getReplica().getId() + "-" + this.getReplica().getName() + ")."));
        String hostLockId = "HOST_LOCK_PREFIX_" + this.getMountHost();
        this.tryLock(hostLockId);
        try {
            this.doWorkWithReplicaLock();
        }
        finally {
            this.releaseLock(hostLockId);
        }
    }

    private void doWorkWithReplicaLock() {
        String lockId = "REPLICA_LOCK_PREFIX_" + this.getReplica().getId();
        this.tryLock(lockId);
        IReplicaService service = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        CreateMountPlanStage mountStage = CreateMountPlanStage.READY;
        RecoveryPlan plan = null;
        try {
            ProtectGroupReplica dbReplica = service.queryProtectGroupReplicaById(this.getReplica().getId());
            this.validationReplicaInfo(dbReplica);
            plan = this.createRecoveryPlan();
            mountStage = CreateMountPlanStage.CREATED;
            this.getReplica().addProperty("planId", plan.getPlanId());
            plan.getGlobalSettings().put("PG_DISASTER_HOST", this.mountConfigs.getHostOrGroupSn());
            this.installMountScript(plan);
            mountStage = CreateMountPlanStage.CONFIGED;
            this.getReplica().setMountedHost(this.getMountHost());
            this.mountConfigs.getExtParameters().put("REPLICA_ID", this.getReplica().getId());
            this.mountConfigs.getExtParameters().put("PG_DISASTER_HOST", this.getMountHost());
            this.mountConfigs.getExtParameters().put("disasterHostSn", this.getMountHost());
            this.mountConfigs.getExtParameters().put("startDB", String.valueOf(this.mountConfigs.isStartDB()));
            this.getReplica().setMountStatus(Integer.valueOf(ReplicaMountStatus.UMOUNTED.getStatus()));
            this.getReplica().addProperty("mountConfigs", JSONObject.fromObject((Object)this.mountConfigs).toString());
            service.saveOrUpdateReplica(this.getReplica());
            mountStage = CreateMountPlanStage.REPLICA_CONFIGED;
            if (!VerifyUtil.isEmpty((String)this.mountConfigs.getStartTime())) {
                logger.info((Object)"MountReplicaTask: Begin to create schedule task(%s)", new Object[]{this.mountConfigs.getStartTime()});
                SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date startDate = sDateFormat.parse(this.mountConfigs.getStartTime(), new ParsePosition(0));
                IUseCopyDataService useCopyService = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
                useCopyService.createTask(plan, String.valueOf(startDate.getTime()));
                String message = "Create use copy data task succ, plan id is %s and name is %s";
                logger.info((Object)message, new Object[]{plan.getUuid(), plan.getName()});
            } else {
                this.startMountReplicaPlan(plan);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"MountReplicaTask error:", (Throwable)e);
            ProtectGroupReplica dbReplica = service.queryProtectGroupReplicaById(this.getReplica().getId());
            if (null != dbReplica && mountStage.getValue() == CreateMountPlanStage.REPLICA_CONFIGED.getValue()) {
                dbReplica.setMountStatus(Integer.valueOf(ReplicaMountStatus.MOUNT_FAILED.getStatus()));
                service.saveOrUpdateReplica(dbReplica);
            }
            throw e;
        }
        finally {
            this.releaseLock(lockId);
        }
    }

    private void validationReplicaInfo(ProtectGroupReplica dbReplica) {
        IRecoveryPlanService planService;
        RecoveryPlan curPlan;
        if (null == dbReplica) {
            logger.info((Object)"replica(%s) is not in DB.", new Object[]{this.getReplica().getId()});
            throw new LegoCheckedException(1073947394L, this.getReplica().getId());
        }
        if ((dbReplica.getType() != 101 || null == dbReplica.getProperty("CLOUD_REPLICA_ID")) && this.isCloudSite(this.mountConfigs.getSiteId()).booleanValue()) {
            logger.error((Object)"Not cloud replica(%s) can not mount to cloud site(%s) server.", new Object[]{dbReplica.getId(), this.mountConfigs.getSiteId()});
            throw new LegoCheckedException(0x300001L);
        }
        String planId = dbReplica.getProperty("planId");
        if (!VerifyUtil.isEmpty((String)planId) && !VerifyUtil.isEmpty((Object)(curPlan = (planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).queryRecoveryPlanWithoutAssociatedData(planId)))) {
            logger.info((Object)"replica(%s) have create mount plan(%s).", new Object[]{dbReplica.getId(), planId});
            throw new LegoCheckedException(1073948804L, new String[]{curPlan.getName()});
        }
        IUseCopyDataService copyDataService = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        copyDataService.checkMountValid(this.mountConfigs.getHostOrGroupSn(), this.getReplica().getId());
    }

    private RecoveryPlan createRecoveryPlan() {
        RecoveryPlan plan = new RecoveryPlan();
        plan.setName(this.mountConfigs.getName());
        plan.setDescription(this.mountConfigs.getDescription());
        plan.setUse(Integer.valueOf(RecoveryPlanUse.INTERNAL_USE.getValue()));
        plan.setRecoverySettings(new HashSet());
        HashMap<String, String> globalSetting = new HashMap<String, String>();
        globalSetting.put("REPLICA_ID", this.getReplica().getId());
        ProtectGroup protectGroup = this.getReplica().getPg();
        plan.setGlobalSettings(globalSetting);
        HashSet<ProtectGroup> protectGroups = new HashSet<ProtectGroup>();
        protectGroups.add(protectGroup);
        plan.setProtectGroups(protectGroups);
        IRecoveryProcessProvider provider = this.getRecoveryProcessProvider(plan);
        plan.setRecoverySettings(provider.getMountRecoverySettings(plan, this.getReplica(), this.mountConfigs));
        plan.setRecoveryTargetType(this.getRecoveryTargetType());
        if (this.getReplica().isBackUpReplica()) {
            plan.setReplicaType(Integer.valueOf(this.getReplica().getType()));
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        plan.setPlanType(DrmEnumDefine.RECOVERY_PLAN_TYPE_E.LOCAL.getValue());
        Long userID = null != protectGroup.getOwnerId() ? protectGroup.getOwnerId() : this.getOperator().getUserId();
        String planId = planService.createMultiRecoveryPlan(userID.longValue(), plan);
        plan.setPlanId(planId);
        return plan;
    }

    private void installMountScript(RecoveryPlan plan) {
        RecoveryProcessor postScript;
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType;
        if (10 == this.getReplica().getPg().getPoType()) {
            return;
        }
        if (DrmEnumDefine.RECOVERY_TARGET_TYPE.CLOUD_SERVER.getType().equals(this.getRecoveryTargetType())) {
            return;
        }
        Map<String, RecoveryProcessor> scriptProcessor = this.loadScriptProcessor();
        String planId = plan.getPlanId();
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        Set rpDefinitions = planService.getRecoveryProcesses(planId, (procType = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA).getValue());
        if (VerifyUtil.isEmpty((Collection)rpDefinitions)) {
            logger.error((Object)"The process definition does not exist.", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        Iterator iterator = rpDefinitions.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessDefinition mountProcessDefinition = (RecoveryProcessDefinition)iterator.next();
        ArrayList processorList = new ArrayList(mountProcessDefinition.getRecoveryProcessors());
        IRecoveryProcessProvider provider = this.getRecoveryProcessProvider(plan);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("type", "mountProcessor");
        filters.put("startDB", String.valueOf(this.mountConfigs.isStartDB()));
        List filteredProcessors = provider.filterProcessor(processorList, filters);
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        recoveryProcessService.updateRecoveryProcessDefinition(mountProcessDefinition);
        if (VerifyUtil.isEmpty((Collection)filteredProcessors)) {
            Object[] parameters;
            Object[] args = parameters = new String[]{this.getReplica().getId(), this.getMountHost()};
            String msg = String.format("Load mount processor failed when mount replica[%s] to host[%s].", args);
            logger.error((Object)msg, 90160758784001L);
            throw new LegoCheckedException(1073948249L, (String[])parameters, msg);
        }
        String indexProcId = ((RecoveryProcessor)filteredProcessors.get(0)).getProcId();
        RecoveryProcessor previousScript = scriptProcessor.get(PREVIOUS_SCRIPT);
        if (null != previousScript) {
            this.addMountSctiptProcessor(planId, (String)previousScript.getProps().get(SCRIPT_NAME), PREVIOUS_SCRIPT, indexProcId, true);
        }
        if (null != (postScript = scriptProcessor.get(POST_SCRIPT))) {
            this.addMountSctiptProcessor(planId, (String)postScript.getProps().get(SCRIPT_NAME), POST_SCRIPT, indexProcId, false);
        }
        Set newDefinitions = plan.getRecoveryProcesses();
        Iterator rpIterator = newDefinitions.iterator();
        while (rpIterator.hasNext()) {
            RecoveryProcessDefinition definition = (RecoveryProcessDefinition)rpIterator.next();
            if (definition.getProcType() != DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA.getValue()) continue;
            rpIterator.remove();
            break;
        }
        newDefinitions.addAll(planService.getRecoveryProcesses(planId, procType.getValue()));
        plan.setRecoveryProcesses(newDefinitions);
    }

    private void addMountSctiptProcessor(String planId, String scriptName, String processorName, String indexProcId, boolean isBefore) {
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA;
        IRecoveryPlanCustomStepService customStepService = (IRecoveryPlanCustomStepService)ServiceLocator.getInstance().getService(IRecoveryPlanCustomStepService.class);
        HashMap<String, Object> scriptProcessorParams = new HashMap<String, Object>();
        scriptProcessorParams.put("CUSTOM_PROCESSOR_NAME", processorName);
        scriptProcessorParams.put("EXECUTE_SCRIPT_NAME", scriptName);
        scriptProcessorParams.put("EXECUTE_POLICY", true);
        customStepService.addCustomRecoveryProcessor(planId, procType, scriptProcessorParams, indexProcId, isBefore);
    }

    private Map<String, RecoveryProcessor> loadScriptProcessor() {
        String jsonString = this.getReplica().getProperty("mountConfigs");
        MountConfiguration cfg = (MountConfiguration)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)jsonString), MountConfiguration.class);
        List processors = cfg.getProcessors();
        HashMap<String, RecoveryProcessor> scriptProcessor = new HashMap<String, RecoveryProcessor>();
        if (VerifyUtil.isEmpty((Collection)processors)) {
            return scriptProcessor;
        }
        for (RecoveryProcessor processor : processors) {
            if (PREVIOUS_SCRIPT.equals(processor.getProcName())) {
                scriptProcessor.put(PREVIOUS_SCRIPT, processor);
            }
            if (!POST_SCRIPT.equals(processor.getProcName())) continue;
            scriptProcessor.put(POST_SCRIPT, processor);
        }
        return scriptProcessor;
    }

    private String getRecoveryTargetType() {
        if (10 == this.getReplica().getPg().getPoType()) {
            return null;
        }
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.getMountHost());
        if (null == resource) {
            return DrmEnumDefine.RECOVERY_TARGET_TYPE.CLOUD_SERVER.getType();
        }
        return null;
    }

    private void startMountReplicaPlan(RecoveryPlan plan) {
        IUseCopyDataService copyDataService = (IUseCopyDataService)ServiceLocator.getInstance().getService(IUseCopyDataService.class);
        String planId = plan.getPlanId();
        copyDataService.mountReplica(planId, this.getReplica().getId(), this.mountConfigs, this.getOperator());
        RecoveryTaskUtil.waitRecoveryPlanCompleted(planId, DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_COMPLETED);
    }

    private IRecoveryProcessProvider getRecoveryProcessProvider(RecoveryPlan plan) {
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(plan);
        if (null == provider) {
            logger.error((Object)"provider is null.");
            throw new LegoCheckedException(1073947393L);
        }
        return provider;
    }

    private Boolean isCloudSite(String siteId) {
        if (null == siteId) {
            logger.error((Object)"Site id is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (null == site) {
            logger.error((Object)"Site(%s) is null.", new Object[]{siteId});
            throw new LegoCheckedException(201L);
        }
        return site.getIsCloudSite();
    }

    private static enum CreateMountPlanStage {
        READY(0),
        CREATED(1),
        CONFIGED(2),
        REPLICA_CONFIGED(3);

        private int value;

        private CreateMountPlanStage(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

