/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTask;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocalRecoveryBackTask
extends RecoveryBackTask {
    private static final Log logger = LogFactory.getInstance(LocalRecoveryBackTask.class);

    @Override
    protected void beforeExecuteRecoveryPlan(RecoveryProcessorContext context) {
        this.cleanRecoveryProcesses();
        int planStatus = this.getRecoveryPlanExecuteType().getPlanRunningStatus();
        Map<String, DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E> poRecoveryStatusMap = this.calcPoRecoveryStatus(context, DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)planStatus));
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(this.getRecoveryPlan().getPlanId(), planStatus, this.getRecoveryPlanExecuteType(), poRecoveryStatusMap, Integer.valueOf(0), context.getProcessStatus());
    }

    @Override
    protected void afterExecuteRecoveryPlan(boolean result, RecoveryProcessorContext context) {
        int planStatus = this.calcRecoveryPlanStatus(result, context);
        Integer planProgress = 100;
        if (!result) {
            planProgress = null;
        }
        Map<String, DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E> poRecoveryStatusMap = this.calcPoRecoveryStatus(context, DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)planStatus));
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(this.getRecoveryPlan().getPlanId(), planStatus, this.getRecoveryPlanExecuteType(), poRecoveryStatusMap, planProgress, context.getProcessStatus());
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.equals((Object)this.getRecoveryPlanExecuteType()) && DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED.equals((Object)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)planStatus))) {
            try {
                this.enableAssociatedProtectGroupsByPlan(context.getRecoveryPlan(), this.getRecoveryPlanExecuteType());
            }
            catch (Exception e) {
                logger.error((Object)("Enabling protect groups failed. PlanId:" + context.getRecoveryPlan().getPlanId()));
            }
        }
    }

    private void enableAssociatedProtectGroupsByPlan(RecoveryPlan plan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ITaskManager protectionTaskManager = (ITaskManager)ServiceLocator.getInstance().getService(ITaskManager.class);
        IProtectionTaskService taskService = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
        HashSet<ProtectGroup> invalidPgs = new HashSet<ProtectGroup>();
        for (ProtectGroup protectGroup : plan.getProtectGroups()) {
            ProtectGroup newProtectGroup = pgService.getProtectGroupByID(protectGroup.getUuid(), false);
            if (null == newProtectGroup || !newProtectGroup.isInvalid()) continue;
            List tasks = taskService.getTasks(newProtectGroup.getUuid());
            if (VerifyUtil.isEmpty((Collection)tasks)) {
                taskService.createTask(newProtectGroup);
            }
            String groupName = protectionTaskManager.getGroupName(newProtectGroup.getUuid());
            protectionTaskManager.resumeGroup(groupName);
            invalidPgs.add(newProtectGroup);
        }
        if (!VerifyUtil.isEmpty(invalidPgs)) {
            this.setProtectGroupsValid(plan, invalidPgs, procType);
        }
    }

    private void setProtectGroupsValid(RecoveryPlan plan, Set<ProtectGroup> invalidProtectGroups, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        if (null == plan || null == procType || VerifyUtil.isEmpty(invalidProtectGroups)) {
            logger.error((Object)"Invalid parameters");
            return;
        }
        RecoveryProcessorMgr processMgr = RecoveryProcessorMgr.getInstance();
        IRecoveryProcessHandler recoveryProcessHandler = processMgr.getRecoveryProcessHandler();
        String productSiteId = RecoveryServiceUtil.getProductSiteId(plan);
        Site productSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(productSiteId);
        boolean operationResult = recoveryProcessHandler.setProtectGroupsValid(productSite, invalidProtectGroups, procType);
        if (!operationResult) {
            logger.error((Object)("Setting protect group invalid failed. planId:" + plan.getPlanId()));
        }
    }

    private void cleanRecoveryProcesses() {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == this.getRecoveryPlanExecuteType().getValue()) {
            if (DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED.getValue() == this.getRecoveryPlan().getPlanStatus() || DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED.getValue() == this.getRecoveryPlan().getPlanStatus()) {
                this.cleanRecoverySubProcessor(this.getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING);
            }
        } else if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() == this.getRecoveryPlanExecuteType().getValue()) {
            this.cleanRecoverySubProcessor(this.getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING);
        } else if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.getValue() == this.getRecoveryPlanExecuteType().getValue()) {
            this.cleanRecoverySubProcessor(this.getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK);
        }
    }

    @Override
    protected DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E calcPoRecoveryStatusForAll(DrmEnumDefine.RECOVERY_PLAN_STATUS_E planStatus) {
        DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E poRecoveryStatusForAllPo = DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E.NOT_STARTED;
        switch (planStatus) {
            case ROLLBACK_COMPLETED: {
                poRecoveryStatusForAllPo = DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E.COMPLETED;
                break;
            }
            case ROLLBACK_RUNNING: {
                poRecoveryStatusForAllPo = DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E.RUNNING;
                break;
            }
            case ROLLBACK_FAILED: {
                poRecoveryStatusForAllPo = DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E.FAILED;
                break;
            }
            default: {
                poRecoveryStatusForAllPo = DrmEnumDefine.PROTECT_OBJECT_RECOVERY_STATUS_E.NOT_STARTED;
            }
        }
        return poRecoveryStatusForAllPo;
    }
}

