/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.framework.task.FixedRecoveryThreadPool;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessCascadeExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessorCallable;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;

public final class RecoveryProcessConcurrentExecutor
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(RecoveryProcessConcurrentExecutor.class);
    private List<IProcessor> processors = new ArrayList<IProcessor>();
    private String name;
    private CountDownLatch completedSignal;
    private boolean isNeedAllProcSuccessed;

    private RecoveryProcessConcurrentExecutor(int processorCount) {
        this.completedSignal = new CountDownLatch(processorCount);
    }

    public static RecoveryProcessConcurrentExecutor createExecutor(List<? extends IProcessor> processors, boolean isNeedAllProcSuccessed) {
        if (VerifyUtil.isEmpty(processors)) {
            logger.error((Object)"Processors is empty.", 90160758784001L);
            throw new LegoCheckedException(-1L);
        }
        ArrayList<RecoveryProcessor> recoveryProcessors = new ArrayList<RecoveryProcessor>();
        for (IProcessor iProcessor : processors) {
            if (!(iProcessor instanceof RecoveryProcessor)) continue;
            recoveryProcessors.add((RecoveryProcessor)iProcessor);
        }
        RecoveryServiceUtil.updateProgressRatio(recoveryProcessors);
        RecoveryProcessConcurrentExecutor executor = new RecoveryProcessConcurrentExecutor(processors.size());
        executor.processors.addAll(processors);
        executor.name = "RPCE_" + UUIDGenerator.getUUID();
        executor.isNeedAllProcSuccessed = isNeedAllProcSuccessed;
        return executor;
    }

    public static RecoveryProcessConcurrentExecutor createExecutor(List<? extends IProcessor> processors) {
        return RecoveryProcessConcurrentExecutor.createExecutor(processors, true);
    }

    public String getName() {
        return this.name;
    }

    public boolean process(RecoveryProcessorContext context) {
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
        for (IProcessor processor : this.processors) {
            if (processor instanceof RecoveryProcessor) {
                RecoveryProcessor recoveryProcessor = (RecoveryProcessor)processor;
                if (!recoveryProcessor.getIsEnabled().booleanValue()) continue;
                if (null != recoveryProcessor.getNextCascadeProcessor()) {
                    processor = RecoveryProcessCascadeExecutor.createExecutor(recoveryProcessor);
                }
            }
            RecoveryProcessorCallable processorCallable = new RecoveryProcessorCallable(processor, context, this.completedSignal);
            Future<Boolean> result = FixedRecoveryThreadPool.submit(processorCallable);
            results.add(result);
        }
        this.waitAllProcessorComplete();
        boolean processResult = this.calcProcessResult(results);
        return processResult;
    }

    private void waitAllProcessorComplete() {
        try {
            this.completedSignal.await();
        }
        catch (InterruptedException e) {
            logger.error((Object)"WaitAllProcessorComplete failed.", (Throwable)e, 90160758784001L);
        }
    }

    private boolean calcProcessResult(List<Future<Boolean>> results) {
        boolean processResult = true;
        for (Future<Boolean> result : results) {
            boolean tempResult = this.getProcessResult(result);
            if (this.isNeedAllProcSuccessed && !tempResult) {
                processResult = tempResult;
                break;
            }
            processResult = processResult || tempResult;
        }
        return processResult;
    }

    private boolean getProcessResult(Future<Boolean> result) {
        try {
            return result.get();
        }
        catch (Exception e) {
            logger.error((Object)("Getting result failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return false;
        }
    }
}

