/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessCascadeExecutor;
import com.huawei.ism.drm.recovery.framework.util.MotionPausedUtils;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class RecoveryProcessSerialExecutor
implements IProcessor {
    private static final String IS_CONFIRM_REPROTECTION = "is.confirm.reprotection";
    private final Log logger = LogFactory.getInstance((Object)this);
    private String name;
    private List<IProcessor> processors = new ArrayList<IProcessor>();
    private int curProcessorIndex = -1;

    /*
     * WARNING - void declaration
     */
    private RecoveryProcessSerialExecutor(String name, List<? extends IProcessor> processors) {
        if (name == null || processors == null || processors.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        for (IProcessor iProcessor : processors) {
            void var4_4;
            RecoveryProcessor reProcessor;
            if (iProcessor instanceof RecoveryProcessor && null != (reProcessor = (RecoveryProcessor)iProcessor).getNextCascadeProcessor()) {
                RecoveryProcessCascadeExecutor recoveryProcessCascadeExecutor = RecoveryProcessCascadeExecutor.createExecutor(reProcessor);
            }
            this.processors.add((IProcessor)var4_4);
        }
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutor(List<? extends IProcessor> recoveryProcessors, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type) {
        if (null == recoveryProcessors || recoveryProcessors.isEmpty()) {
            return null;
        }
        RecoveryProcessSerialExecutor template = new RecoveryProcessSerialExecutor(RecoveryProcessSerialExecutor.getTemplateName(), recoveryProcessors);
        return template;
    }

    private static String getTemplateName() {
        return "RCT_" + UUIDGenerator.getUUID();
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutor(Set<RecoveryProcessor> recoveryProcessors, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type) {
        if (null == recoveryProcessors || recoveryProcessors.isEmpty()) {
            return null;
        }
        List<? extends IProcessor> sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation(recoveryProcessors);
        return new RecoveryProcessSerialExecutor(RecoveryProcessSerialExecutor.getTemplateName(), sortedProcessors);
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutorSort(Set<RecoveryProcessor> recoveryProcessors) {
        if (null == recoveryProcessors || recoveryProcessors.isEmpty()) {
            return null;
        }
        List<? extends IProcessor> sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation(recoveryProcessors);
        return new RecoveryProcessSerialExecutor(RecoveryProcessSerialExecutor.getTemplateName(), sortedProcessors);
    }

    public boolean isAllProcessorCompleted() {
        return this.curProcessorIndex == this.processors.size() - 1;
    }

    public DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E getLastProcessorResult() {
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E result = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER;
        if (null != this.processors && !this.processors.isEmpty()) {
            for (int ii = this.processors.size() - 1; ii >= 0; --ii) {
                RecoveryProcessor recoveryProcessor = (RecoveryProcessor)this.processors.get(ii);
                if (!recoveryProcessor.getIsEnabled().booleanValue()) continue;
                return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.getType((int)recoveryProcessor.getProcStatus());
            }
        }
        return result;
    }

    public boolean process(RecoveryProcessorContext context) {
        return this.callProcessors(context);
    }

    public String getName() {
        return this.name;
    }

    private boolean callProcessors(RecoveryProcessorContext context) {
        IProcessor processor = null;
        boolean isNormal = true;
        try {
            int size = this.processors.size();
            for (int ii = 0; ii < size; ++ii) {
                RecoveryProcessor recoveryProcessor;
                processor = this.processors.get(ii);
                if (null == processor) continue;
                this.curProcessorIndex = ii;
                boolean isRecoveryProcessor = processor instanceof RecoveryProcessor;
                if (isRecoveryProcessor && (!(recoveryProcessor = (RecoveryProcessor)processor).getIsEnabled().booleanValue() || this.checkMotionContinue(context, recoveryProcessor))) continue;
                boolean processResult = processor.process(context);
                if (isRecoveryProcessor) {
                    RecoveryProcessor recoveryProcessor2 = (RecoveryProcessor)processor;
                    ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor(recoveryProcessor2);
                }
                if (!processResult) {
                    isNormal = false;
                } else {
                    if (!this.isMotionPaused(context, processor)) continue;
                    this.createRecoveryProcessorDetail(ii, size, context);
                }
                break;
            }
        }
        catch (Exception e) {
            String processorName = "";
            if (null != processor) {
                processorName = processor.getName();
            }
            this.logger.error((Object)("Calling processor failed. Name:" + processorName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.setContextErrorCode(context, e);
            isNormal = false;
        }
        return isNormal;
    }

    private void createRecoveryProcessorDetail(int index, int size, RecoveryProcessorContext context) {
        int nextIndex = index + 1;
        if (nextIndex == size) {
            return;
        }
        IProcessor processor = this.processors.get(nextIndex);
        boolean isBaseRecoveryProcessor = processor instanceof BaseRecoveryProcessor;
        if (!isBaseRecoveryProcessor) {
            return;
        }
        BaseRecoveryProcessor baseRecoveryProcessor = (BaseRecoveryProcessor)processor;
        this.createProcessorDetail(baseRecoveryProcessor, context, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PAUSED);
        context.setAttribute("PLAN_PROGRESS_COMPLETED_NUM", (Object)nextIndex);
    }

    public Boolean changeProcessorDetailStatus(RecoveryProcessorContext context) {
        for (IProcessor processor : this.processors) {
            boolean isRecoveryProcessor = processor instanceof RecoveryProcessor;
            if (!isRecoveryProcessor) continue;
            BaseRecoveryProcessor baseRecoveryProcessor = (BaseRecoveryProcessor)processor;
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue() != baseRecoveryProcessor.getProcStatus()) continue;
            this.createProcessorDetail(baseRecoveryProcessor, context, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED);
        }
        return false;
    }

    private void createProcessorDetail(BaseRecoveryProcessor baseRecoveryProcessor, RecoveryProcessorContext context, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E status) {
        String parentDetailId = null;
        if (baseRecoveryProcessor.getParentProc() != null) {
            parentDetailId = baseRecoveryProcessor.getParentProc().getCurProcessDetail().getDetailId();
        }
        RecoveryProcessor preProcessor = RecoveryProcessUtil.getValidPreviousProcessor(baseRecoveryProcessor);
        RecoveryProcessor nextProcessor = RecoveryProcessUtil.getValidNextProcessor(baseRecoveryProcessor);
        String previousProcId = preProcessor != null ? preProcessor.getProcId() : null;
        String nextProcId = nextProcessor != null ? nextProcessor.getProcId() : null;
        RecoveryProcessorDetail procDetail = new RecoveryProcessorDetail();
        procDetail.setLogId(context.getRecoveryLogId());
        procDetail.setProcessName(baseRecoveryProcessor.getProcName());
        procDetail.setNextProcId(nextProcId);
        procDetail.setPreviousProcId(previousProcId);
        procDetail.setParentDetailId(parentDetailId);
        procDetail.setProcId(baseRecoveryProcessor.getProcId());
        procDetail.setProcessStatus(status.getValue());
        baseRecoveryProcessor.createRecoveryProcessorDetail(procDetail);
    }

    private boolean checkMotionContinue(RecoveryProcessorContext context, RecoveryProcessor recoveryProcessor) {
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E recoveryPlanExecuteType = (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)context.getAttribute("PLAN_EXEXUTE_TYPE");
        boolean isContinue = Boolean.parseBoolean(String.valueOf(context.getAttribute("IS_CONTINUE_PROCESS")));
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.equals((Object)recoveryPlanExecuteType) && isContinue && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue() != recoveryProcessor.getProcStatus();
    }

    public boolean checkMotionCancel(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        if (context == null) {
            return false;
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E recoveryPlanExecuteType = (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)context.getAttribute("PLAN_EXEXUTE_TYPE");
        boolean isContinue = Boolean.parseBoolean(String.valueOf(context.getAttribute("IS_CONTINUE_PROCESS")));
        boolean isPaused = DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_PAUSED.getValue() == recoveryPlan.getPlanStatus();
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.equals((Object)recoveryPlanExecuteType) && !isContinue && isPaused;
    }

    private boolean isMotionPaused(RecoveryProcessorContext context, IProcessor processor) {
        this.logger.info((Object)"Current processor is %s.", new Object[]{processor.getName()});
        if (MotionPausedUtils.isMotionPaused(context) && "com.huawei.ism.drm.openstack.recovery.processor.OpenStackPowerOnVmsProcessor".equals(processor.getName())) {
            context.setAttribute("IS_PAUSED_PROCESS", (Object)true);
            if (processor instanceof RecoveryProcessor) {
                RecoveryProcessor recoveryProcessor = (RecoveryProcessor)processor;
                context.setAttribute("PLAN_PROGRESS_RATIO", (Object)recoveryProcessor.getProgressRatio());
            } else {
                context.setAttribute("PLAN_PROGRESS_RATIO", (Object)100);
            }
            return true;
        }
        return false;
    }

    private void setContextErrorCode(RecoveryProcessorContext context, Throwable ex) {
        if (ex instanceof LegoCheckedException) {
            context.setAttribute("icommand:errorcode", (Object)((LegoCheckedException)ex).getErrorCode());
        } else if (ex instanceof LegoUncheckedException) {
            context.setAttribute("icommand:errorcode", (Object)((LegoUncheckedException)ex).getErrorCode());
        } else {
            context.setAttribute("icommand:errorcode", (Object)0x200909L);
        }
    }
}

