/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.checker.manager.RecoveryProcessCheckerManager;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class RecoveryProcessUtil {
    private static Log logger = LogFactory.getInstance(RecoveryProcessUtil.class);
    private static final String ALL_RELATED_REPLICATION_PAIRS = "all-related-replication-pairs";
    private static final String STANDBY = "standby";

    private RecoveryProcessUtil() {
    }

    public static String generateLunAndHostMapKey(RemoteStorageReplica remoteStorageReplica) {
        if (VerifyUtil.isEmpty((Object)remoteStorageReplica)) {
            logger.trace((Object)"the param is null");
            return "";
        }
        String replicationId = remoteStorageReplica.getReplicationPairId();
        if (!VerifyUtil.isEmpty((String)remoteStorageReplica.getConsistentGroupId()) && !remoteStorageReplica.getConsistentGroupId().equals("--")) {
            replicationId = remoteStorageReplica.getConsistentGroupId();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(replicationId);
        builder.append(":");
        builder.append(remoteStorageReplica.getSrcStorageProviderSN());
        builder.append(":");
        builder.append(remoteStorageReplica.getSrcStorageId());
        builder.append(":");
        builder.append(remoteStorageReplica.getStorageProviderSN());
        builder.append(":");
        builder.append(remoteStorageReplica.getStorageId());
        return builder.toString();
    }

    public static String generateLunAndHostMapKey(String replicationId, String srcProviderSN, String srcStorageId, String providerSN, String storageId) {
        if (VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)srcProviderSN) || VerifyUtil.isEmpty((String)srcStorageId) || VerifyUtil.isEmpty((String)providerSN) || VerifyUtil.isEmpty((String)storageId)) {
            logger.trace((Object)"the param is null");
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(replicationId);
        builder.append(":");
        builder.append(srcProviderSN);
        builder.append(":");
        builder.append(srcStorageId);
        builder.append(":");
        builder.append(providerSN);
        builder.append(":");
        builder.append(storageId);
        return builder.toString();
    }

    public static String getSrcLunIdFromLunAndHostMapKey(String lunAndHostMapKey) {
        if (VerifyUtil.isEmpty((String)lunAndHostMapKey)) {
            logger.trace((Object)"the param is null");
            return "";
        }
        String[] strArray = lunAndHostMapKey.split(":");
        if (strArray == null || strArray.length < 3) {
            return "";
        }
        return strArray[2];
    }

    public static String getLunIdFromLunAndHostMapKey(String lunAndHostMapKey) {
        if (VerifyUtil.isEmpty((String)lunAndHostMapKey)) {
            logger.trace((Object)"the param is null");
            return "";
        }
        String[] strArray = lunAndHostMapKey.split(":");
        if (strArray == null || strArray.length < 5) {
            return "";
        }
        return strArray[4];
    }

    public static String getHostOrGroupIds(List<String> hostOrGroupIds) {
        if (VerifyUtil.isEmpty(hostOrGroupIds)) {
            logger.trace((Object)"the param is null");
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (String hostMoId : hostOrGroupIds) {
            builder.append(hostMoId);
            if (++index >= hostOrGroupIds.size()) continue;
            builder.append(":");
        }
        return builder.toString();
    }

    public static List<String> getHostOrGroupIds(String hostOrGroupIds) {
        String[] strArray;
        ArrayList<String> hostOrGroupIdList = new ArrayList<String>();
        if (VerifyUtil.isEmpty((String)hostOrGroupIds)) {
            logger.trace((Object)"the param is null");
            return hostOrGroupIdList;
        }
        for (String str : strArray = hostOrGroupIds.split(":")) {
            hostOrGroupIdList.add(str);
        }
        return hostOrGroupIdList;
    }

    public static List<Long> getHostMoIds(String hostMoIds) {
        String[] strArray;
        ArrayList<Long> hostMoIdList = new ArrayList<Long>();
        if (VerifyUtil.isEmpty((String)hostMoIds)) {
            logger.trace((Object)"the param is null");
            return hostMoIdList;
        }
        for (String str : strArray = hostMoIds.split(":")) {
            hostMoIdList.add(NumberUtil.convertToLong((Object)str));
        }
        return hostMoIdList;
    }

    public static String getPoIds(List<String> poIds) {
        if (VerifyUtil.isEmpty(poIds)) {
            logger.trace((Object)"the param is null");
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (String poId : poIds) {
            builder.append(poId);
            if (++index >= poIds.size()) continue;
            builder.append(":");
        }
        return builder.toString();
    }

    public static List<String> getPoIds(String poIds) {
        String[] strArray;
        ArrayList<String> poIdList = new ArrayList<String>();
        if (VerifyUtil.isEmpty((String)poIds)) {
            logger.trace((Object)"the param is null");
            return poIdList;
        }
        for (String str : strArray = poIds.split(":")) {
            poIdList.add(str);
        }
        return poIdList;
    }

    public static String[] getProtectGroupIds(Set<ProtectGroup> pgs) {
        if (VerifyUtil.isEmpty(pgs)) {
            logger.trace((Object)"the param is null");
            return new String[0];
        }
        String[] results = new String[pgs.size()];
        int i = 0;
        for (ProtectGroup pg : pgs) {
            results[i++] = pg.getUuid();
        }
        return results;
    }

    public static RecoveryProcessSerialExecutor createSerialExecutorWithConcurrentSubExecutor(Map<Integer, List<IProcessor>> processorsWithPriority, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, boolean isAsc) {
        int i;
        if (null == processorsWithPriority || null == type) {
            logger.trace((Object)"the param is null");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<IProcessor> iProcessors = new ArrayList<IProcessor>();
        ArrayList<RecoveryProcessConcurrentExecutor> subProcessors = new ArrayList<RecoveryProcessConcurrentExecutor>();
        ArrayList<Integer> priorityLevel = new ArrayList<Integer>();
        priorityLevel.addAll(processorsWithPriority.keySet());
        Collections.sort(priorityLevel, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        if (isAsc) {
            for (i = 0; i < priorityLevel.size(); ++i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessConcurrentExecutor executor = null;
                executor = RecoveryProcessConcurrentExecutor.createExecutor(processors, false);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        } else {
            for (i = priorityLevel.size() - 1; i >= 0; --i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessConcurrentExecutor executor = null;
                executor = RecoveryProcessConcurrentExecutor.createExecutor(processors, false);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        }
        RecoveryProcessUtil.updateProgressRatio(iProcessors);
        RecoveryProcessSerialExecutor mainExecutor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, type);
        if (null == mainExecutor) {
            logger.error((Object)"mainExecutor is null.");
            throw new LegoCheckedException(0x300001L);
        }
        return mainExecutor;
    }

    public static RecoveryProcessSerialExecutor createSerialExecutorWithSerialSubExecutor(Map<Integer, List<IProcessor>> processorsWithPriority, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type, boolean isAsc) {
        int i;
        if (null == processorsWithPriority || null == type) {
            logger.trace((Object)"the param is null");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<IProcessor> iProcessors = new ArrayList<IProcessor>();
        ArrayList<RecoveryProcessSerialExecutor> subProcessors = new ArrayList<RecoveryProcessSerialExecutor>();
        ArrayList<Integer> priorityLevel = new ArrayList<Integer>();
        priorityLevel.addAll(processorsWithPriority.keySet());
        Collections.sort(priorityLevel, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        if (isAsc) {
            for (i = 0; i < priorityLevel.size(); ++i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(processors, type);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        } else {
            for (i = priorityLevel.size() - 1; i >= 0; --i) {
                List<IProcessor> processors = processorsWithPriority.get(priorityLevel.get(i));
                RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(processors, type);
                subProcessors.add(executor);
                iProcessors.addAll(processors);
            }
        }
        RecoveryProcessUtil.updateProgressRatio(iProcessors);
        RecoveryProcessSerialExecutor mainExecutor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, type);
        return mainExecutor;
    }

    private static void updateProgressRatio(List<IProcessor> iProcessors) {
        ArrayList<RecoveryProcessor> recoveryProcessors = new ArrayList<RecoveryProcessor>();
        for (IProcessor processor : iProcessors) {
            if (!(processor instanceof RecoveryProcessor)) continue;
            recoveryProcessors.add((RecoveryProcessor)processor);
        }
        RecoveryServiceUtil.updateProgressRatio(recoveryProcessors);
    }

    public static boolean isConsistentGroup(RemoteStorageReplica remoteStorageReplica) {
        String consistentGroupId = remoteStorageReplica.getConsistentGroupId();
        boolean isConsistentGroup = false;
        if (null != consistentGroupId && 0 < consistentGroupId.length() && !consistentGroupId.equals("--")) {
            isConsistentGroup = true;
        }
        return isConsistentGroup;
    }

    public static boolean isVstorePair(RemoteStorageReplica remoteStorageReplica) {
        String vstorePairId = remoteStorageReplica.getVstorePairId();
        return !VerifyUtil.isEmpty((String)vstorePairId) && !vstorePairId.startsWith("--");
    }

    public static RecoveryProcessor getValidPreviousProcessor(RecoveryProcessor recoveryProcessor) {
        RecoveryProcessor preProcessor;
        if (null == recoveryProcessor) {
            logger.trace((Object)"the param is null");
            return null;
        }
        for (preProcessor = recoveryProcessor.getPreviousProcessor(); null != preProcessor && !preProcessor.getIsEnabled().booleanValue(); preProcessor = preProcessor.getPreviousProcessor()) {
        }
        return preProcessor;
    }

    public static RecoveryProcessor getValidNextProcessor(RecoveryProcessor recoveryProcessor) {
        RecoveryProcessor nextProcessor;
        if (null == recoveryProcessor) {
            logger.trace((Object)"the param is null");
            return null;
        }
        for (nextProcessor = recoveryProcessor.getNextProcessor(); null != nextProcessor && !nextProcessor.getIsEnabled().booleanValue(); nextProcessor = nextProcessor.getNextProcessor()) {
        }
        return nextProcessor;
    }

    public static String constructParamsString(String[] params) {
        JSONArray jsonArray = new JSONArray();
        if (null == params) {
            logger.trace((Object)"the param is null");
            return "";
        }
        for (int i = 0; i < params.length; ++i) {
            jsonArray.add((Object)params[i]);
        }
        return jsonArray.toString();
    }

    public static void addContextParam(RecoveryProcessorContext context, String key, String value) {
        if (null == context) {
            logger.error((Object)("save context param failed, context is null, key: " + key + ", value:" + value));
            return;
        }
        String contextParamsStr = (String)context.getAttribute("ContextParams");
        JSONObject contextParams = JSONObject.fromObject((Object)contextParamsStr);
        if (null == contextParams) {
            contextParams = new JSONObject();
        }
        String valueStr = "";
        if (contextParams.size() != 0 && contextParams.containsKey((Object)key) && !VerifyUtil.isEmpty((String)(valueStr = (String)contextParams.get(key)))) {
            valueStr = valueStr + ",";
        }
        contextParams.put((Object)key, (Object)(valueStr + value));
        context.setAttribute("ContextParams", (Object)contextParams.toString());
        logger.info((Object)("saved key: " + key + ", value: " + value + " to context param."));
    }

    public static void removeContextParamByKey(RecoveryProcessorContext context, String key) {
        if (null == context) {
            logger.error((Object)("delete context param failed, context is null, key: " + key));
            return;
        }
        String contextParamsStr = (String)context.getAttribute("ContextParams");
        JSONObject contextParams = JSONObject.fromObject((Object)contextParamsStr);
        if (null != contextParams) {
            contextParams.remove((Object)key);
            context.setAttribute("ContextParams", (Object)contextParams.toString());
        }
        logger.info((Object)("deleted key: " + key + " from context param."));
    }

    public static String getContextParamByKey(RecoveryProcessorContext context, String key) {
        if (null == context) {
            logger.error((Object)("delete context param failed, context is null, key: " + key));
            return null;
        }
        String contextParamsStr = (String)context.getAttribute("ContextParams");
        JSONObject contextParams = JSONObject.fromObject((Object)contextParamsStr);
        if (null == contextParams) {
            logger.error((Object)"contextParams is null");
            return null;
        }
        return (String)contextParams.get(key);
    }

    public static List<ProtectGroupReplica> getAllReplicaById(RecoveryPlan recoveryPlan, String replicaId) {
        ArrayList<ProtectGroupReplica> pgReplicas = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            for (ProtectGroupReplica pgReplica : protectGroup.getReplicaList()) {
                if (!replicaId.equals(pgReplica.getId())) continue;
                if (DrmEnumDefine.REPLICA_STATUS.ACTIVE_STATUS.getValue() != pgReplica.getStatus()) {
                    logger.error((Object)"Invalid ProtectGroupReplica status", 90160758784001L);
                    return new ArrayList<ProtectGroupReplica>();
                }
                pgReplicas.add(pgReplica);
            }
        }
        return pgReplicas;
    }

    public static Map<String, Object> convertSettingType(Map<String, String> globalSettings) {
        if (VerifyUtil.isEmpty(globalSettings)) {
            logger.trace((Object)"the param is null");
            return null;
        }
        HashMap<String, Object> convertedSettings = new HashMap<String, Object>();
        Set<Map.Entry<String, String>> settingsEntrySet = globalSettings.entrySet();
        for (Map.Entry<String, String> entry : settingsEntrySet) {
            convertedSettings.put(entry.getKey(), entry.getValue());
        }
        return convertedSettings;
    }

    public static boolean changeProtectGroupStatus(String[] pgIds, DrmEnumDefine.PROTECT_GROUP_STATUS pgStatus) {
        boolean result = false;
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        try {
            pgService.updateProtectGroupStatus(pgStatus, pgIds);
            result = true;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("Setting protect groups status failed. Ids:" + StringUtil.arrayToString((Object[])pgIds) + ExceptionUtil.getErrorMessage((Throwable)le)), 90160758784001L);
        }
        logger.info((Object)("Set protect groups status. Result:" + result + "Pg:" + StringUtil.arrayToString((Object[])pgIds) + ",pgStatus:" + pgStatus.getStatus()));
        return result;
    }

    public static Set<String> getAllWwn(Set<ProtectObject> protectObjects) {
        HashSet<String> allWwn = new HashSet<String>();
        for (ProtectObject po : protectObjects) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo posi : po.getUsedStorageResourceSet()) {
                String lunWWN = null;
                lunWWN = Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()).equals(posi.getResourceType()) ? posi.getResourceId() : posi.getLunWWN();
                if (VerifyUtil.isEmpty((String)lunWWN)) {
                    logger.error((Object)("lunWWN is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                    throw new LegoCheckedException(1073948453L);
                }
                allWwn.add(lunWWN);
            }
        }
        return allWwn;
    }

    public static Set<String> getAllSecondaryLunWwn(ProtectGroup protectGroup) {
        return RecoveryProcessUtil.getSecondaryLunWwn(protectGroup, null);
    }

    public static Set<String> getSecondaryLunWwn(ProtectGroup protectGroup, Set<String> secondarySites) {
        return new HashSet<String>();
    }

    public static void presetCheck(RecoveryProcessorContext context, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        RecoveryProcessCheckerManager rpCheckerMgr = RecoveryProcessCheckerManager.getInstance();
        List<IRecoveryProcessChecker> recoveryProcessCheckers = rpCheckerMgr.getRecoveryProcessCheckers();
        if (VerifyUtil.isEmpty(recoveryProcessCheckers)) {
            logger.error((Object)"There is no recovery process checkers.", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        for (IRecoveryProcessChecker checker : recoveryProcessCheckers) {
            checker.check(context, procType);
        }
    }

    public static DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E getProcType(String procType) {
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SWAP.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SWAP;
        }
        if (procType.equalsIgnoreCase(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA.name())) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.MOUNT_REPLICA;
        }
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.UMOUNT_REPLICA;
    }

    public static ProtectGroupReplica getProtectGroupReplicaBySiteId(ProtectGroup protectGroup, String disasterSiteId) {
        if (null == protectGroup || VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList()) || VerifyUtil.isEmpty((String)disasterSiteId)) {
            logger.error((Object)"Invalid parameters.");
            return null;
        }
        Set pgReplicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            List siteInfoList;
            Set siteIdSet;
            String siteInfoListStr;
            if (ProtectGroupUtil.isLocalStorageReplica(pgReplica)) continue;
            if (pgReplica.getRecoverySite().equals(disasterSiteId)) {
                return pgReplica;
            }
            if (20 == protectGroup.getTemplate().getType() || 24 == protectGroup.getTemplate().getType() || 27 == protectGroup.getTemplate().getType() || 32 == protectGroup.getTemplate().getType()) {
                return pgReplica;
            }
            if (35 != protectGroup.getTemplate().getType() && 36 != protectGroup.getTemplate().getType() || null == (siteInfoListStr = (String)protectGroup.getProps().get("PROP_KEY_SITE_INFO")) || null == (siteIdSet = (siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class)).stream().filter(siteInfo -> siteInfo.getSiteIdSet().contains(disasterSiteId)).findFirst().get().getSiteIdSet()) || !siteIdSet.contains(pgReplica.getRecoverySite())) continue;
            return pgReplica;
        }
        return null;
    }

    public static String getDisterSiteId(String defaultSiteId, ProtectGroup pg) {
        logger.trace((Object)"enter getDisterSiteId");
        ProtectGroupReplica rep = RecoveryProcessUtil.getProtectGroupReplicaBySiteId(pg, defaultSiteId);
        if (null != rep) {
            return rep.getRecoverySite();
        }
        return defaultSiteId;
    }

    public static ProtectGroupReplica getProtectGroupReplicaByReplicaId(ProtectGroup protectGroup, String replicaId) {
        if (null == protectGroup || VerifyUtil.isEmpty((String)replicaId)) {
            return null;
        }
        Set pgReplicas = protectGroup.getReplicaList();
        if (null == pgReplicas) {
            return null;
        }
        for (ProtectGroupReplica pgReplica : pgReplicas) {
            if (!pgReplica.getId().equals(replicaId)) continue;
            return pgReplica;
        }
        return null;
    }

    public static Set<ProtectObject> getRecoveryProtectObjects(ProtectGroup protectGroup, ProtectGroupReplica pgReplica, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E rpExecuteType) {
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Object)pgReplica)) {
            return new HashSet<ProtectObject>();
        }
        HashSet<DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E> remoteExecuteTypeSet = new HashSet<DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E>();
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING);
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING);
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY);
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION);
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION);
        remoteExecuteTypeSet.add(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT);
        HashSet<ProtectObject> result = new HashSet<ProtectObject>();
        ExecuteReplicaManager mgr = ExecuteReplicaManager.getInstance();
        if (mgr.getRealTimeReplicaPolicyType().contains(protectGroup.getTemplate().getType())) {
            if (null != rpExecuteType && remoteExecuteTypeSet.contains(rpExecuteType)) {
                result.addAll(protectGroup.getPolist());
            } else {
                Set<ProtectObjectReplica> poReplicas = RecoveryProcessUtil.getProtectObjectReplicas(pgReplica);
                for (ProtectObjectReplica poReplica : poReplicas) {
                    result.add(poReplica.getProtectObject());
                }
            }
        } else {
            result.addAll(protectGroup.getPolist());
        }
        return result;
    }

    private static Set<ProtectObjectReplica> getProtectObjectReplicas(ProtectGroupReplica pgReplica) {
        Set<ProtectObjectReplica> poReplicas;
        block3: {
            poReplicas = new HashSet();
            try {
                Iterator iterator;
                poReplicas = pgReplica.getReplicas();
                if (null != poReplicas && !(iterator = poReplicas.iterator()).hasNext()) {
                    throw new LegoCheckedException(1073947394L);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Getting po replicas from pg replica failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
                IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
                ProtectGroupReplica newPgReplica = replicaService.queryProtectGroupReplicaById(pgReplica.getId());
                if (null == newPgReplica) break block3;
                poReplicas = newPgReplica.getReplicas();
            }
        }
        return poReplicas;
    }

    public static Collection<RecoveryTask> filterRecoveryTask(RecoveryProcessorContext context, String recoveryTasksKey) {
        RecoveryProcessUtil.checkContext(context);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        RecoveryProcessUtil.checkRecoveryPlan(recoveryPlan);
        Iterator<ProtectGroup> iterator = recoveryPlan.getProtectGroups().iterator();
        RecoveryProcessUtil.checkProtectGroup(iterator);
        Collection candidates = (Collection)context.getAttribute(recoveryTasksKey);
        boolean ring = candidates.stream().anyMatch(task -> Objects.nonNull(task.getParams()) && task.getParams().containsKey(STANDBY));
        if (ring) {
            return RecoveryProcessUtil.getNormalReplicationTask(candidates);
        }
        return candidates;
    }

    private static Collection<RecoveryTask> getNormalReplicationTask(Collection<RecoveryTask> candidates) {
        ArrayList<RecoveryTask> recoverTasks = new ArrayList<RecoveryTask>();
        if (VerifyUtil.isEmpty(candidates)) {
            return recoverTasks;
        }
        for (RecoveryTask recoveryTask : candidates) {
            Map params = recoveryTask.getParams();
            if (params == null) {
                recoverTasks.add(recoveryTask);
                continue;
            }
            Object allRelatedReplicationPairs = params.get(ALL_RELATED_REPLICATION_PAIRS);
            if (!Collection.class.isInstance(allRelatedReplicationPairs)) {
                return recoverTasks;
            }
            Collection collection = (Collection)Collection.class.cast(allRelatedReplicationPairs);
            RecoveryProcessUtil.checkPairStatusConsistentByRingID(collection);
            if (((Boolean)params.get(STANDBY)).booleanValue()) continue;
            recoverTasks.add(recoveryTask);
        }
        return recoverTasks;
    }

    private static void checkPairStatusConsistentByRingID(Collection<?> collection) {
    }

    private static void checkProtectGroup(Iterator<ProtectGroup> iterator) {
        if (!iterator.hasNext()) {
            logger.error((Object)"iterator is empty");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkRecoveryPlan(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkContext(RecoveryProcessorContext context) {
        if (null == context) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }
}

