/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class RecoveryTaskUtil {
    private static Log logger = LogFactory.getInstance(RecoveryTaskUtil.class);
    private static final int TIMEOUT = 10800000;
    private static final int INTERVAL = 2000;

    private RecoveryTaskUtil() {
    }

    public static Set<RecoveryTask> getRootRecoveryTasks(Collection<RecoveryTask> recoveryTasks) {
        HashSet<RecoveryTask> tasks = new HashSet<RecoveryTask>();
        if (VerifyUtil.isEmpty(recoveryTasks)) {
            return tasks;
        }
        for (RecoveryTask recoveryTask : recoveryTasks) {
            RecoveryTask associatedTask = recoveryTask.getAssociatedTask();
            if (null == associatedTask) {
                tasks.add(recoveryTask);
                continue;
            }
            if (recoveryTasks.contains(associatedTask)) continue;
            tasks.add(recoveryTask);
        }
        return tasks;
    }

    public static Set<RecoveryTask> getRecoveryTasksByDisisaterSite(Collection<RecoveryTask> recoveryTasks, String disasterSiteId) {
        HashSet<RecoveryTask> tasks = new HashSet<RecoveryTask>();
        if (VerifyUtil.isEmpty(recoveryTasks) || null == disasterSiteId) {
            return tasks;
        }
        for (RecoveryTask recoveryTask : recoveryTasks) {
            if (!disasterSiteId.equals(recoveryTask.getDisasterSite().getSiteId())) continue;
            tasks.add(recoveryTask);
        }
        return tasks;
    }

    public static Set<RecoveryProcessor> getRootRecoveryProcessors(Collection<RecoveryProcessor> recoveryProcessors) {
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        if (VerifyUtil.isEmpty(recoveryProcessors)) {
            return processors;
        }
        for (RecoveryProcessor recoveryProcessor : recoveryProcessors) {
            if (RecoveryTaskUtil.isAssociatedByOtherProcessor(recoveryProcessors, recoveryProcessor)) continue;
            processors.add(recoveryProcessor);
        }
        return processors;
    }

    public static boolean waitRecoveryPlanCompleted(String planId, DrmEnumDefine.RECOVERY_PLAN_STATUS_E expectedStatus) {
        boolean result;
        block6: {
            Object[] parameters;
            result = false;
            IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
            long startTime = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"thread is interrupted", 90160758784001L);
                }
                RecoveryPlan latestPlan = planService.getRecoveryPlan(planId);
                if (VerifyUtil.isEmpty((Object)latestPlan)) {
                    logger.error((Object)"the latestPlan is null");
                    throw new LegoCheckedException(1073947394L);
                }
                int status = latestPlan.getPlanStatus();
                if (expectedStatus.getValue() == status) {
                    result = true;
                } else {
                    if (status != DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED.getValue() && status != DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED.getValue() && status != DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED.getValue() && status != DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED.getValue() && status != DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_FAILED.getValue() && status != DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_FAILED.getValue()) continue;
                    result = false;
                }
                break block6;
            } while (System.currentTimeMillis() - startTime < 10800000L);
            Object[] args = parameters = new String[]{planId};
            String msg = String.format("query recovery plan status timeout!", args);
            logger.error((Object)msg, 90160758784001L);
            result = false;
        }
        return result;
    }

    public static User getAdminUser() {
        IUserMgr userMgr = (IUserMgr)ServiceLocator.getInstance().getService(IUserMgr.class);
        if (null == userMgr) {
            logger.error((Object)"get user manager failed.");
            throw new LegoCheckedException(102410L);
        }
        User user = userMgr.getUserByName("admin");
        if (null == user) {
            logger.error((Object)"get admin user failed.");
            throw new LegoCheckedException(1073947393L);
        }
        return user;
    }

    private static boolean isAssociatedByOtherProcessor(Collection<RecoveryProcessor> recoveryProcessors, RecoveryProcessor recoveryProcessor) {
        if (VerifyUtil.isEmpty(recoveryProcessors) || null == recoveryProcessor) {
            return false;
        }
        for (RecoveryProcessor processor : recoveryProcessors) {
            if (null == processor.getNextCascadeProcessor() || !processor.getNextCascadeProcessor().getProcId().equals(recoveryProcessor.getProcId())) continue;
            return true;
        }
        return false;
    }
}

