/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.security.service.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.lego.comm.security.ICertificateServerCallback;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;

public class CertificateAlarmService
implements ICertificateServerCallback,
SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(CertificateAlarmService.class);

    public void success(String ipAddress, String moUuid) {
        AlarmReporter.restoreAlarm(52625444L, moUuid);
        AlarmReporter.restoreAlarm(52625445L, moUuid);
    }

    public void failForCertInvalidity(String ipAddress, String moUuid) {
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        ipInfo = ipInfo != null ? ipInfo : ipAddress;
        String[] alramParams = new String[]{ipInfo, moUuid, new LegoMoGenerator().getInstallServerIp()};
        AlarmReporter.sendAlarmForNoRepeat(52625444L, moUuid, FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.MINOR, alramParams);
    }

    public void failForCertNoTrust(String ipAddress, String moUuid) {
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        ipInfo = ipInfo != null ? ipInfo : ipAddress;
        String[] alramParams = new String[]{ipInfo, moUuid};
        AlarmReporter.sendAlarmForNoRepeat(52625445L, moUuid, FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.MINOR, alramParams);
    }

    public void failForRevokedCert(String ipAddress, Set<String> set) {
        logger.info((Object)"revoked cert:ip:%s subjectDN:%s", new Object[]{ipAddress, String.valueOf(set)});
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        ipInfo = ipInfo != null ? ipInfo : ipAddress;
        set = set == null ? new HashSet() : set;
        String[] params = new String[]{ipInfo, String.join((CharSequence)"; ", set)};
        AlarmReporter.sendAlarmForNoRepeat(52625513L, null, FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.CRITICAL, params);
    }

    public void restoreForRevokedCert(String ipAddress) {
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        ipInfo = ipInfo != null ? ipInfo : ipAddress;
        AlarmReporter.restoreAlarm(52625513L, ipInfo);
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && !LegoConfig.getInstance().isCertAlarmSwitch()) {
            this.clearCertAlarm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCertAlarm() {
        Session session = null;
        Transaction t = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            t = session.beginTransaction();
            long clearTime = System.currentTimeMillis();
            List<String> list = this.queryAlarm(session);
            if (!VerifyUtil.isEmpty(list)) {
                StringBuilder entityBuilder = new StringBuilder();
                StringBuilder idBuilder = new StringBuilder();
                for (String entity : list) {
                    if (!VerifyUtil.isEmpty((String)entityBuilder.toString())) {
                        entityBuilder.append(",");
                        idBuilder.append(",");
                    }
                    entityBuilder.append("'");
                    entityBuilder.append((Object)entity);
                    entityBuilder.append("'");
                    Object id = this.queryAnnotationMaxIdForEntiry(session, entity);
                    idBuilder.append("'");
                    idBuilder.append(id);
                    idBuilder.append("'");
                }
                this.updateAlarm(session, clearTime, entityBuilder);
                this.updateAnnotation(session, clearTime, idBuilder);
            }
            t.commit();
        }
        catch (Exception ex) {
            try {
                if (null != t) {
                    t.rollback();
                }
                logger.error((Object)("start system,clear Cert Alarm fail." + ExceptionUtil.getErrorMessage((Throwable)ex)));
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    private List<String> queryAlarm(Session session) {
        String alarmQuerySql = "select ENTITY from T_ALARM where CLEAR_STATUS='0' and (ENTITY like '%0x3230024%' or ENTITY like '%0x3230025%');";
        NativeQuery alarmSqlQuery = session.createSQLQuery(alarmQuerySql);
        List list = alarmSqlQuery.list();
        return list;
    }

    private Object queryAnnotationMaxIdForEntiry(Session session, Object entity) {
        String alarmQuerySql2 = "select max(id) from T_ANNOTATION where ENTITY = '" + entity + "';";
        NativeQuery alarmSqlQuery2 = session.createSQLQuery(alarmQuerySql2);
        Object id = alarmSqlQuery2.uniqueResult();
        return id;
    }

    private void updateAlarm(Session session, long clearTime, StringBuilder entityBuilder) {
        String updateAlarmSql = "update T_alarm set CLEAR_STATUS='1',CLEAR_USER='system',CLEAR_TIME=:clearTime where ENTITY in (" + entityBuilder.toString() + ");";
        NativeQuery updateAlarm = session.createSQLQuery(updateAlarmSql);
        updateAlarm.setParameter("clearTime", (Object)clearTime);
        updateAlarm.executeUpdate();
    }

    private void updateAnnotation(Session session, long clearTime, StringBuilder idBuilder) {
        String updateSql = "update T_ANNOTATION set CLEAR_STATUS='1',CLEAR_USER='system',CLEAR_TIME=:clearTime where id in (" + idBuilder.toString() + ");";
        NativeQuery updateAnnotationQuery = session.createSQLQuery(updateSql);
        updateAnnotationQuery.setParameter("clearTime", (Object)clearTime);
        updateAnnotationQuery.executeUpdate();
    }
}

