/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.poll;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.poll.PollControllerLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.poll.ServerPoller;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.service.impl.UpgradeRemoteServerAndSubSiteTransaction;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class GlobalServerPoller
implements IPoller {
    private Log logger = LogFactory.getInstance(GlobalServerPoller.class);
    private String uuid;

    public GlobalServerPoller(String uuid) {
        this.uuid = uuid;
    }

    public void run() {
        try {
            HashMap<String, Integer> props = new HashMap<String, Integer>();
            props.put("serverType", 1);
            props.put("status", 3);
            List replicas = CommonDAOLocator.getMoDao().findMoBy(ManagementServer.class, props);
            if (VerifyUtil.isEmpty((Collection)replicas)) {
                this.logger.debug((Object)"The specified remote server is not exsit.", 90160758784000L);
                return;
            }
            for (ManagementServer replica : replicas) {
                this.activeRemoteServer(replica);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Global server poller run failed." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758784000L);
        }
    }

    private void activeRemoteServer(ManagementServer replica) {
        try {
            RestClient client = new RestClient(replica.getIp(), replica.getPort(), replica.getUser(), replica.getPwd());
            this.logger.info((Object)("ip=" + replica.getIp() + ", port=" + replica.getPort() + ", moid=" + replica.getMoId() + ", uuid=" + replica.getUuid()), 90160758784000L);
            ManagementServer rmtServer = (ManagementServer)client.getForObject("/ws/drmservers/local", ManagementServer.class);
            IManagementServerService service = (IManagementServerService)ServiceLocator.getInstance().getService(IManagementServerService.class);
            service.validateUuidBySites(replica, replica.getIp(), Integer.valueOf(replica.getPort()), replica.getUser(), replica.getPwd());
            UpgradeRemoteServerAndSubSiteTransaction tx = new UpgradeRemoteServerAndSubSiteTransaction(replica, rmtServer.getUuid());
            tx.doInTransaction();
            ServerPoller poller = new ServerPoller(rmtServer.getUuid());
            PollControllerLocator.getInstance().getPollController().addPoller((IPoller)poller);
            AlarmReporter.restoreRemoteServerFaultAlarm(replica.getMoId());
        }
        catch (Exception ex) {
            this.logger.error((Object)("Active remote server failed, ip=" + replica.getIp() + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758784000L);
            AlarmReporter.generateRemoteServerFaultAlarm(replica.getMoId(), replica.getIp());
        }
    }

    public String getPollerID() {
        return this.uuid;
    }

    public String getPollerType() {
        return "GLOBALSERVERPOLLER";
    }
}

