/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.poll;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.poll.PollControllerLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.site.poll.GlobalServerPoller;
import com.huawei.ism.drm.site.poll.ServerPoller;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;

public class ServerPollerInitializer
implements SystemStatusChangedListener {
    private Log logger = LogFactory.getInstance(this.getClass());
    private ILicenseInter licenseService = null;

    public ILicenseInter getLicenseService() {
        return this.licenseService;
    }

    public void setLicenseService(ILicenseInter licenseService) {
        this.licenseService = licenseService;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() != Status.STATUS_STARTED) {
            return;
        }
        try {
            this.initLocalServerInfo();
            this.initRemoteServerInfo();
            this.upgradeSitesInfo();
            this.launchPoll();
            this.launchGlobalPoller();
        }
        catch (Exception e) {
            this.logger.error((Object)("init server poller fail." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786876L);
        }
        try {
            this.licenseService.getLicenseNotUpdateUseNum();
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"license invalid. start delete license....");
            this.deleteLicense();
            this.logger.error((Object)("delete old version basic license" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786876L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLicense() {
        String deleteString = "delete from T_licenseinfo";
        Session session = null;
        Transaction transaction = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            transaction = session.beginTransaction();
            NativeQuery query = session.createNativeQuery(deleteString);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception ex) {
            try {
                this.logger.error((Object)"delete license got error.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                DBOperationUtil.rollbackSession(session);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    private void initLocalServerInfo() {
        ManagementServer server = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "serverType", (Object)0);
        if (null != server) {
            return;
        }
        this.logger.info((Object)"Start Init LocalServer Info", 90160758784000L);
        server = new ManagementServer();
        server.setUuid(UUIDGenerator.getUUID());
        server.setName("LocalServer");
        server.setStatus(Integer.valueOf(0));
        server.setServerType(0);
        CommonDAOLocator.getMoDao().save((Object)server);
        this.logger.info((Object)("End Init LocalServer Info, uuid=" + server.getUuid()), 90160758784000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFromOldVersion() {
        String sql = "SELECT COLUMN_NAME FROM ALL_TAB_COLUMNS WHERE TABLE_NAME = 'TI_SITE' AND COLUMN_NAME='SITEIP'";
        Session session = null;
        List list = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery sqlQuery = session.createSQLQuery(sql);
            list = sqlQuery.list();
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("Check whether from old version failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return !VerifyUtil.isEmpty((Collection)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRemoteServerInfo() {
        List list;
        Session session;
        block8: {
            if (!this.isFromOldVersion()) {
                this.logger.info((Object)"Current system is a new one.", 90160758784000L);
                return;
            }
            this.logger.info((Object)"Current system is from an old one.", 90160758784000L);
            session = null;
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String sql = "select distinct siteip, port, username, pwd from ti_site where sitetype=? and (serverUuid is null or serverUuid='')";
            NativeQuery query = session.createSQLQuery(sql);
            query.setInteger(0, 1);
            list = query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
            if (!VerifyUtil.isEmpty((Collection)list)) break block8;
            this.logger.info((Object)"There is no site info need to transformed.", 90160758784000L);
            DBOperationUtil.closeSession(session);
            return;
        }
        try {
            HashSet<String> serverIps = new HashSet<String>();
            for (Object object : list) {
                if (!(object instanceof Map)) continue;
                Map map = (Map)object;
                String ip = (String)map.get("SITEIP");
                Integer port = NumberUtil.parseInteger(map.get("PORT"));
                String user = (String)map.get("USERNAME");
                String pwd = (String)map.get("PWD");
                if (serverIps.contains(ip)) {
                    this.logger.info((Object)("Some sites contain a same ip address, but other info is different, ip=" + ip), 90160758784000L);
                    continue;
                }
                ManagementServer remoteServer = this.constructRemoteServer(ip, port, user, pwd);
                this.logger.info((Object)("Initialize remote server, ip=" + ip + ", port=" + port), 90160758784000L);
                CommonDAOLocator.getMoDao().save((Object)remoteServer);
                serverIps.add(ip);
            }
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"Initialize remote server info failed.", 90160758784000L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    private ManagementServer constructRemoteServer(String ip, int port, String user, String pwd) {
        ManagementServer server = new ManagementServer();
        server.setUuid(UUIDGenerator.getUUID());
        server.setName("");
        server.setStatus(Integer.valueOf(3));
        server.setServerType(1);
        server.setIp(ip);
        server.setPort(port);
        server.setUser(user);
        server.setPwd(pwd);
        server.setVersion("unknow");
        return server;
    }

    private void upgradeSitesInfo() {
        this.upgradeLocalSiteInfo();
        this.upgradeRemoteSiteInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSiteNotExist(int siteType) {
        String sql = "select * from ti_site where (serverUuid is null or serverUuid='') and siteType=?";
        Session session = null;
        List list = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery sqlQuery = session.createSQLQuery(sql);
            sqlQuery.setInteger(0, siteType);
            list = sqlQuery.list();
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("Query site failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return VerifyUtil.isEmpty((Collection)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeLocalSiteInfo() {
        if (this.isSiteNotExist(0)) {
            return;
        }
        String upgradeLocalSiteSql = "update ti_site set serverUuid=(select mo.uuid from t_managedobject mo, ti_managementserver ms where mo.moid=ms.moid and ms.serverType=?) where (serverUuid is null or serverUuid='') and siteType=?";
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Transaction transaction = session.beginTransaction();
            NativeQuery sqlQuery = session.createSQLQuery(upgradeLocalSiteSql);
            sqlQuery.setInteger(0, 0);
            sqlQuery.setInteger(1, 0);
            int count = sqlQuery.executeUpdate();
            this.logger.info((Object)("Update local count is " + count), 90160758784000L);
            transaction.commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                this.logger.error((Object)("Upgrade site failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeRemoteSiteInfo() {
        if (this.isSiteNotExist(1)) {
            return;
        }
        String updateRemoteSiteSql = "update ti_site set serverUuid=(select mo.uuid from t_managedobject mo, ti_managementserver ms where mo.moid=ms.moid and ms.serverType=? and ms.ip=ti_site.siteip) where (serverUuid is null or serverUuid='') and siteType=?";
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Transaction transaction = session.beginTransaction();
            NativeQuery sqlQuery = session.createSQLQuery(updateRemoteSiteSql);
            sqlQuery.setInteger(0, 1);
            sqlQuery.setInteger(1, 1);
            int count = sqlQuery.executeUpdate();
            this.logger.info((Object)("Update remote count is " + count), 90160758784000L);
            transaction.commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                this.logger.error((Object)("Upgrade site failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    private void launchPoll() {
        List servers = CommonDAOLocator.getMoDao().getMoList(ManagementServer.class, "serverType", (Object)1);
        for (ManagementServer server : servers) {
            if (server.getStatus() == 3) {
                this.logger.info((Object)("The remote server is upgrading. uuid=" + server.getUuid() + ", ip=" + server.getIp()), 1L);
                continue;
            }
            ServerPoller poller = new ServerPoller(server.getUuid());
            PollControllerLocator.getInstance().getPollController().addPoller((IPoller)poller);
        }
    }

    private void launchGlobalPoller() {
        GlobalServerPoller poller = new GlobalServerPoller("GLOBALSERVERPOLLER:" + UUIDGenerator.getUUID());
        PollControllerLocator.getInstance().getPollController().addPoller((IPoller)poller);
    }
}

