/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.resource.service;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import java.util.List;

public class DeleteResourceBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(DeleteResourceBackTask.class);
    private List<BatchOperation> ops;

    public DeleteResourceBackTask(List<BatchOperation> ops) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)StringUtil.listToString(ops, BatchOperation::getTargetName), (String)"ism.drm.delete.resource", (String)"System", (String)"", null), true);
        this.ops = ops;
    }

    protected void doWork() {
        if (VerifyUtil.isEmpty(this.ops)) {
            logger.error((Object)"delete opeartion obj is null");
            throw new LegoCheckedException(2117645L);
        }
        String targetNames = StringUtil.listToString(this.ops, BatchOperation::getTargetName);
        logger.info((Object)"start to delete resource.target names:[%s]", new Object[]{targetNames});
        IDiscoveryService discoveryService = (IDiscoveryService)ServiceLocator.getInstance().getService(IDiscoveryService.class);
        BatchOperationResult batchOperationResult = discoveryService.deleteDeviceNew(this.ops);
        if (batchOperationResult.getFailCount() > 0 || batchOperationResult.getSucceedCount() != this.ops.size()) {
            List batchOperations = batchOperationResult.getResult();
            for (BatchOperation operation : batchOperations) {
                long errorCode = operation.getErrorCode();
                if (errorCode == 0L) continue;
                logger.error((Object)"delete resource failed. resource name:[%s]", new Object[]{operation.getTargetName()});
                throw new LegoCheckedException(errorCode);
            }
        }
        logger.info((Object)"delete resource success.target names:[%s]", new Object[]{targetNames});
    }
}

