/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.resource.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.manager.proxy.ManagedObjectManagerProxy;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.resource.service.DeleteResourceBackTask;
import com.huawei.ism.drm.site.resource.service.DiscoverResourceBackTask;
import com.huawei.ism.drm.site.resource.service.impl.ResourceDiscoveryRemoteTaskCallback;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.RemoteSiteMonitorTask;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

@Service(Name="com.huawei.ism.drm.site.resource.sdk.service.IResourceService", Desc="", Interface=IResourceService.class)
public class ResourceServiceImpl
extends IsmBaseService
implements IResourceService {
    private static final String FUSIONSTACKOPENSTACK_CACHE = "fusionSphereOpenStack_object_cache";
    private Log logger = LogFactory.getInstance((Object)((Object)this));
    private Map<String, IResourceManager> rmMapping = new ConcurrentHashMap<String, IResourceManager>();

    public void onBind(IResourceManager rm, Map<?, ?> properties) {
        this.logger.debug((Object)"onBind");
        this.rmMapping.put(rm.getResourceType(), rm);
    }

    public void onUnbind(IResourceManager rm, Map<?, ?> properties) {
        this.logger.debug((Object)"onUnbind");
        this.rmMapping.remove(rm.getResourceType());
    }

    public DrResource getDrResourceBySn(String devSn, String resType) {
        this.logger.debug((Object)("devSn=" + devSn + ", resType=" + resType));
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        return SiteResourceServiceProxy.getInstance().getSiteResourceService(resType).getDrResourceBySn(devSn);
    }

    public DrResource getDrResourceBySnInLocalSite(String devSn, String resType) {
        this.logger.debug((Object)("devSn=" + devSn + ", resType=" + resType));
        VerifyUtil.checkStrs((String[])new String[]{devSn, resType});
        DrResource resource = this.getDrResourceBySn(devSn, resType);
        VerifyUtil.checkObject((Object)resource);
        Site site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)resource.getSiteId()));
        if (null != site && 0 == site.getSiteType()) {
            return resource;
        }
        return null;
    }

    public DrResource getDrResourceBySn(String devSn) {
        this.logger.debug((Object)("devSn=" + devSn));
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrResource result = null;
        List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrResource where deviceSn=?", new Object[]{devSn});
        if (!VerifyUtil.isEmpty((Collection)resources)) {
            result = (DrResource)resources.get(0);
        }
        return result;
    }

    public <T extends ManagedObject> List<T> queryMoList(Class<T> t, Map<String, Object> queryCondition) {
        this.logger.trace((Object)"queryMoList");
        if (VerifyUtil.isEmpty(t)) {
            throw new LegoCheckedException(1073947393L);
        }
        return CommonDAOLocator.getMoDao().findMoBy(t, queryCondition);
    }

    public List<String> getResourceMainTypes(long userId) {
        ArrayList<String> types = new ArrayList<String>(SiteResourceServiceProxy.getInstance().getAllSiteResourceServiceKey());
        this.logger.debug((Object)("ResourceMainTypes: " + types));
        return types;
    }

    public <T extends Serializable> List<T> query(Class<T> clazz, Map<String, Object> queryCondition) {
        this.logger.trace((Object)"query");
        if (VerifyUtil.isEmpty(clazz)) {
            return null;
        }
        if (VerifyUtil.isEmpty(queryCondition)) {
            queryCondition = new HashMap<String, Object>(0);
        }
        List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(queryCondition);
        List createCriteria = CommonDAOLocator.getBaseDao().createCriteria(clazz, criterionList.toArray(new Criterion[criterionList.size()]));
        ArrayList<T> list = new ArrayList<T>();
        if (null != createCriteria) {
            for (Serializable s : createCriteria) {
                list.add(clazz.cast(s));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMo(ManagedObject mo) {
        if (VerifyUtil.isEmpty((Object)mo)) {
            this.logger.error((Object)"updateMo method param is null error", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            session.beginTransaction();
            DrResource resource = SiteResourceManagerUtil.getDrResourceByMoId(mo.getMoId());
            if (!VerifyUtil.isEmpty((Object)resource)) {
                resource.setName(mo.getName());
                session.update((Object)resource);
            }
            session.update((Object)mo);
            this.modifyChildName(mo);
            if (mo instanceof Host) {
                ((Host)mo).setHostName(mo.getName());
            }
            session.getTransaction().commit();
            this.logger.info((Object)("send modify managedobject message. moId:" + mo.getMoId()), 90160758784001L);
            this.sendModifyMoMessage(mo);
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Throwable)e, (String)"update mo and mo child drresour ", (long)-1L, (String[])new String[0], (Log)this.logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    private void modifyChildName(ManagedObject mo) {
        this.logger.trace((Object)"modifyChildName");
        if (mo == null || mo.getChildMos() == null) {
            return;
        }
        for (ManagedObject cmo : mo.getChildMos()) {
            if (!(cmo instanceof StorageUnit)) continue;
            cmo.setName(mo.getName());
        }
    }

    private void sendModifyMoMessage(ManagedObject mo) {
        if (VerifyUtil.isEmpty((Object)mo)) {
            this.logger.debug((Object)"mo is null,not send ModifyMoMessage.");
            return;
        }
        HashMap<String, ManagedObject> messageBody = new HashMap<String, ManagedObject>();
        messageBody.put("ModifyManagedObject", mo);
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(7005L);
        mu.setObj(messageBody);
        mu.setMt(MessageTopic.COMMAND);
        mu.setSourceAppName(((Object)((Object)this)).getClass().getName());
        ((IMessageCenter)ServiceLocator.getInstance().getService(IMessageCenter.class)).sendMessage(mu);
    }

    public void updateMgrProtocol(NeMgrProtocolExtend neMgrProtocol) {
        this.logger.trace((Object)"updateMgrProtocol");
        long moId = neMgrProtocol.getMoId();
        String mainType = this.getMainType(moId);
        IResourceManager resourceManager = this.rmMapping.get(mainType);
        if (VerifyUtil.isEmpty((Object)resourceManager)) {
            String errorMsg = "connot get resourceManager by " + mainType;
            throw new LegoCheckedException(1073947395L, errorMsg);
        }
        resourceManager.validate(neMgrProtocol);
        resourceManager.updateMgrProtocol(neMgrProtocol);
    }

    private String getMainType(long moId) {
        this.logger.debug((Object)("moId=" + moId));
        List obs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from TopoObject where moId=?", new Object[]{moId});
        if (null == obs || obs.isEmpty()) {
            throw new LegoCheckedException(1073947394L);
        }
        String mainType = ((TopoObject)obs.get(0)).getMainType();
        return mainType;
    }

    public NeMgrProtocolExtend getMgrProtocol(Long moId) {
        this.logger.debug((Object)("moId=" + moId));
        String mainType = this.getMainType(moId);
        IResourceManager resourceManager = this.rmMapping.get(mainType);
        if (VerifyUtil.isEmpty((Object)resourceManager)) {
            String errorMsg = "connot get resourceManager by " + mainType;
            throw new LegoCheckedException(1073947395L, errorMsg);
        }
        return resourceManager.getMgrProtocol(moId);
    }

    public long deleteResources(List<BatchOperation> opts) {
        DeleteResourceBackTask task = new DeleteResourceBackTask(opts);
        BackTaskHandler instance = BackTaskHandler.getInstance();
        return instance.submitTask((AbstractBackTask)task);
    }

    public long discoveryResource(DiscoveryPolicy policy) {
        long taskId = -1L;
        String siteId = policy.getLocation();
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (null == site) {
            this.logger.error((Object)("site is not exist, siteId=" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        if (site.getSiteType() == 0) {
            DiscoverResourceBackTask backtask = new DiscoverResourceBackTask(policy);
            backtask.setTimeout(ManagedObjectManagerProxy.getInstance().getMgr(policy.getDeviceType()).getTimeout());
            BackTaskHandler instance = BackTaskHandler.getInstance();
            taskId = instance.submitTask((AbstractBackTask)backtask);
        } else {
            RestClient client = SiteUtil.initClient(site);
            String uri = "/ws/resources/action/discoverResource";
            JSONArray array = new JSONArray();
            JSONObject obj = new JSONObject();
            obj.put((Object)"siteId", (Object)siteId);
            obj.put((Object)"ip", (Object)policy.getStartIP());
            obj.put((Object)"deviceType", (Object)policy.getDeviceType());
            obj.put((Object)"deviceSubType", (Object)policy.getDeviceSubType());
            obj.put((Object)"paramMap", (Object)policy.getParamMap());
            array.add((Object)obj);
            String responseString = client.post(uri, array.toString(), null);
            JSONObject resJsonObject = JSONObject.fromObject((Object)responseString);
            JSONArray records = resJsonObject.getJSONArray("result");
            JSONObject disResult = records.getJSONObject(0);
            Long remoteTaskId = NumberUtil.convertToLong((Object)disResult.getString("taskId"));
            Long errorCode = disResult.getLong("errorCode");
            if (errorCode > 0L) {
                this.logger.error((Object)errorCode);
                throw new LegoCheckedException(errorCode.longValue());
            }
            BackTask bt = BackTaskUtil.buildBackTask((String)policy.getStartIP(), (String)"ism.drm.discovery.monitor", (String)"System", (String)"", null);
            RemoteSiteMonitorTask task = new RemoteSiteMonitorTask(siteId, remoteTaskId, bt);
            task.setCallback(new ResourceDiscoveryRemoteTaskCallback(siteId));
            BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        return taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSupportResource() {
        Session session;
        Map<String, String> supportResources;
        block4: {
            supportResources = new HashMap<String, String>();
            IMoDao moDao = CommonDAOLocator.getMoDao();
            session = null;
            try {
                session = moDao.getHibernateTemplate().getSessionFactory().openSession();
                String querySQL = "select NAME, DESCRIPTION from T_MAIN_DEVICE_TYPE";
                NativeQuery query = session.createSQLQuery(querySQL);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block4;
                supportResources = this.parseSupportResoureDbData(results);
            }
            catch (Exception e) {
                try {
                    ExceptionUtil.rethrowException((Throwable)e, (String)"Querying support resource failed.", (long)-1L, (String[])new String[0], (Log)this.logger);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return supportResources;
    }

    private Map<String, String> parseSupportResoureDbData(List<?> results) {
        this.logger.trace((Object)"parseSupportResoureDbData");
        HashMap<String, String> supportResources = new HashMap<String, String>();
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 2 != (values = (Object[])object).length) continue;
            String name = String.valueOf(values[0]);
            String desc = String.valueOf(values[1]);
            supportResources.put(name, desc);
        }
        return supportResources;
    }

    public void modifyResourceSite(String resourceId, String siteId) {
        if (VerifyUtil.isEmpty((String)resourceId) || VerifyUtil.isEmpty((String)siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrResource resource = this.getDrResourceBySn(resourceId);
        if (VerifyUtil.isEmpty((Object)resource)) {
            throw new LegoCheckedException(1073947394L);
        }
        List obs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from NetworkEntity where sn=?", new Object[]{resourceId});
        if (!VerifyUtil.isEmpty((Collection)obs)) {
            NetworkEntity networkEntity = (NetworkEntity)obs.get(0);
            String mainType = networkEntity.getMainType();
            SiteResourceServiceProxy.getInstance().getSiteResourceService(mainType).isResourceUsed(networkEntity.getMoId());
        }
        try {
            resource.setSiteId(siteId);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)resource);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"unable to modify resource site", (Throwable)e, 90160758786871L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }
}

