/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.poll.PollControllerLocator;
import com.huawei.ism.cbb.proxy.protocol.tlv.constant.NetUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.ResourceUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.poll.ServerPoller;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.service.impl.DeleteRemoteServerTransactionCallback;
import com.huawei.ism.drm.site.service.impl.SyncDrmServerBackTask;
import com.huawei.ism.drm.site.service.impl.UpgradeRemoteServerAndSubSiteTransaction;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.springframework.transaction.support.TransactionCallback;

@Service(Name="com.huawei.ism.drm.site.sdk.service.IManagementServerService", Desc="", Interface=IManagementServerService.class)
public class ManagementServerServiceImpl
extends IsmBaseService
implements IManagementServerService {
    private static Log logger = LogFactory.getInstance(ManagementServerServiceImpl.class);

    public void addServer(ManagementServer server, Long userId) {
        if (null == server) {
            logger.error((Object)"server is null.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkManagementServerCount();
        ManagementServer replica = this.constructAndSaveServerInfo(server.getIp(), server.getPort(), server.getUser(), server.getPwd(), server.getDevAlias());
        SyncDrmServerBackTask task = new SyncDrmServerBackTask("ism.drm.mgmtserver.regedit", replica, true);
        task.setOperationUserId(userId);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    private void checkManagementServerCount() {
        long count = CommonDAOLocator.getBaseDao().getTotalCount("select count(moId) from ManagementServer");
        if (count >= 32L) {
            logger.error((Object)"ManagementServer is more than [%s]", 32L);
            throw new SpecCheckedException("Management_Server_quantity", 32L, count);
        }
    }

    private void validateAlias(String alias) {
        if (VerifyUtil.isNone((String)alias)) {
            return;
        }
        if (!CommUtil.checkDrmNameParam((String)alias)) {
            logger.error((Object)("alias illegal, " + alias), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        List find = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ManagementServer where devAlias=?", new Object[]{alias});
        if (null != find && !find.isEmpty()) {
            logger.error((Object)("not empty, " + alias), 90160758784000L);
            throw new LegoCheckedException(1073947392L);
        }
        ManagementServer localServerInfo = this.getServerInfo();
        if (null == localServerInfo) {
            logger.error((Object)"local info is null.", 90160758784000L);
            throw new LegoCheckedException(2117645L);
        }
        if (alias.equals(localServerInfo.getName())) {
            logger.error((Object)("alias illegal, " + alias), 90160758784000L);
            throw new LegoCheckedException(1073947392L);
        }
    }

    private void validateName(String name) {
        if (VerifyUtil.isEmpty((String)name)) {
            logger.error((Object)("name is emtpty, " + name), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmNameParam((String)name)) {
            logger.error((Object)("name illegal, " + name), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        List find = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ManagementServer where devAlias=?", new Object[]{name});
        if (null != find && !find.isEmpty()) {
            logger.error((Object)("find, devAlias=" + name), 90160758784000L);
            throw new LegoCheckedException(1073947392L);
        }
    }

    private void startServerPoller(String uuid) {
        logger.info((Object)("Start server poller, uuid=" + uuid), 90160758784000L);
        ServerPoller poller = new ServerPoller(uuid);
        PollControllerLocator.getInstance().getPollController().addPoller((IPoller)poller);
    }

    private ManagementServer constructAndSaveServerInfo(String ip, int port, String user, String pwd, String alias) {
        this.validateRemoteServerIp(ip);
        this.validatePort(port);
        this.validateAlias(alias);
        RestClient client = new RestClient(ip, port, user, pwd);
        ManagementServer remote = (ManagementServer)client.getForObject("/ws/drmservers/local", ManagementServer.class);
        this.validateVersion(remote, ip);
        if (null != this.getServer(remote.getUuid())) {
            logger.error((Object)("the server has been registered, " + remote.getUuid()), 90160758784000L);
            throw new LegoCheckedException(1073947698L);
        }
        remote.setManaged(Boolean.valueOf(true));
        remote.setServerType(1);
        remote.setIp(ip);
        remote.setDevAlias(alias);
        remote.setPort(port);
        remote.setUser(user);
        remote.setPwd(pwd);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().save((Object)remote);
        this.startServerPoller(remote.getUuid());
        return remote;
    }

    public void removeServer(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            logger.error((Object)("uuid=" + uuid), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer server = this.getServer(uuid);
        if (null == server) {
            logger.error((Object)("not found, uuid=" + uuid), 90160758784000L);
            throw new LegoCheckedException(2117645L);
        }
        if (1 != server.getServerType()) {
            logger.error((Object)("local server can not be removed, " + uuid), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List sites = siteService.getSites(uuid);
        for (Site site : sites) {
            siteService.checkSiteCanDelete(site);
        }
        PollControllerLocator.getInstance().getPollController().stopPoller(uuid, true);
        for (Site site : sites) {
            siteService.deleteSite(site.getSiteId());
        }
        DeleteRemoteServerTransactionCallback callback = new DeleteRemoteServerTransactionCallback(server);
        CommonDAOLocator.getBaseDao().getTransactionTemplate().execute((TransactionCallback)callback);
    }

    public void updateServer(ManagementServer server) {
        if (null == server) {
            logger.error((Object)"parameter is null.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer replica = this.getServer(server.getUuid());
        if (null == replica) {
            logger.error((Object)("not exsit, " + server.getUuid()), 90160758784000L);
            throw new LegoCheckedException(2117645L);
        }
        this.updateBasicInfo(replica, server.getName(), server.getDevAlias(), server.getUser());
        this.updateAuthInfo(replica, server.getIp(), server.getPort(), server.getPwd());
        CommonDAOLocator.getMoDao().getHibernateTemplate().update((Object)replica);
    }

    private void updateBasicInfo(ManagementServer replica, String newName, String newAlias, String user) {
        logger.trace((Object)"updateBasicInfo");
        int serverType = replica.getServerType();
        if (0 == serverType) {
            this.updateBasicInfoForLocal(replica, newName);
        } else if (1 == serverType) {
            this.updateBasicInfoForRemote(replica, newAlias);
            if (!VerifyUtil.isEmpty((String)user)) {
                replica.setUser(user);
            }
        }
    }

    private void updateBasicInfoForRemote(ManagementServer replica, String newAlias) {
        if (null == newAlias || newAlias.equals(replica.getDevAlias())) {
            logger.info((Object)"not changed.");
            return;
        }
        this.validateAlias(newAlias);
        replica.setDevAlias(newAlias);
    }

    private void updateBasicInfoForLocal(ManagementServer replica, String newName) {
        if (VerifyUtil.isEmpty((String)newName) || newName.equals(replica.getName())) {
            logger.info((Object)"not changed.");
            return;
        }
        this.validateName(newName);
        replica.setName(newName);
    }

    private void updateAuthInfo(ManagementServer replica, String ip, int port, String pwd) {
        if (1 != replica.getServerType()) {
            return;
        }
        if (VerifyUtil.isEmpty((String)ip) || port <= 0 || null == pwd || pwd.isEmpty()) {
            return;
        }
        this.validateRemoteServerIp(ip);
        this.validatePort(port);
        RestClient client = new RestClient(ip, port, replica.getUser(), pwd);
        ManagementServer rmtServer = (ManagementServer)client.getForObject("/ws/drmservers/local", ManagementServer.class);
        if (3 != replica.getStatus()) {
            if (!replica.getUuid().equals(rmtServer.getUuid())) {
                logger.error((Object)("uuid is different, replica=" + replica.getUuid() + ", rmtServer=" + rmtServer.getUuid()), 90160758784000L);
                throw new LegoCheckedException(1073947432L);
            }
            this.validateVersion(rmtServer, ip);
            AlarmReporter.restoreSystemVersionNotMatchAlarm(replica.getMoId());
        } else {
            this.validateUuidBySites(replica, ip, port, replica.getUser(), pwd);
            this.validateVersion(rmtServer, ip);
            UpgradeRemoteServerAndSubSiteTransaction tx = new UpgradeRemoteServerAndSubSiteTransaction(replica, rmtServer.getUuid());
            tx.doInTransaction();
            replica.setUuid(rmtServer.getUuid());
            this.startServerPoller(rmtServer.getUuid());
        }
        replica.setName(rmtServer.getName());
        replica.setStatus(Integer.valueOf(0));
        replica.setIp(ip);
        replica.setPort(port);
        replica.setPwd(pwd);
        replica.setVersion(rmtServer.getVersion());
        AlarmReporter.restoreRemoteServerFaultAlarm(replica.getMoId());
    }

    public void validateUuidBySites(ManagementServer replica, String ip, Integer port, String user, String pwd) {
        RestClient client = new RestClient(ip, port.intValue(), user, pwd);
        List sitesInRemote = client.getForObjects("/ws/sites", null, Site.class);
        if (null == sitesInRemote) {
            logger.error((Object)("Remote server has no sites, ip=" + ip));
            throw new LegoCheckedException(1073947432L);
        }
        Iterator iterator = sitesInRemote.iterator();
        while (iterator.hasNext()) {
            Site next = (Site)iterator.next();
            if (1 != next.getSiteType()) continue;
            iterator.remove();
        }
        if (sitesInRemote.isEmpty()) {
            logger.error((Object)("Remote server has no local sites, ip=" + ip));
            throw new LegoCheckedException(1073947432L);
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List sitesInDb = siteService.getSites(replica.getUuid());
        if (VerifyUtil.isEmpty((Collection)sitesInDb)) {
            logger.error((Object)("Sites in db is empty, serverUuid=" + replica.getUuid()));
            throw new LegoCheckedException(1073947432L);
        }
        for (Site siteInDb : sitesInDb) {
            for (Site siteInRemote : sitesInRemote) {
                if (!siteInDb.getSiteId().equals(siteInRemote.getSiteId())) continue;
                logger.info((Object)("match success, siteId=" + siteInDb.getSiteId()));
                return;
            }
        }
        logger.error((Object)("match failed, ip=" + ip));
        throw new LegoCheckedException(1073947432L);
    }

    public ManagementServer getServerInfo() {
        logger.trace((Object)"getServerInfo");
        ManagementServer server = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "serverType", (Object)0);
        if (null != server) {
            server.setUser(null);
            server.setPwd(null);
            String version = ResourceUtil.getValue("sysversion");
            server.setVersion(version);
        }
        return server;
    }

    public List<ManagementServer> getServers() {
        logger.trace((Object)"getServers");
        ArrayList<ManagementServer> servers = new ArrayList<ManagementServer>();
        servers.add(this.getServerInfo());
        List moList = CommonDAOLocator.getMoDao().getMoList(ManagementServer.class, "serverType", (Object)1);
        for (ManagementServer mo : moList) {
            mo.setPwd(null);
            servers.add(mo);
        }
        return servers;
    }

    public ManagementServer getServer(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            logger.error((Object)"uuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer server = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "uuid", (Object)uuid);
        return server;
    }

    public void refreshServer(String uuid, Long userId) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            logger.error((Object)"uuid is empty.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer server = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "uuid", (Object)uuid);
        if (null == server) {
            logger.error((Object)("not exist such server, uuid=" + uuid), 90160758784000L);
            throw new LegoCheckedException(2117645L);
        }
        if (1 != server.getServerType()) {
            logger.error((Object)("can not refresh local server, uuid=" + uuid), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        if (3 == server.getStatus()) {
            logger.error((Object)("can not refresh upgrading server, uuid=" + uuid), 90160758784000L);
            throw new LegoCheckedException(1073947398L, new String[]{server.getIp()});
        }
        SyncDrmServerBackTask task = new SyncDrmServerBackTask("ism.drm.mgmtserver.refresh", server, true);
        if (null != userId) {
            task.setOperationUserId(userId);
        }
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    private void validateRemoteServerIp(String serverIp) {
        NetworkInterface[] infs;
        if (!CommUtil.checkDrmIpParam((String)serverIp)) {
            logger.error((Object)("ip=" + serverIp));
            throw new LegoCheckedException(1073947393L);
        }
        for (NetworkInterface networkInterface : infs = NetUtil.availableInterface()) {
            Enumeration<InetAddress> era = networkInterface.getInetAddresses();
            while (era.hasMoreElements()) {
                InetAddress ipElement = era.nextElement();
                String ip = ipElement.getHostAddress();
                if (!serverIp.equals(ip)) continue;
                logger.error((Object)("the specified ip is a local ip: " + serverIp));
                throw new LegoCheckedException(1073947698L);
            }
        }
    }

    private void validatePort(int port) {
        if (port < 1) {
            logger.error((Object)("port=" + port));
            throw new LegoCheckedException(1073947393L);
        }
        if (port > 65535) {
            logger.error((Object)("port=" + port));
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void validateVersion(ManagementServer remote, String ip) {
        ManagementServer local = this.getServerInfo();
        if (null == local) {
            logger.error((Object)"can not find local info");
            throw new LegoCheckedException(0x200909L);
        }
        String localVersion = local.getVersion();
        String remoteVersion = remote.getVersion();
        if (localVersion != null && !localVersion.equals(remoteVersion)) {
            logger.error((Object)("version match failed, localV=" + localVersion + ", remoteV=" + remoteVersion));
            throw new LegoCheckedException(1073947695L, new String[]{ip});
        }
    }

    public String get(String uuid, String url, JSONObject pathParams, JSONObject headParams) {
        ManagementServer server = this.getServer(uuid);
        if (VerifyUtil.isEmpty((Object)server)) {
            return null;
        }
        RestClient client = SiteUtil.initClient(server);
        return client.get(url, pathParams.toMap(String.class), client.getHeaders(JSONObject.toMap((JSONObject)headParams, String.class)));
    }
}

