/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.List;

public class SyncDrmServerBackTask
extends AbstractBackTask {
    private final Log logger = LogFactory.getInstance((Object)((Object)this));
    private String serverUuid;
    private String ip;
    private int port;
    private String user;
    private String pwd;
    private Long operationUserId;

    public SyncDrmServerBackTask(String taskName, ManagementServer server, boolean visible) {
        super(server.getUuid(), BackTaskUtil.buildBackTask((String)server.getIp(), (String)taskName, (String)"System", (String)"", null), visible);
        this.serverUuid = server.getUuid();
        this.ip = server.getIp();
        this.port = server.getPort();
        this.user = server.getUser();
        this.pwd = server.getPwd();
    }

    public void doWork() {
        this.syncRemoteServerInfo();
        this.syncRemoteSites();
    }

    private ManagementServer syncRemoteServerInfo() {
        ManagementServer replica = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "uuid", (Object)this.serverUuid);
        if (null == replica) {
            throw new LegoCheckedException(2117645L);
        }
        int newStatus = 0;
        RestClient client = new RestClient(this.ip, this.port, this.user, this.pwd);
        try {
            ManagementServer remote = (ManagementServer)client.getForObject("/ws/drmservers/local", ManagementServer.class);
            if (!this.serverUuid.equals(remote.getUuid())) {
                throw new LegoCheckedException(1073947432L);
            }
            replica.setName(remote.getName());
            this.processVersionAlarm(replica, remote.getVersion());
        }
        catch (LegoCheckedException ex) {
            newStatus = this.getStatus(ex.getErrorCode());
            throw ex;
        }
        finally {
            try {
                this.processStatusAlarm(replica, newStatus);
                replica.setStatus(Integer.valueOf(newStatus));
                CommonDAOLocator.getMoDao().onlyUpdateWithoutMsg((ManagedObject)replica);
            }
            catch (Exception e) {
                this.logger.error((Object)("Synchronize remote server error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        return replica;
    }

    private void syncRemoteSites() {
        RestClient client = new RestClient(this.ip, this.port, this.user, this.pwd);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serverUuid", this.serverUuid);
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List siteReplicas = siteService.getSites(this.serverUuid);
        List sites = client.getForObjects("/ws/sites?serverUuid={serverUuid}", params, Site.class);
        for (Site replica : siteReplicas) {
            boolean deleted = true;
            for (Site site : sites) {
                if (!replica.getSiteId().equals(site.getSiteId())) continue;
                deleted = false;
                break;
            }
            if (!deleted) continue;
            siteService.deleteSite(replica.getSiteId());
        }
        for (Site site : sites) {
            Site temp = siteService.getSiteById(site.getSiteId());
            if (null == temp) {
                siteService.createSite(site, this.getOperationUserId());
                temp = siteService.getSiteById(site.getSiteId());
            }
            siteService.refreshSite(temp);
        }
        ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        licenseControl.checkLicenseOutOfControlAlarm(true);
    }

    public Long getOperationUserId() {
        return this.operationUserId;
    }

    public void setOperationUserId(Long operationUserId) {
        this.operationUserId = operationUserId;
    }

    private void processStatusAlarm(ManagementServer replica, int status) {
        if (replica.getStatus() != status) {
            String remoteIp = replica.getIp();
            if (0 == status) {
                AlarmReporter.restoreRemoteServerFaultAlarm(replica.getMoId());
            } else {
                AlarmReporter.generateRemoteServerFaultAlarm(replica.getMoId(), remoteIp);
            }
            this.sendMessageWhenServerStatusChanged(replica, status);
        }
    }

    private void sendMessageWhenServerStatusChanged(ManagementServer replica, int newStatus) {
        Integer oldStatus = replica.getStatus();
        IMessageCenter mc = (IMessageCenter)ServiceLocator.getInstance().getService(IMessageCenter.class);
        String uuid = replica.getUuid();
        HashMap<String, Integer> uuidStatusMap = new HashMap<String, Integer>();
        uuidStatusMap.put(uuid, newStatus);
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(8001L);
        mu.setObj(uuidStatusMap);
        mu.setMt(MessageTopic.COMMAND);
        mc.sendMessage(mu);
        this.logger.info((Object)("Send Disaster Manager Server status changed message, moId=" + replica.getMoId() + ", uuid=" + uuid + ",old status:" + oldStatus + ", new status:" + newStatus));
    }

    private void processVersionAlarm(ManagementServer replica, String version) {
        if (replica.getVersion().equals(version)) {
            return;
        }
        replica.setVersion(version);
        ManagementServer local = ((IManagementServerService)ServiceLocator.getInstance().getService(IManagementServerService.class)).getServerInfo();
        if (null == local) {
            throw new LegoCheckedException(2117645L);
        }
        String remoteIp = replica.getIp();
        if (local.getVersion() != null && !local.getVersion().equals(replica.getVersion())) {
            AlarmReporter.generateSystemVersionNotMatchAlarm(replica.getMoId(), remoteIp);
            throw new LegoCheckedException(1073947695L, new String[]{remoteIp});
        }
        AlarmReporter.restoreSystemVersionNotMatchAlarm(replica.getMoId());
    }

    private int getStatus(long errorCode) {
        int newStatus = 1073947659L == errorCode ? 1 : (1073947695L == errorCode ? 0 : 2);
        return newStatus;
    }
}

