/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.util;

import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.sdk.constant.DeviceType;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class DrResourceTransUtil {
    private static final List<String> HVS_REST_DEVICE_TYPE_NAMES = new ArrayList<String>();

    private DrResourceTransUtil() {
    }

    public static void updateDrStorageByArrayUnit(StorageUnit device) {
        List storages = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrStorage where deviceSn = ? and siteId in (select siteId from Site where siteType = 0)", new Object[]{device.getDevSn()});
        if (!VerifyUtil.isEmpty((Collection)storages)) {
            DrStorage storage = (DrStorage)storages.get(0);
            String linkIp = device.getLinkIp();
            if (!VerifyUtil.isEmpty((String)linkIp)) {
                storage.setIpAddress(linkIp);
            }
            if (!VerifyUtil.isEmpty((Object)device.getStatus())) {
                storage.setStatus(String.valueOf(device.getStatus()));
            }
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)storage);
        }
    }

    public static boolean isHvsRestDevice(String productModel) {
        boolean isHvsRestDevice = false;
        for (String devceType : HVS_REST_DEVICE_TYPE_NAMES) {
            if (!devceType.equalsIgnoreCase(productModel)) continue;
            isHvsRestDevice = true;
            break;
        }
        return isHvsRestDevice;
    }

    public static void updateDrStorageByXveUnit(XveUnit device) {
        DrResourceTransUtil.updateDrStorageByArrayUnit((StorageUnit)device);
    }

    static {
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.HVS85TC00.getName());
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.HVS88TC00.getName());
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.XVETV2R2.getName());
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.HVS_18500.getName());
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.HVS_18800.getName());
        HVS_REST_DEVICE_TYPE_NAMES.add(DeviceType.HVS_18800F.getName());
    }
}

