/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.service.impl;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.base.service.IsmDrmBaseService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

@Service(Name="com.huawei.ism.drm.storage.sdk.service.IStorageResourceService", Desc="", Interface=IStorageResourceService.class)
public class StorageResourceServiceImpl
extends IsmDrmBaseService
implements IStorageResourceService {
    private Log logger = LogFactory.getInstance(((Object)((Object)this)).getClass());

    public <T extends StorageResource> List<T> getStorageResources(String devSn, List<String> resourceIds, Class<T> clazz) {
        this.logger.debug((Object)("sn=" + devSn + ", resourceIds=" + resourceIds + ",clazz=" + clazz));
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", devSn);
        props.put("resourceId", resourceIds.toArray());
        List list = this.getMoDao().findMoBy(clazz, props);
        return list;
    }

    public <T extends StorageResource> T getStorageResource(String devSn, String resourceId, Class<T> clazz) {
        this.logger.debug((Object)("sn=" + devSn + ", resourceId=" + resourceId + ",clazz=" + clazz));
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)resourceId)) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", devSn);
        props.put("resourceId", resourceId);
        List list = this.getMoDao().findMoBy(clazz, props);
        if (!VerifyUtil.isEmpty((Collection)list)) {
            return (T)((StorageResource)list.get(0));
        }
        return null;
    }

    public <T extends StorageResource> List<T> getStorageResourcesByUuid(List<String> resourceUuids, Class<T> clazz) {
        this.logger.debug((Object)("resourceUuids=" + resourceUuids + ", clazz=" + clazz));
        HashMap<String, Object[]> props = new HashMap<String, Object[]>();
        props.put("uuid", resourceUuids.toArray());
        List list = this.getMoDao().findMoBy(clazz, props);
        return list;
    }
}

