/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.database;

import com.huawei.ism.drm.system.cfgdata.database.GuassDBdumpImpl;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class AESUtil {
    private static final Log logger = LogFactory.getInstance(AESUtil.class);
    private static final int LEN = 1024;
    private static final int KEY_LEN = 128;
    private static final int IV_LEN = 16;
    private static final int SM4_KEY_LEN = 16;
    private static final int ITERATION_COUNT = 50000;
    private static final String ALGORITHM_NAME_SM3 = "SM3";
    private static final String ALGORITHM_NAME_CBC_PADDING = "SM4/CBC/PKCS5Padding";
    private static final String ALGORITHM_NAME_SM4 = "SM4";
    private static final String GENERAL_CIPHER = "generalCipher";
    private static AESUtil instance = new AESUtil();

    private AESUtil() {
    }

    public static AESUtil getInstance() {
        return instance;
    }

    public Cipher initAESCipher(String sKey, int cipherMode) {
        Cipher cipher = null;
        try {
            SecureRandom saltRandom = SecureRandom.getInstance("SHA1PRNG");
            SecureRandom ivRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] salt = new byte[128];
            saltRandom.nextBytes(salt);
            byte[] iv = new byte[16];
            ivRandom.nextBytes(iv);
            new GuassDBdumpImpl().writeSaltAndIV(salt, iv);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec keyspec = new PBEKeySpec(sKey.toCharArray(), salt, 50000, 128);
            SecretKeySpec key = new SecretKeySpec(factory.generateSecret(keyspec).getEncoded(), "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(cipherMode, (Key)key, ivSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            logger.error((Object)"initAESCipher error. ErrorCode: %s", new Object[]{String.valueOf(90160758787071L)});
        }
        return cipher;
    }

    public File encryptFile(File sourceFile, String fileType, String sKey) throws IOException {
        File encryptFile;
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        CipherInputStream cipherInputStream = null;
        try {
            int nRead;
            inputStream = new FileInputStream(sourceFile);
            encryptFile = File.createTempFile("apmbackup", fileType);
            outputStream = new FileOutputStream(encryptFile);
            Cipher cipher = this.initCipher(sKey);
            cipherInputStream = new CipherInputStream(inputStream, cipher);
            byte[] cache = new byte[1024];
            while ((nRead = cipherInputStream.read(cache)) != -1) {
                ((OutputStream)outputStream).write(cache, 0, nRead);
                outputStream.flush();
            }
            this.doCloseStream(inputStream, outputStream, cipherInputStream);
        }
        catch (IOException e) {
            try {
                logger.error((Object)"encryptFile error. errorCode: %s", new Object[]{String.valueOf(90160758787071L)});
                throw e;
            }
            catch (Throwable throwable) {
                this.doCloseStream(inputStream, outputStream, cipherInputStream);
                throw throwable;
            }
        }
        return encryptFile;
    }

    private Cipher initCipher(String sKey) {
        Cipher cipher = GENERAL_CIPHER.equals(LegoConfig.getInstance().getKeyValue("cipher.type", GENERAL_CIPHER)) ? this.initAESCipher(sKey, 1) : this.initSM4Cipher(sKey);
        return cipher;
    }

    private Cipher initSM4Cipher(String sKey) {
        Cipher cipher = null;
        try {
            this.addBCProvider();
            SecureRandom ivRandom = new SecureRandom();
            byte[] iv = new byte[16];
            ivRandom.nextBytes(iv);
            new GuassDBdumpImpl().writeIVFile(iv);
            MessageDigest digest = MessageDigest.getInstance(ALGORITHM_NAME_SM3, "BC");
            byte[] key = digest.digest(sKey.getBytes(StandardCharsets.UTF_8));
            byte[] keyData = Arrays.copyOfRange(key, 0, 16);
            cipher = Cipher.getInstance(ALGORITHM_NAME_CBC_PADDING, "BC");
            SecretKeySpec sm4Key = new SecretKeySpec(keyData, ALGORITHM_NAME_SM4);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(1, (Key)sm4Key, ivParameterSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            logger.error((Object)"initSM4Cipher error. ErrorCode: %s", new Object[]{String.valueOf(90160758787071L)});
        }
        return cipher;
    }

    private void addBCProvider() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private void doCloseStream(InputStream inputStream, OutputStream outputStream, CipherInputStream cipherInputStream) {
        try {
            if (null != cipherInputStream) {
                cipherInputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"encryptFile cipherInputStream close error. ErrorCode: %s", new Object[]{String.valueOf(90160758787071L)});
        }
        try {
            if (null != outputStream) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"encryptFile close error. ErrorCode: %s", new Object[]{String.valueOf(90160758787071L)});
        }
        try {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"encryptFile close error. ErrorCode: %s", new Object[]{String.valueOf(90160758787071L)});
        }
    }
}

