/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.database;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.drm.system.cfgdata.sdk.model.FtpServerInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class ConfigDataDao {
    private static final Log logger = LogFactory.getInstance(ConfigDataDao.class);
    private IBaseDao<Object, Serializable> dao;

    public IBaseDao<Object, Serializable> getDao() {
        return this.dao;
    }

    public void setDao(IBaseDao<Object, Serializable> dao) {
        this.dao = dao;
    }

    public void saveToDB(FtpServerInfo ftpInfo) {
        try {
            FtpServerInfo dbFtpInfo = this.queryFtpServerInfo(null);
            if (dbFtpInfo == null) {
                if (ftpInfo != null) {
                    this.generateFtpServerId(ftpInfo);
                    this.dao.getHibernateTemplate().saveOrUpdate((Object)ftpInfo);
                }
            } else if (dbFtpInfo.getFtpServerId().equals(ftpInfo.getFtpServerId())) {
                dbFtpInfo.update(ftpInfo);
                this.dao.getHibernateTemplate().saveOrUpdate((Object)dbFtpInfo);
            } else {
                this.dao.getHibernateTemplate().delete((Object)dbFtpInfo);
                this.dao.getHibernateTemplate().saveOrUpdate((Object)ftpInfo);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"save FtpServerInfo error", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    private void generateFtpServerId(FtpServerInfo ftpInfo) {
        if (ftpInfo.getFtpServerId() == null || ftpInfo.getFtpServerId().isEmpty()) {
            ftpInfo.setFtpServerId(UUIDGenerator.getUUID());
        }
    }

    public void saveToDB(FtpServerInfo ftpInfo, boolean changePwd, boolean exportChange) {
        try {
            FtpServerInfo dbFtpInfo = this.queryFtpServerInfo(null);
            if (dbFtpInfo == null) {
                if (ftpInfo != null) {
                    this.generateFtpServerId(ftpInfo);
                    this.dao.getHibernateTemplate().saveOrUpdate((Object)ftpInfo);
                }
            } else {
                dbFtpInfo.update(ftpInfo, changePwd, exportChange);
                this.dao.getHibernateTemplate().saveOrUpdate((Object)dbFtpInfo);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"save FtpServerInfo error", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public FtpServerInfo queryFtpServerInfo(String ftpServerId) {
        List ftpServerList;
        try {
            ftpServerList = null != ftpServerId ? this.dao.getHibernateTemplate().find("from FtpServerInfo where ftpServerId = ? ", new Object[]{ftpServerId}) : this.dao.getHibernateTemplate().find("from FtpServerInfo", new Object[0]);
        }
        catch (DataAccessException e) {
            logger.error((Object)"failed to get ftp server info:", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (ftpServerList == null || ftpServerList.isEmpty()) {
            return null;
        }
        return (FtpServerInfo)ftpServerList.get(0);
    }

    public void deleteFtpServerInfo(String ftpServerId) {
        try {
            FtpServerInfo dbFtpInfo = this.queryFtpServerInfo(ftpServerId);
            if (VerifyUtil.isEmpty((Object)dbFtpInfo)) {
                return;
            }
            this.dao.getHibernateTemplate().delete((Object)dbFtpInfo);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Unified Backup delete FtpServerInfo error", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }
}

