/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.service;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.discover.poll.PollControllerLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.system.cfgdata.ConfigDataCommon;
import com.huawei.ism.drm.system.cfgdata.DrvSshPara;
import com.huawei.ism.drm.system.cfgdata.SftpUtil;
import com.huawei.ism.drm.system.cfgdata.database.ConfigDataDao;
import com.huawei.ism.drm.system.cfgdata.database.GuassDBdumpImpl;
import com.huawei.ism.drm.system.cfgdata.processor.ConfigDataAutoBackupTask;
import com.huawei.ism.drm.system.cfgdata.processor.ConfigDataPoller;
import com.huawei.ism.drm.system.cfgdata.sdk.model.FtpServerInfo;
import com.huawei.ism.drm.system.cfgdata.sdk.service.IConfigDataBackupService;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.File;

@Service(Name="com.huawei.ism.drm.system.cfgdata.sdk.service.IConfigDataBackupService", Desc="", Interface=IConfigDataBackupService.class)
public class ConfigDataBackupServiceImpl
extends BaseService
implements IConfigDataBackupService {
    private static final Log logger = LogFactory.getInstance(ConfigDataBackupServiceImpl.class);
    private static final int PERIOD = 1440;
    private ConfigDataDao configDataDao;

    public ConfigDataDao getConfigDataDao() {
        return this.configDataDao;
    }

    public void setConfigDataDao(ConfigDataDao configDataDao) {
        this.configDataDao = configDataDao;
    }

    public void save(FtpServerInfo ftpInfo) {
        this.save(ftpInfo, false, false);
    }

    public void save(FtpServerInfo ftpInfo, boolean changePwd, boolean exportChange) {
        if (ftpInfo == null) {
            logger.error((Object)"FtpServerInfo is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.setFtpServerDefaultPara(ftpInfo);
        this.checkFtpServerInfo(ftpInfo, changePwd);
        this.checkHostKey(ftpInfo);
        this.configDataDao.saveToDB(ftpInfo, changePwd, exportChange);
        logger.info((Object)String.format("ftpServerInfo has been changed to: (ip:%s, username:%s, port:%s, enable:%s).", ftpInfo.getIp(), ftpInfo.getFtpUserName(), ftpInfo.getPort(), String.valueOf(ftpInfo.isAutoBackupFlag())), 90160758786816L);
        if (ftpInfo.isAutoBackupFlag()) {
            this.stopAutoBack();
            this.startAutoBack();
        } else {
            this.stopAutoBack();
        }
    }

    public FtpServerInfo queryFtpServerInfo(String ftpServerId) {
        return this.configDataDao.queryFtpServerInfo(ftpServerId);
    }

    public File backupConfig(String encryptPwd, boolean isDataAnonymous) {
        try {
            return new GuassDBdumpImpl().backup(encryptPwd, isDataAnonymous);
        }
        catch (Exception e) {
            logger.error((Object)"failed to excute backup command of mysql. ", 90160758787071L);
            return null;
        }
    }

    public boolean deleteFile(File file) {
        try {
            return file.delete();
        }
        catch (Exception e) {
            logger.error((Object)("failed to delete file." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return false;
        }
    }

    public void startAutoBack() {
        logger.info((Object)"start auto backup config data .", 90160758786816L);
        FtpServerInfo ftpInfo = this.queryFtpServerInfo(null);
        if (ftpInfo == null) {
            logger.info((Object)"There is no ftp server to start.", 90160758786816L);
            return;
        }
        int delayTime = ConfigDataCommon.calculateFirstRunDelayTime(ftpInfo.getRunTime());
        ConfigDataPoller configDataPoller = new ConfigDataPoller(ftpInfo.getFtpServerId(), "CONFIG_DATA", ftpInfo);
        PollControllerLocator.getInstance().getPollController().addPoller((IPoller)configDataPoller, delayTime * 60, 86400);
        logger.info((Object)("sucess to create ConfigDataPoller , id = " + configDataPoller.getPollerID()), 90160758786816L);
    }

    public void startAutoBack(FtpServerInfo ftpInfo) {
        logger.info((Object)"start auto backup config data .", 90160758786816L);
        int delayTime = ConfigDataCommon.calculateFirstRunDelayTime(ftpInfo.getRunTime());
        ConfigDataPoller configDataPoller = new ConfigDataPoller(ftpInfo.getFtpServerId(), "CONFIG_DATA", ftpInfo);
        PollControllerLocator.getInstance().getPollController().addPoller((IPoller)configDataPoller, delayTime * 60, 86400);
        logger.info((Object)("sucess to create ConfigDataPoller , id = " + configDataPoller.getPollerID()), 90160758786816L);
    }

    public void stopAutoBack(FtpServerInfo ftpInfo) {
        PollControllerLocator.getInstance().getPollController().stopPoller(ftpInfo.getFtpServerId(), true);
    }

    public void stopAutoBack() {
        FtpServerInfo ftpInfo = this.queryFtpServerInfo(null);
        if (ftpInfo == null) {
            logger.info((Object)"There is no ftp server to stop.");
            return;
        }
        PollControllerLocator.getInstance().getPollController().stopPoller(ftpInfo.getFtpServerId(), true);
        logger.info((Object)("Successed to stop backup task of ftp server : " + ftpInfo.getIp()));
    }

    private void setFtpServerDefaultPara(FtpServerInfo ftpInfo) {
        if (ftpInfo != null) {
            ftpInfo.setRunTime("02:00:00");
            String baseDir = ftpInfo.getBaseDir();
            if (VerifyUtil.isEmpty((String)baseDir)) {
                ftpInfo.setBaseDir("/CloudComputing/DRBackup/");
            }
            ftpInfo.setMaxStoredDay(7);
        }
    }

    private void checkFtpServerInfo(FtpServerInfo ftpInfo, boolean changePwd) {
        if (!ftpInfo.isAutoBackupFlag()) {
            return;
        }
        if (!ftpInfo.isParaValid(changePwd)) {
            logger.error((Object)"FtpServerInfo is invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public String getFtpHostKey(String ip, Integer port) {
        return SftpUtil.getFtpHostKey(ip, port);
    }

    private void checkHostKey(FtpServerInfo ftpInfo) {
        logger.info((Object)("check sftp server hostkey." + ftpInfo.getHostKey()));
        if (!ftpInfo.isAutoBackupFlag()) {
            return;
        }
        String hostKey = SftpUtil.getFtpHostKey(ftpInfo.getIp(), ftpInfo.getPort());
        String oldHostKey = WccEncryptor.decrypt((String)ftpInfo.getHostKey());
        if (VerifyUtil.isEmpty((String)oldHostKey) || !hostKey.equals(oldHostKey)) {
            logger.error((Object)"SFTP server hostkey is changed.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void testAutoBackupConfig() {
        FtpServerInfo ftpInfo = this.queryFtpServerInfo(null);
        if (ftpInfo == null) {
            logger.error((Object)"There is no ftp server to start.", 90160758786816L);
            throw new LegoCheckedException(1073947469L);
        }
        if (!ftpInfo.isAutoBackupFlag()) {
            logger.error((Object)"SFTP config mode is manul backup.", 90160758786816L);
            throw new LegoCheckedException(1073947468L);
        }
        logger.info((Object)"start to test Auto backup task of config data .", 90160758786816L);
        BackTask bt = BackTaskUtil.buildBackTask((String)"BCManager", (String)"ism.drm.autobackup.backtask.test.task.name", (String)"System", (String)"", null);
        ConfigDataAutoBackupTask task = new ConfigDataAutoBackupTask(ftpInfo, bt);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        logger.info((Object)("submit the test Auto backup task of config data : " + task.getTaskId()), 90160758786816L);
    }

    public void updateFtpInfoFromMO(FtpServerInfo ftpServerInfo) {
        this.checkAndSetFtpInfo(ftpServerInfo);
        this.checkSftpConnect(ftpServerInfo);
        this.configDataDao.saveToDB(ftpServerInfo);
        this.stopAutoBack();
        this.startAutoBack();
    }

    public String createBackupAction() {
        FtpServerInfo ftpInfo = this.queryFtpServerInfo(null);
        if (VerifyUtil.isEmpty((Object)ftpInfo)) {
            logger.error((Object)"There is no ftp server to start.");
            throw new LegoCheckedException(1073947393L, "There is no ftp server to start.");
        }
        BackTask bt = BackTaskUtil.buildBackTask((String)"BCManager", (String)"ism.drm.manageone.backtask.task.name", (String)"System", (String)"", null);
        ConfigDataAutoBackupTask task = new ConfigDataAutoBackupTask(ftpInfo, bt);
        Long taskId = BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return String.valueOf(taskId);
    }

    public void deleteSftpServerInfo(String ftpServerId) {
        this.stopAutoBack();
        this.configDataDao.deleteFtpServerInfo(ftpServerId);
    }

    public void changeBackupPolicy(boolean autoBackup) {
        FtpServerInfo ftpInfo = this.configDataDao.queryFtpServerInfo(null);
        if (VerifyUtil.isEmpty((Object)ftpInfo)) {
            logger.error((Object)"Unified Backup changeBackupPolicy failed! no ftp server to change.");
            return;
        }
        this.stopAutoBack();
        ftpInfo.setAutoBackupFlag(autoBackup);
        try {
            this.configDataDao.saveToDB(ftpInfo);
        }
        finally {
            if (autoBackup) {
                this.startAutoBack();
            }
        }
    }

    public String getVersion() {
        ManagementServer local = ((IManagementServerService)ServiceLocator.getInstance().getService(IManagementServerService.class)).getServerInfo();
        logger.info((Object)"version is : %s", new Object[]{local == null ? "empty" : local.getVersion()});
        if (local == null) {
            throw new LegoCheckedException(2117645L);
        }
        return local.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSftpConnect(FtpServerInfo ftpServerInfo) {
        SftpUtil sftp = new SftpUtil();
        try {
            DrvSshPara para = new DrvSshPara(ftpServerInfo);
            if (!sftp.login(para)) {
                logger.error((Object)"Unified Backup failed to login ftp server :%s", new Object[]{para.getIp()});
                throw new LegoCheckedException(1073948931L, "Unified Backup failed to login ftp server.");
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Unified Backup failed to login ftp server !", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"login SftpServer failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            sftp.logout();
        }
    }

    private void checkAndSetFtpInfo(FtpServerInfo ftpServerInfo) {
        if (VerifyUtil.isEmpty((Object)ftpServerInfo)) {
            logger.error((Object)"FtpServerInfo is null");
            throw new LegoCheckedException(1073947393L, "FtpServerInfo is null.");
        }
        String ftpPassword = ftpServerInfo.getFtpPassword();
        ftpServerInfo.setFtpPassword(WccEncryptor.encrypt((String)ftpPassword));
        String dataPassword = LegoConfig.getInstance().getKeyValue("config.backup.sftp.password.default");
        ftpServerInfo.setDataPassword(dataPassword);
        ftpServerInfo.setAutoBackupFlag(true);
        this.setFtpServerDefaultPara(ftpServerInfo);
        this.checkFtpServerInfo(ftpServerInfo, true);
        String hostKey = this.getFtpHostKey(ftpServerInfo.getIp(), ftpServerInfo.getPort());
        if (VerifyUtil.isEmpty((String)hostKey)) {
            logger.error((Object)"Get SFTP hostKey failed. IP: %s", new Object[]{ftpServerInfo.getIp()});
            throw new LegoCheckedException(1073947450L, "Get SFTP hostKey failed.");
        }
        ftpServerInfo.setHostKey(WccEncryptor.encrypt((String)hostKey));
    }
}

