/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.wcc.crypt.CrypterFactory;
import org.wcc.crypt.Formatter;
import org.wcc.crypt.FormatterV0;
import org.wcc.crypt.FormatterV1;
import org.wcc.crypt.RootKeyComponent;
import org.wcc.framework.AppRuntimeException;

public abstract class Crypter {
    protected static final int PARAM_INDEX_ALGORITHM = 0;
    protected static final int PARAM_INDEX_ENCRYPTED = 1;
    protected static final int PARAM_INDEX_ROOTKEY_TIMESTAMP = 2;
    protected static final int PARAM_INDEX_KEYGEN_ITERATION_COUNT = 3;
    protected static final int ALGO_PARAM_START = 4;
    private static ThreadLocal<Map<Integer, byte[]>> crypterParam = new ThreadLocal<Map<Integer, byte[]>>(){

        @Override
        public Map<Integer, byte[]> initialValue() {
            return new HashMap<Integer, byte[]>();
        }
    };

    public static final char[] encryptChars(char[] plain) throws AppRuntimeException {
        Crypter crypter = CrypterFactory.getCrypter();
        return crypter.encrypt(plain);
    }

    public static final char[] decryptChars(char[] cipher) {
        String algorithm = Crypter.getAlgorithmFromCipher(cipher);
        Crypter crypt = CrypterFactory.getCrypter(algorithm);
        return crypt.decrypt(cipher);
    }

    public static boolean erase(char[] data) {
        if (null == data) {
            return true;
        }
        int size = data.length;
        for (int i = 0; i < size; ++i) {
            data[i] = '\u0000';
        }
        return true;
    }

    public char[] encrypt(char[] plainText) throws AppRuntimeException {
        try {
            return this.encryptWithDomain(plainText, "WCC_CRYPT_DEFAULT_DOMAIN");
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    public char[] decrypt(char[] cipherText) throws AppRuntimeException {
        throw new AppRuntimeException("Not Implemented");
    }

    public abstract char[] encrypt(char[] var1, char[] var2) throws AppRuntimeException;

    public abstract char[] decrypt(char[] var1, char[] var2) throws AppRuntimeException;

    public char[] encryptByRootKey(char[] content) throws AppRuntimeException {
        throw new AppRuntimeException("Not Implemented");
    }

    public char[] decryptByRootKey(char[] content) throws AppRuntimeException {
        throw new AppRuntimeException("Not Implemented");
    }

    public char[] encryptWithDomain(char[] plainText, String domain) throws AppRuntimeException {
        throw new AppRuntimeException("Not Implemented");
    }

    public String encrypt(String content, String password) throws AppRuntimeException {
        if (null == content || null == password) {
            throw new AppRuntimeException("Param should not be null");
        }
        return String.valueOf(this.encrypt(content.toCharArray(), password.toCharArray()));
    }

    public String decrypt(String content, String password) throws AppRuntimeException {
        if (null == content || null == password) {
            throw new AppRuntimeException("Param should not be null");
        }
        return String.valueOf(this.decrypt(content.toCharArray(), password.toCharArray()));
    }

    public String encryptByRootKey(String content) throws AppRuntimeException {
        if (null == content) {
            throw new AppRuntimeException("Param should not be null");
        }
        return String.valueOf(this.encryptByRootKey(content.toCharArray()));
    }

    public String decryptByRootKey(String content) throws AppRuntimeException {
        if (null == content) {
            throw new AppRuntimeException("Param should not be null");
        }
        return String.valueOf(this.decryptByRootKey(content.toCharArray()));
    }

    public String encrypt(String plainText) throws AppRuntimeException {
        if (null == plainText) {
            throw new AppRuntimeException("Param should not be null");
        }
        return String.valueOf(this.encrypt(plainText.toCharArray()));
    }

    public String encryptWithDomain(String plainText, String domain) throws AppRuntimeException {
        if (null == plainText) {
            throw new AppRuntimeException("Param should not be null");
        }
        return String.valueOf(this.encryptWithDomain(plainText.toCharArray(), domain));
    }

    public String decrypt(String cipherText) throws AppRuntimeException {
        if (null == cipherText) {
            throw new AppRuntimeException("Param should not be null");
        }
        return String.valueOf(this.decrypt(cipherText.toCharArray()));
    }

    public void genRootKey() throws AppRuntimeException {
        RootKeyComponent.getKeyComps();
    }

    protected char[] encryptByRootKey(char[] content, Key rootKey) throws AppRuntimeException {
        throw new AppRuntimeException("Not Implemented");
    }

    protected char[] decryptByRootKey(char[] content, Key rootKey) throws AppRuntimeException {
        throw new AppRuntimeException("Not Implemented");
    }

    protected static List<byte[]> getParam() {
        return new LinkedList<byte[]>(crypterParam.get().values());
    }

    protected static byte[] getParam(int index) {
        return crypterParam.get().get(index);
    }

    protected static void setParam(int index, byte[] param) {
        crypterParam.get().put(index, param);
    }

    protected static void setParam(List<byte[]> param) {
        if (null == param || param.isEmpty()) {
            throw new AppRuntimeException("null == param or empty");
        }
        HashMap<Integer, byte[]> paramMap = new HashMap<Integer, byte[]>();
        int size = param.size();
        for (int i = 0; i < size; ++i) {
            paramMap.put(i, param.get(i));
        }
        crypterParam.set(paramMap);
    }

    protected static void clearParam() {
        crypterParam.remove();
    }

    protected static List<byte[]> getParamsFromCipher(String cipher) {
        FormatterV1 formatter = new FormatterV1();
        List<byte[]> params = ((Formatter)formatter).parse(cipher);
        if (null != params) {
            return params;
        }
        FormatterV0 formatterV0 = new FormatterV0();
        formatterV0.setEncByRootKey(false);
        params = ((Formatter)formatterV0).parse(cipher);
        if (null != params) {
            return params;
        }
        throw new AppRuntimeException("Invalid content");
    }

    private static String getAlgorithmFromCipher(char[] cipher) {
        if (null == cipher) {
            throw new AppRuntimeException("Wrong Param: cipher == null");
        }
        String cipherString = String.valueOf(cipher);
        List<byte[]> params = Crypter.getParamsFromCipher(cipherString);
        try {
            return new String(params.get(0), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }
}

