/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.wcc.crypt.Crypter;
import org.wcc.crypt.EncryptHelper;
import org.wcc.crypt.KeyGen;
import org.wcc.crypt.KeyManager;
import org.wcc.crypt.RootKey;
import org.wcc.crypt.WorkKey;
import org.wcc.framework.AppProperties;
import org.wcc.framework.AppRuntimeException;

class CrypterAesCBC
extends Crypter {
    protected static final int PARAM_INDEX_IV = 4;
    protected static final int PARAM_INDEX_SALT = 5;
    protected static final int PARAM_INDEX_ID = 6;
    private static final String PROP_IV_LENGTH = "crypt_aes_cbc_iv_length";
    private static final int DEFAULT_IV_LENGTH = 16;
    private static final int IV_LENGTH_MIN = 1;
    private static final String PROP_SALT_LENGTH = "crypt_aes_cbc_salt_length";
    private static final int DEFAULT_SALT_LENGTH = 8;
    private static final int SALT_LENGTH_MIN = 8;
    private static final String PROP_KEY_LENGTH = "crypt_aes_cbc_key_length";
    private static final String PROP_KEY_LENGTH_OLD = "crypt_keygen_key_length";
    private static final int KEY_LENGTH_128 = 128;
    private static final int KEY_LENGTH_192 = 192;
    private static final int KEY_LENGTH_256 = 256;
    private static final int DEFAULT_KEY_LENGTH = 256;
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";

    CrypterAesCBC() {
    }

    @Override
    public char[] encrypt(char[] content, char[] password) throws AppRuntimeException {
        if (null == content || null == password) {
            throw new AppRuntimeException("content and password should not be null");
        }
        byte[] salt = this.genSalt();
        byte[] iv = this.genIV();
        CrypterAesCBC.setParam(4, iv);
        CrypterAesCBC.setParam(5, salt);
        SecretKeySpec key = new SecretKeySpec(KeyGen.genKey(password, salt, this.getKeyLength(), KeyGen.getIterationCount()).getEncoded(), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        byte[] ecypted = this.doEncrypt(EncryptHelper.getBytesByUTF8(content), key, ivSpec);
        return EncryptHelper.parseByte2HexStr(ecypted).toCharArray();
    }

    @Override
    public char[] decrypt(char[] content, char[] password) throws AppRuntimeException {
        if (null == content || null == password) {
            throw new AppRuntimeException("content and password should not be null");
        }
        byte[] iv = CrypterAesCBC.getParam(4);
        byte[] salt = CrypterAesCBC.getParam(5);
        try {
            int iterationCount = Integer.parseInt(new String(CrypterAesCBC.getParam(3), "UTF-8"));
            SecretKeySpec key = new SecretKeySpec(KeyGen.genKey(password, salt, this.getKeyLength(), iterationCount).getEncoded(), "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            byte[] contentBytes = EncryptHelper.parseHexStr2Byte(String.valueOf(content));
            byte[] result = this.doDecrypt(contentBytes, key, ivSpec);
            return EncryptHelper.getCharsByUTF8(result);
        }
        catch (UnsupportedEncodingException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    @Override
    public char[] encryptByRootKey(char[] content) throws AppRuntimeException {
        return this.encryptByRootKey(content, new RootKey(this.getKeyLength(), KeyGen.getIterationCount()).getKey());
    }

    @Override
    public char[] decryptByRootKey(char[] content) throws AppRuntimeException {
        try {
            int iterationCount = Integer.parseInt(new String(CrypterAesCBC.getParam(3), "UTF-8"));
            return this.decryptByRootKey(content, new RootKey(this.getKeyLength(), iterationCount).getKey());
        }
        catch (UnsupportedEncodingException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    @Override
    public char[] encryptWithDomain(char[] plainText, String domain) throws AppRuntimeException {
        char[] result;
        KeyManager km = KeyManager.getInstance();
        WorkKey key = km.getKey(domain, 0);
        if (null == key) {
            throw new AppRuntimeException("key not found. domain = " + domain);
        }
        char[] plainKey = null;
        try {
            plainKey = key.getPlainKey();
            result = this.encrypt(plainText, plainKey);
            String id = key.getId();
            if (null == id) {
                throw new AppRuntimeException("key id is null");
            }
            CrypterAesCBC.setParam(6, id.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            Crypter.erase(plainKey);
        }
        return result;
    }

    @Override
    public char[] decrypt(char[] cipherText) throws AppRuntimeException {
        char[] cArray;
        if (null == cipherText) {
            throw new AppRuntimeException("cipherText should not be null");
        }
        byte[] idBytes = CrypterAesCBC.getParam(6);
        char[] plainKey = null;
        try {
            String id = new String(idBytes, "UTF-8");
            List<byte[]> tmp = CrypterAesCBC.getParam();
            CrypterAesCBC.clearParam();
            WorkKey key = KeyManager.getInstance().getKey(id);
            plainKey = key.getPlainKey();
            CrypterAesCBC.setParam(tmp);
            cArray = this.decrypt(cipherText, plainKey);
        }
        catch (Exception e) {
            try {
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                Crypter.erase(plainKey);
                throw throwable;
            }
        }
        Crypter.erase(plainKey);
        return cArray;
    }

    @Override
    protected char[] encryptByRootKey(char[] content, Key rootKey) throws AppRuntimeException {
        if (null == content) {
            throw new AppRuntimeException("content should not be null");
        }
        byte[] iv = this.genIV();
        CrypterAesCBC.setParam(4, iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        SecretKeySpec aesRootKey = new SecretKeySpec(rootKey.getEncoded(), "AES");
        byte[] ecypted = this.doEncrypt(EncryptHelper.getBytesByUTF8(content), aesRootKey, ivSpec);
        return EncryptHelper.parseByte2HexStr(ecypted).toCharArray();
    }

    @Override
    protected char[] decryptByRootKey(char[] content, Key rootKey) throws AppRuntimeException {
        if (null == content) {
            throw new AppRuntimeException("content should not be null");
        }
        int ivLen = AppProperties.getAsInt((String)PROP_IV_LENGTH, (int)16);
        if (ivLen < 1) {
            throw new AppRuntimeException("Config Error. IV_LENGTH > 1");
        }
        byte[] iv = CrypterAesCBC.getParam(4);
        byte[] ecyptContent = EncryptHelper.parseHexStr2Byte(String.valueOf(content));
        SecretKeySpec aesRootKey = new SecretKeySpec(rootKey.getEncoded(), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        return EncryptHelper.getCharsByUTF8(this.doDecrypt(ecyptContent, aesRootKey, ivSpec));
    }

    private byte[] doEncrypt(byte[] content, Key key, IvParameterSpec iv) throws AppRuntimeException {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, key, iv);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    private byte[] doDecrypt(byte[] content, Key key, IvParameterSpec iv) throws AppRuntimeException {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, key, iv);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    private byte[] genIV() throws AppRuntimeException {
        try {
            int length = AppProperties.getAsInt((String)PROP_IV_LENGTH, (int)16);
            if (length < 1) {
                throw new AppRuntimeException("Config Error. IV_LENGTH > 1");
            }
            byte[] iv = new byte[length];
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            rand.nextBytes(iv);
            return iv;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    private byte[] genSalt() throws AppRuntimeException {
        try {
            int length = AppProperties.getAsInt((String)PROP_SALT_LENGTH, (int)8);
            if (length < 8) {
                throw new AppRuntimeException("Config Error. SALT_LENGTH > 8");
            }
            byte[] salt = new byte[length];
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            rand.nextBytes(salt);
            return salt;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    private int getKeyLength() {
        int keyLength;
        String key = AppProperties.get((String)PROP_KEY_LENGTH);
        if (null == key && null == (key = AppProperties.get((String)PROP_KEY_LENGTH_OLD))) {
            return 256;
        }
        try {
            keyLength = Integer.parseInt(key);
        }
        catch (NumberFormatException ex) {
            throw new AppRuntimeException("NumberFormatException. Please check config: crypt_aes_cbc_key_length");
        }
        if (keyLength != 128 && keyLength != 192 && keyLength != 256) {
            throw new AppRuntimeException("Config Error. Key Length should be 128, 192 or 256");
        }
        return keyLength;
    }
}

