/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.util.HashMap;
import java.util.Map;
import org.wcc.crypt.Crypter;
import org.wcc.crypt.CrypterAesCBC;
import org.wcc.crypt.CrypterProxy;
import org.wcc.crypt.FormatterV1;
import org.wcc.crypt.RootKeyUpdater;
import org.wcc.framework.AppProperties;
import org.wcc.framework.AppRuntimeException;

public class CrypterFactory {
    public static final String AES_CBC = "AES_CBC";
    private static String PROP_CRYPT_ALGORITHM = "crypt_crypter_algorithm";
    private static String DEFAULT_CRYPT_ALGORITHM = "AES_CBC";
    private static Map<String, Class<?>> IMPL = new HashMap();

    public static Crypter getCrypter() throws AppRuntimeException {
        String algorithm = AppProperties.get((String)PROP_CRYPT_ALGORITHM, (String)DEFAULT_CRYPT_ALGORITHM);
        return CrypterFactory.getCrypter(algorithm);
    }

    public static Crypter getCrypter(String algorithm) throws AppRuntimeException {
        if (null == algorithm) {
            throw new AppRuntimeException("Algorithm Should not be null");
        }
        Class<?> implClass = IMPL.get(algorithm);
        if (null == implClass) {
            throw new AppRuntimeException("Unsupported Crypter Algorithm: " + algorithm);
        }
        try {
            Class<Crypter> impl = implClass.asSubclass(Crypter.class);
            Crypter crypter = impl.newInstance();
            return new CrypterProxy(algorithm, crypter, RootKeyUpdater.getInstance(), new FormatterV1());
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    static {
        IMPL.put(AES_CBC, CrypterAesCBC.class);
    }
}

