/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.util.List;
import org.wcc.crypt.Crypter;
import org.wcc.crypt.EncryptHelper;
import org.wcc.crypt.Formatter;
import org.wcc.crypt.FormatterV0;
import org.wcc.crypt.KeyGen;
import org.wcc.crypt.ProcessLocker;
import org.wcc.crypt.RootKey;
import org.wcc.crypt.RootKeyComponent;
import org.wcc.crypt.RootKeyUpdater;
import org.wcc.framework.AppProperties;
import org.wcc.framework.AppRuntimeException;

class CrypterProxy
extends Crypter {
    private String algorithm = null;
    private Crypter crypter = null;
    private RootKeyUpdater updater = null;
    private Formatter formatter = null;

    protected CrypterProxy(String algorithm, Crypter crypter, RootKeyUpdater updater, Formatter formatter) {
        this.algorithm = algorithm;
        this.crypter = crypter;
        this.updater = updater;
        this.formatter = formatter;
    }

    @Override
    public char[] encrypt(char[] content, char[] password) throws AppRuntimeException {
        try {
            char[] encrypted = this.crypter.encrypt(content, password);
            List<byte[]> param = CrypterProxy.getParam();
            param.add(0, this.algorithm.getBytes("UTF-8"));
            param.add(1, EncryptHelper.getBytesByUTF8(encrypted));
            param.add(2, null);
            param.add(3, String.valueOf(KeyGen.getIterationCount()).getBytes("UTF-8"));
            char[] cArray = this.formatter.format(param).toCharArray();
            return cArray;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            CrypterProxy.clearParam();
        }
    }

    @Override
    public char[] decrypt(char[] content, char[] password) throws AppRuntimeException {
        try {
            List<byte[]> params = this.formatter.parse(String.valueOf(content));
            if (null == params) {
                FormatterV0 formatterV0 = new FormatterV0();
                formatterV0.setEncByRootKey(false);
                params = ((Formatter)formatterV0).parse(String.valueOf(content));
                if (null == params) {
                    throw new AppRuntimeException("Invalid content");
                }
            }
            CrypterProxy.setParam(params);
            byte[] encrypted = params.get(1);
            char[] cArray = this.crypter.decrypt(EncryptHelper.getCharsByUTF8(encrypted), password);
            return cArray;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            CrypterProxy.clearParam();
        }
    }

    @Override
    public char[] encryptByRootKey(char[] content) throws AppRuntimeException {
        try {
            if (this.updater.needUpdate()) {
                this.updateRootKey();
            }
            char[] result = this.crypter.encryptByRootKey(content);
            List<byte[]> param = CrypterProxy.getParam();
            param.add(0, this.algorithm.getBytes("UTF-8"));
            param.add(1, EncryptHelper.getBytesByUTF8(result));
            param.add(2, String.valueOf(RootKeyComponent.currentTimeStamp()).getBytes("UTF-8"));
            param.add(3, String.valueOf(KeyGen.getIterationCount()).getBytes("UTF-8"));
            char[] cArray = this.formatter.format(param).toCharArray();
            return cArray;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            CrypterProxy.clearParam();
        }
    }

    @Override
    public char[] decryptByRootKey(char[] content) throws AppRuntimeException {
        boolean isFormatV0 = false;
        try {
            RootKey rootKey;
            List<byte[]> params = this.formatter.parse(String.valueOf(content));
            if (null == params) {
                FormatterV0 formatterV0 = new FormatterV0();
                formatterV0.setEncByRootKey(true);
                params = ((Formatter)formatterV0).parse(String.valueOf(content));
                if (null == params) {
                    throw new AppRuntimeException("Invalid content");
                }
                isFormatV0 = true;
            }
            CrypterProxy.setParam(params);
            byte[] encryptedBytes = params.get(1);
            long timeStamp = Long.parseLong(new String(CrypterProxy.getParam(2), "UTF-8"));
            int count = Integer.parseInt(new String(params.get(3), "UTF-8"));
            int keyLength = AppProperties.getAsInt((String)"crypt_aes_cbc_key_length", (int)256);
            RootKeyComponent[] current = RootKeyComponent.getKeyComps();
            if (timeStamp == current[0].getTimeStamp() || isFormatV0) {
                rootKey = new RootKey(current, keyLength, count);
            } else if (timeStamp == Long.MAX_VALUE) {
                rootKey = new RootKey(RootKeyComponent.getDefaultKeyComps(), keyLength, count);
            } else {
                RootKeyComponent[] rkcs = this.updater.getOldRKCS(timeStamp);
                if (null == rkcs) {
                    rkcs = current;
                }
                rootKey = new RootKey(rkcs, keyLength, count);
            }
            char[] result = this.crypter.decryptByRootKey(EncryptHelper.getCharsByUTF8(encryptedBytes), rootKey.getKey());
            if (this.updater.needUpdate()) {
                this.updateRootKey();
            }
            char[] cArray = result;
            return cArray;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            CrypterProxy.clearParam();
        }
    }

    @Override
    public char[] encryptWithDomain(char[] plainText, String domain) throws AppRuntimeException {
        try {
            char[] cipherText = this.crypter.encryptWithDomain(plainText, domain);
            List<byte[]> param = CrypterProxy.getParam();
            param.add(0, this.algorithm.getBytes("UTF-8"));
            param.add(1, EncryptHelper.getBytesByUTF8(cipherText));
            param.add(2, null);
            param.add(3, String.valueOf(KeyGen.getIterationCount()).getBytes("UTF-8"));
            char[] cArray = this.formatter.format(param).toCharArray();
            return cArray;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            CrypterProxy.clearParam();
        }
    }

    @Override
    public char[] decrypt(char[] cipherText) throws AppRuntimeException {
        try {
            List<byte[]> params = this.formatter.parse(String.valueOf(cipherText));
            if (null == params) {
                throw new AppRuntimeException("invalid cipherText");
            }
            CrypterProxy.setParam(params);
            byte[] encrypted = params.get(1);
            char[] cArray = this.crypter.decrypt(EncryptHelper.getCharsByUTF8(encrypted));
            return cArray;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            CrypterProxy.clearParam();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRootKey() {
        Class<RootKeyUpdater> clazz = RootKeyUpdater.class;
        synchronized (RootKeyUpdater.class) {
            if (!this.updater.needUpdate()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ProcessLocker locker = null;
            try {
                locker = ProcessLocker.getInstance("update_lock").getWriteLock();
                locker.lock();
                if (this.updater.needUpdate()) {
                    this.updater.doUpdate();
                }
            }
            catch (Throwable throwable) {
                ProcessLocker.unlock(locker);
                throw throwable;
            }
            ProcessLocker.unlock(locker);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

