/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import org.wcc.crypt.ProcessLocker;
import org.wcc.framework.AppRuntimeException;

public class EncryptHelper {
    private static final int HEX_255 = 255;
    private static final int DECIMAL_2 = 2;
    private static final int DECIMAL_16 = 16;
    private static final int ONE_KB = 0x100000;
    private static final int RETRY_TIME = 3;

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (byte curByte : buf) {
            String hexStr = Integer.toHexString(curByte & 0xFF);
            if (hexStr != null && hexStr.length() < 2) {
                hexStr = '0' + hexStr;
            }
            sb.append(hexStr.toUpperCase(Locale.US));
        }
        return sb.toString();
    }

    public static char[] parseByte2HexChars(byte[] buf) {
        LinkedList<Character> result = new LinkedList<Character>();
        for (byte curByte : buf) {
            char[] charArray;
            String hexStr = Integer.toHexString(curByte & 0xFF);
            if (hexStr != null && hexStr.length() < 2) {
                hexStr = '0' + hexStr;
            }
            for (char c : charArray = hexStr.toUpperCase(Locale.US).toCharArray()) {
                result.add(Character.valueOf(c));
            }
        }
        int size = result.size();
        char[] tmp = new char[size];
        for (int i = 0; i < size; ++i) {
            tmp[i] = ((Character)result.get(i)).charValue();
        }
        return tmp;
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return new byte[0];
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static void copyFile(File src, File dest) {
        if (null == src || null == dest) {
            throw new AppRuntimeException("Error: param is null");
        }
        if (!src.exists()) {
            throw new AppRuntimeException("Error: src file not found");
        }
        if (dest.exists() && dest.isDirectory()) {
            throw new AppRuntimeException("Error: dest file is a directory");
        }
        boolean tryAgain = false;
        boolean interrupted = false;
        String os = System.getProperty("os.name");
        boolean isLinux = null != os && os.toLowerCase(Locale.ENGLISH).contains("linux");
        int retryTimes = 0;
        do {
            if (tryAgain && ++retryTimes > 3) {
                throw new AppRuntimeException("Error: Too many interruptions");
            }
            tryAgain = false;
            try {
                if (isLinux) {
                    EncryptHelper.copyFileOnLinux(src, dest);
                    continue;
                }
                EncryptHelper.copyFileOnOtherOS(src, dest);
            }
            catch (Exception e) {
                if (!(e instanceof ClosedByInterruptException) && !(e instanceof ClosedChannelException) && !(e instanceof InterruptedException)) continue;
                interrupted = Thread.interrupted();
                tryAgain = true;
            }
        } while (tryAgain);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static void threadUnlock(Lock ... threadLock) {
        if (null == threadLock) {
            return;
        }
        for (Lock lock : threadLock) {
            if (null == lock) continue;
            try {
                lock.unlock();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void unlock(Lock threadLock, ProcessLocker ... procLocks) {
        try {
            ProcessLocker.unlock(procLocks);
        }
        catch (Throwable throwable) {
            EncryptHelper.threadUnlock(threadLock);
            throw throwable;
        }
        EncryptHelper.threadUnlock(threadLock);
    }

    public static void close(Closeable ... streams) {
        if (null == streams) {
            return;
        }
        for (Closeable stream : streams) {
            if (null == stream) continue;
            try {
                stream.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void createFile(File file) throws AppRuntimeException {
        if (null == file || file.exists()) {
            return;
        }
        try {
            File parent = file.getAbsoluteFile().getParentFile();
            if (null == parent) {
                throw new AppRuntimeException("pathname does not name a parent");
            }
            if (!parent.exists() && !parent.mkdirs()) {
                throw new AppRuntimeException("mkdirs Error");
            }
            if (!file.createNewFile()) {
                throw new AppRuntimeException("createNewFile Error");
            }
        }
        catch (IOException e) {
            throw new AppRuntimeException("Exception when createNewFile");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveToFile(File file, String content) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(osw);
            bw.write(content);
        }
        catch (FileNotFoundException e) {
            try {
                throw new AppRuntimeException("File not found");
                catch (UnsupportedEncodingException e2) {
                    throw new AppRuntimeException("Unsupported Encoding of File");
                }
                catch (IOException e3) {
                    throw new AppRuntimeException("Write Error");
                }
            }
            catch (Throwable throwable) {
                EncryptHelper.close(bw, osw, fos);
                throw throwable;
            }
        }
        EncryptHelper.close(bw, osw, fos);
    }

    public static void setFilePermission(File file, String permission, String user, String group) throws IOException {
        String cmd;
        if (null == file || EncryptHelper.isWindows()) {
            return;
        }
        String encodedfile = EncryptHelper.encodeForLinux(file.getCanonicalFile().getCanonicalPath());
        String chmodCmd = "";
        String chuserCmd = "";
        String chgrpCmd = "";
        if (null != permission && !permission.isEmpty()) {
            String encodedPermission = EncryptHelper.encodeForLinux(permission);
            cmd = "chmod PERMISSION FILE";
            cmd = cmd.replace("PERMISSION", encodedPermission);
            chmodCmd = cmd = cmd.replace("FILE", encodedfile);
        }
        if (null != user && !user.isEmpty()) {
            String encodedUser = EncryptHelper.encodeForLinux(user);
            cmd = "chown USER FILE";
            cmd = cmd.replace("USER", encodedUser);
            chuserCmd = cmd = cmd.replace("FILE", encodedfile);
        }
        if (null != group && !group.isEmpty()) {
            String encodedGroup = EncryptHelper.encodeForLinux(group);
            cmd = "chown :GROUP FILE";
            cmd = cmd.replace("GROUP", encodedGroup);
            chgrpCmd = cmd = cmd.replace("FILE", encodedfile);
        }
        String cmd2 = "";
        if (!chmodCmd.isEmpty()) {
            cmd2 = chmodCmd;
        }
        if (!chuserCmd.isEmpty()) {
            cmd2 = cmd2.isEmpty() ? chuserCmd : cmd2 + " && " + chuserCmd;
        }
        if (!chgrpCmd.isEmpty()) {
            cmd2 = cmd2.isEmpty() ? chgrpCmd : cmd2 + " && " + chgrpCmd;
        }
        if (!cmd2.isEmpty()) {
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd2});
            EncryptHelper.readCmdIO(proc);
        }
    }

    private static void readCmdIO(Process proc) {
        int n = 2;
        Closeable[] streams = new InputStream[n];
        streams[0] = proc.getErrorStream();
        streams[1] = proc.getInputStream();
        while (proc.isAlive()) {
            for (int i = 0; i < n; ++i) {
                Closeable stream = streams[i];
                if (stream == null) continue;
                try {
                    int available = ((InputStream)streams[i]).available();
                    if (available <= 0) continue;
                    byte[] bytes = new byte[available];
                    ((InputStream)streams[i]).read(bytes);
                    continue;
                }
                catch (Exception e) {
                    streams[i] = null;
                }
            }
        }
        EncryptHelper.close(streams);
    }

    public static byte[] getBytesByUTF8(char[] chars) {
        CharBuffer cb = CharBuffer.allocate(chars.length);
        cb.put(chars);
        cb.flip();
        Charset cs = Charset.forName("UTF-8");
        ByteBuffer bb = cs.encode(cb);
        int size = bb.remaining();
        byte[] result = new byte[size];
        bb.get(result);
        return result;
    }

    public static char[] getCharsByUTF8(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes);
        bb.flip();
        Charset cs = Charset.forName("UTF-8");
        CharBuffer cb = cs.decode(bb);
        int size = cb.remaining();
        char[] result = new char[size];
        cb.get(result);
        return result;
    }

    protected static String encodeForLinux(String s) {
        char[] charArray;
        if (null == s) {
            return null;
        }
        StringBuffer encoded = new StringBuffer();
        for (char c : charArray = s.toCharArray()) {
            if ('-' == c || EncryptHelper.isNumber(c) || EncryptHelper.isAlphabet(c)) {
                encoded.append(c);
                continue;
            }
            encoded.append("\\" + c);
        }
        return encoded.toString();
    }

    protected static boolean isWindows() {
        String os = System.getProperty("os.name");
        return null != os && os.toLowerCase(Locale.ENGLISH).contains("windows");
    }

    private static void copyFileOnLinux(File src, File dest) throws IOException, InterruptedException {
        String srcPath = src.getCanonicalPath();
        String destPath = dest.getCanonicalPath();
        srcPath = EncryptHelper.encodeForLinux(srcPath);
        destPath = EncryptHelper.encodeForLinux(destPath);
        String cmd = "cp -p " + srcPath + " " + destPath;
        Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
        EncryptHelper.readCmdIO(proc);
        int retureValue = proc.waitFor();
        if (0 != retureValue) {
            throw new AppRuntimeException("Copy Error: retureValue = " + retureValue);
        }
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlphabet(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static void copyFileOnOtherOS(File src, File dest) throws IOException {
        int bufSize = 0x100000;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            long count;
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            for (long pos = 0L; pos < size; pos += output.transferFrom(input, pos, count)) {
                count = size - pos > (long)bufSize ? (long)bufSize : size - pos;
            }
            if (src.length() != dest.length()) {
                throw new AppRuntimeException("Failed to copy full contents from src to dest");
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new AppRuntimeException("FileNotFound");
            }
            catch (Throwable throwable) {
                EncryptHelper.close(output, fos, input, fis);
                throw throwable;
            }
        }
        EncryptHelper.close(output, fos, input, fis);
    }
}

