/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.wcc.crypt.EncryptHelper;
import org.wcc.crypt.Formatter;
import org.wcc.framework.AppRuntimeException;

class FormatterV1
extends Formatter {
    private static final String MAGIC = "wcc_crypt";
    private static final byte FORMAT_VERSION = 1;
    private static final int CONTENT_START_INDEX = "wcc_crypt".length() + 1;
    private static final String SEPARATOR = ";";

    FormatterV1() {
    }

    @Override
    public String format(List<byte[]> values) {
        if (null == values || values.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.buildTag());
        for (byte[] value : values) {
            if (null != value) {
                String s = EncryptHelper.parseByte2HexStr(value);
                buf.append(s);
            }
            buf.append(SEPARATOR);
        }
        try {
            return new String(Base64.encodeBase64((byte[])buf.toString().getBytes("UTF-8"), (boolean)false, (boolean)true), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<byte[]> parse(String formatted) {
        String decoded;
        if (null == formatted || formatted.length() == 0) {
            return null;
        }
        try {
            decoded = new String(Base64.decodeBase64((String)formatted), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AppRuntimeException((Throwable)e);
        }
        if (!this.isValid(decoded)) {
            return null;
        }
        String content = decoded.substring(CONTENT_START_INDEX);
        String[] values = content.split(SEPARATOR);
        LinkedList<byte[]> result = new LinkedList<byte[]>();
        for (String v : values) {
            if (null == v || v.isEmpty()) {
                result.add(null);
                continue;
            }
            result.add(EncryptHelper.parseHexStr2Byte(v));
        }
        return result;
    }

    private String buildTag() {
        return "wcc_crypt\u0001";
    }

    private boolean isValid(String decoded) {
        if (null == decoded || decoded.length() <= MAGIC.length()) {
            return false;
        }
        return decoded.substring(0, MAGIC.length()).equals(MAGIC);
    }
}

