/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.wcc.crypt.Crypter;
import org.wcc.crypt.EncryptHelper;
import org.wcc.crypt.Formatter;
import org.wcc.crypt.FormatterV1;
import org.wcc.crypt.IntegrityProtector;
import org.wcc.crypt.KeyManager;
import org.wcc.crypt.WorkKey;
import org.wcc.framework.AppRuntimeException;
import org.wcc.framework.log.AppLogger;

class HMACIntegrityProtector
extends IntegrityProtector {
    private static final String ALGORITHM = "HmacSHA256";
    private static final int BUFFER_LENGTH = 1024;
    private static final int EOF = -1;
    private static final AppLogger LOGGER = AppLogger.getInstance(HMACIntegrityProtector.class);

    HMACIntegrityProtector() {
    }

    @Override
    public String hash(String content) throws AppRuntimeException {
        return this.hash(content, "WCC_CRYPT_DEFAULT_DOMAIN");
    }

    @Override
    public String hash(String content, String domain) throws AppRuntimeException {
        String string;
        if (null == content || null == domain || domain.isEmpty()) {
            return null;
        }
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(content.getBytes("UTF-8"));
            string = this.hash((InputStream)in, domain);
        }
        catch (Exception e) {
            try {
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptHelper.close(in);
                throw throwable;
            }
        }
        EncryptHelper.close(in);
        return string;
    }

    @Override
    public String hash(InputStream in) throws AppRuntimeException {
        return this.hash(in, "WCC_CRYPT_DEFAULT_DOMAIN");
    }

    @Override
    public String hash(InputStream in, String domain) throws AppRuntimeException {
        if (null == in || null == domain || domain.isEmpty()) {
            return null;
        }
        WorkKey workKey = KeyManager.getInstance().getKey(domain, 1);
        byte[] hashBytes = this.hash(in, workKey);
        return this.format(hashBytes, workKey);
    }

    @Override
    public boolean isIntegrated(String content, String hash) throws AppRuntimeException {
        boolean bl;
        if (null == content || null == hash || hash.isEmpty()) {
            return false;
        }
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(content.getBytes("UTF-8"));
            bl = this.isIntegrated(in, hash);
        }
        catch (Exception e) {
            try {
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptHelper.close(in);
                throw throwable;
            }
        }
        EncryptHelper.close(in);
        return bl;
    }

    @Override
    public boolean isIntegrated(InputStream in, String hash) throws AppRuntimeException {
        if (null == in || null == hash || hash.isEmpty()) {
            return false;
        }
        List<byte[]> params = HMACIntegrityProtector.getParams(hash);
        if (null == params) {
            LOGGER.error((Object)"Param [hash] is invalid: wrong format");
            return false;
        }
        String algorithm = HMACIntegrityProtector.getAlgorithm(params);
        if (!algorithm.equals(ALGORITHM)) {
            LOGGER.error((Object)"Param [hash] is invalid: algorithm is not HmacSHA256");
            return false;
        }
        String id = this.getKeyID(params);
        WorkKey workKey = KeyManager.getInstance().getKey(id);
        byte[] computedHashBytes = this.hash(in, workKey);
        byte[] hashBytes = this.getHashBytes(params);
        return Arrays.equals(hashBytes, computedHashBytes);
    }

    private byte[] hash(InputStream in, WorkKey workKey) {
        if (null == in || null == workKey) {
            return new byte[0];
        }
        char[] plainKey = null;
        try {
            plainKey = workKey.getPlainKey();
            Mac mac = this.getMacInstance(plainKey);
            byte[] buffer = new byte[1024];
            int readBytesNum = in.read(buffer, 0, 1024);
            if (readBytesNum <= -1) {
                throw new AppRuntimeException("read from InputStream error, readBytesNum = " + readBytesNum);
            }
            while (readBytesNum > -1) {
                mac.update(buffer, 0, readBytesNum);
                readBytesNum = in.read(buffer, 0, 1024);
            }
            byte[] byArray = mac.doFinal();
            return byArray;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            Crypter.erase(plainKey);
        }
    }

    private String format(byte[] hashBytes, WorkKey workKey) {
        if (null == hashBytes || 0 == hashBytes.length || null == workKey) {
            return null;
        }
        LinkedList<byte[]> params = new LinkedList<byte[]>();
        params.add(hashBytes);
        try {
            params.add(ALGORITHM.getBytes("UTF-8"));
            String id = workKey.getId();
            if (null == id) {
                throw new AppRuntimeException("key id is null");
            }
            params.add(id.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AppRuntimeException((Throwable)e);
        }
        FormatterV1 formatter = new FormatterV1();
        return ((Formatter)formatter).format(params);
    }

    private byte[] getHashBytes(List<byte[]> params) {
        return params.get(0);
    }

    private String getKeyID(List<byte[]> params) {
        try {
            return new String(params.get(2), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    private Mac getMacInstance(char[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(EncryptHelper.getBytesByUTF8(key), ALGORITHM);
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            return mac;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }
}

