/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.wcc.crypt.Formatter;
import org.wcc.crypt.FormatterV1;
import org.wcc.crypt.IntegrityProtectorFactory;
import org.wcc.framework.AppRuntimeException;

public abstract class IntegrityProtector {
    protected static final int PARAM_INDEX_HASH = 0;
    protected static final int PARAM_INDEX_ALGORITHM = 1;
    protected static final int PARAM_INDEX_ID = 2;

    public static String hashString(String content) throws AppRuntimeException {
        IntegrityProtector protector = IntegrityProtectorFactory.get();
        return protector.hash(content);
    }

    public static String hashString(String content, String domain) throws AppRuntimeException {
        IntegrityProtector protector = IntegrityProtectorFactory.get();
        return protector.hash(content, domain);
    }

    public static String hashStream(InputStream in) throws AppRuntimeException {
        IntegrityProtector protector = IntegrityProtectorFactory.get();
        return protector.hash(in);
    }

    public static String hashStream(InputStream in, String domain) throws AppRuntimeException {
        IntegrityProtector protector = IntegrityProtectorFactory.get();
        return protector.hash(in, domain);
    }

    public static boolean isStringIntegrated(String content, String hash) throws AppRuntimeException {
        if (null == content || null == hash) {
            throw new AppRuntimeException("Wrong Param: null");
        }
        List<byte[]> params = IntegrityProtector.getParams(hash);
        if (null == params) {
            return false;
        }
        String algorithm = IntegrityProtector.getAlgorithm(params);
        IntegrityProtector protector = IntegrityProtectorFactory.get(algorithm);
        return protector.isIntegrated(content, hash);
    }

    public static boolean isStreamIntegrated(InputStream in, String hash) throws AppRuntimeException {
        if (null == in || null == hash) {
            throw new AppRuntimeException("Wrong Param: null");
        }
        List<byte[]> params = IntegrityProtector.getParams(hash);
        if (null == params) {
            return false;
        }
        String algorithm = IntegrityProtector.getAlgorithm(params);
        IntegrityProtector protector = IntegrityProtectorFactory.get(algorithm);
        return protector.isIntegrated(in, hash);
    }

    protected static List<byte[]> getParams(String hash) {
        FormatterV1 formatter = new FormatterV1();
        return ((Formatter)formatter).parse(hash);
    }

    protected static String getAlgorithm(List<byte[]> params) {
        try {
            return new String(params.get(1), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    public abstract String hash(String var1) throws AppRuntimeException;

    public abstract String hash(String var1, String var2) throws AppRuntimeException;

    public abstract boolean isIntegrated(String var1, String var2) throws AppRuntimeException;

    public abstract String hash(InputStream var1) throws AppRuntimeException;

    public abstract String hash(InputStream var1, String var2) throws AppRuntimeException;

    public abstract boolean isIntegrated(InputStream var1, String var2) throws AppRuntimeException;
}

