/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.util.HashMap;
import java.util.Map;
import org.wcc.crypt.HMACIntegrityProtector;
import org.wcc.crypt.IntegrityProtector;
import org.wcc.framework.AppProperties;
import org.wcc.framework.AppRuntimeException;

public class IntegrityProtectorFactory {
    public static final String HMAC_SHA256 = "HmacSHA256";
    private static String PROP_ALGORITHM = "crypt_integrity_protect_algorithm";
    private static String DEFAULT_ALGORITHM = "HmacSHA256";
    private static Map<String, Class<?>> IMPL = new HashMap();

    public static IntegrityProtector get() throws AppRuntimeException {
        String algorithm = AppProperties.get((String)PROP_ALGORITHM, (String)DEFAULT_ALGORITHM);
        return IntegrityProtectorFactory.get(algorithm);
    }

    public static IntegrityProtector get(String algorithm) throws AppRuntimeException {
        if (null == algorithm || algorithm.isEmpty()) {
            throw new AppRuntimeException("Wrong Param: algorithm is null or empty");
        }
        Class<?> implClass = IMPL.get(algorithm);
        if (null == implClass) {
            throw new AppRuntimeException("Unsupported IntegrityProtector Algorithm: " + algorithm);
        }
        try {
            Class<IntegrityProtector> impl = implClass.asSubclass(IntegrityProtector.class);
            IntegrityProtector protector = impl.newInstance();
            return protector;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    static {
        IMPL.put(HMAC_SHA256, HMACIntegrityProtector.class);
    }
}

