/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.security.Key;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.wcc.framework.AppProperties;
import org.wcc.framework.AppRuntimeException;

class KeyGen {
    public static final String PROP_ITERATION_COUNT = "crypt_keygen_iteration_count";
    protected static final int DEFAULT_ITERATION_COUNT = 50000;

    KeyGen() {
    }

    public static Key genKey(char[] password, byte[] salt, int keyLength, int iterationCount) throws AppRuntimeException {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec keyspec = new PBEKeySpec(password, salt, iterationCount, keyLength);
            return factory.generateSecret(keyspec);
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    public static int getIterationCount() {
        return AppProperties.getAsInt((String)PROP_ITERATION_COUNT, (int)50000);
    }
}

