/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.codec.binary.Base64;
import org.wcc.crypt.Auditor;
import org.wcc.crypt.Crypter;
import org.wcc.crypt.CrypterFactory;
import org.wcc.crypt.EncryptHelper;
import org.wcc.crypt.KeyStore;
import org.wcc.crypt.KeyUpdateHandler;
import org.wcc.crypt.ProcessLocker;
import org.wcc.crypt.Util;
import org.wcc.crypt.WorkKey;
import org.wcc.framework.AppProperties;
import org.wcc.framework.AppRuntimeException;

public final class KeyManager {
    private static volatile KeyManager instance = null;
    private static ProcessLocker processWriteLock = null;
    private static Lock threadWriteLock = null;

    private KeyManager() {
        KeyManager.initLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyManager getInstance() {
        if (null != instance) return instance;
        Class<KeyManager> clazz = KeyManager.class;
        synchronized (KeyManager.class) {
            if (null != instance) return instance;
            instance = new KeyManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean updateImmediately(String handlerClass) {
        boolean bl;
        try {
            threadWriteLock.lock();
            processWriteLock.lock();
            KeyUpdateHandler handler = null;
            if (null != handlerClass && !handlerClass.isEmpty()) {
                Class<?> clazz = Class.forName(handlerClass);
                handler = (KeyUpdateHandler)clazz.newInstance();
            }
            KeyStore keyStore = KeyStore.getInstance();
            keyStore.reload();
            List<WorkKey> keyList = keyStore.loadAllActive();
            for (WorkKey key : keyList) {
                KeyUpdateHandler tmp = key.getDomain().getUpdateHandler();
                if (null != handler) {
                    key.getDomain().setUpdateHandler(handler);
                }
                key.update();
                key.getDomain().setUpdateHandler(tmp);
            }
            bl = true;
        }
        catch (Exception e) {
            try {
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptHelper.unlock(threadWriteLock, processWriteLock);
                throw throwable;
            }
        }
        EncryptHelper.unlock(threadWriteLock, processWriteLock);
        return bl;
    }

    public boolean updateImmediately() {
        return this.updateImmediately(null);
    }

    public void updateWorkKey(String value, String domainName) {
        if (null == value || value.trim().isEmpty()) {
            throw new AppRuntimeException("updateWorkKey failed. value is empty.");
        }
        if (null == domainName || domainName.trim().isEmpty()) {
            domainName = "WCC_CRYPT_DEFAULT_DOMAIN";
        }
        try {
            threadWriteLock.lock();
            processWriteLock.lock();
            KeyStore keyStore = KeyStore.getInstance();
            keyStore.reload();
            List<WorkKey> keyList = keyStore.loadAllActive();
            for (WorkKey key : keyList) {
                if (key.getType() != 0 || !domainName.equals(key.getDomain().getName())) continue;
                KeyUpdateHandler tmp = key.getDomain().getUpdateHandler();
                key.updateByKey(value);
                key.getDomain().setUpdateHandler(tmp);
            }
        }
        catch (Exception e) {
            try {
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptHelper.unlock(threadWriteLock, processWriteLock);
                throw throwable;
            }
        }
        EncryptHelper.unlock(threadWriteLock, processWriteLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkKey getKey(String domain, int type) {
        WorkKey key;
        block10: {
            KeyStore keyStore;
            block9: {
                keyStore = KeyStore.getInstance();
                key = keyStore.load(domain, type);
                if (null != key) break block9;
                try {
                    threadWriteLock.lock();
                    processWriteLock.lock();
                    keyStore.reload();
                    key = keyStore.load(domain, type);
                    if (null == key) {
                        key = new WorkKey(domain, type);
                        keyStore.save(key);
                    }
                    Auditor.log("Generate WorkKey, id = " + key.getId(), true);
                }
                catch (Exception e) {
                    try {
                        String id = key != null ? key.getId() : null;
                        Auditor.log("Generate WorkKey, id = " + id, false, e);
                        throw new AppRuntimeException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        EncryptHelper.unlock(threadWriteLock, processWriteLock);
                        throw throwable;
                    }
                }
                EncryptHelper.unlock(threadWriteLock, processWriteLock);
                break block10;
            }
            if (this.needUpdate(key)) {
                block8: {
                    try {
                        threadWriteLock.lock();
                        processWriteLock.lock();
                        keyStore.reload();
                        key = keyStore.load(domain, type);
                        if (!this.needUpdate(key)) break block8;
                        key.update();
                    }
                    catch (Throwable throwable) {
                        EncryptHelper.unlock(threadWriteLock, processWriteLock);
                        throw throwable;
                    }
                }
                EncryptHelper.unlock(threadWriteLock, processWriteLock);
            }
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkKey getKey(String id) throws AppRuntimeException {
        KeyStore keyStore = KeyStore.getInstance();
        WorkKey key = keyStore.load(id);
        if (null == key) {
            keyStore.reload();
            key = keyStore.load(id);
            if (null == key) {
                throw new AppRuntimeException("Invalid Key: no key. (id = " + id + ")");
            }
        }
        if (this.needUpdate(key)) {
            block5: {
                try {
                    threadWriteLock.lock();
                    processWriteLock.lock();
                    keyStore.reload();
                    WorkKey newKey = keyStore.load(id);
                    if (!this.needUpdate(newKey)) break block5;
                    newKey.update();
                }
                catch (Throwable throwable) {
                    EncryptHelper.unlock(threadWriteLock, processWriteLock);
                    throw throwable;
                }
            }
            EncryptHelper.unlock(threadWriteLock, processWriteLock);
        }
        return key;
    }

    public static void exportKey(String outFile, String passwd, List<String> domainNameList) {
        KeyManager.exportKey(outFile, passwd, domainNameList, null);
    }

    public static void exportKey(String outFile, String passwd, List<String> domainNameList, String appHomePath) {
        if (null == outFile || outFile.isEmpty() || null == passwd || passwd.isEmpty() || null == domainNameList || domainNameList.isEmpty()) {
            throw new AppRuntimeException("Param error. null or empty");
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        boolean isReloadAppHome = false;
        String oldAppHome = null;
        StringBuffer domains = new StringBuffer();
        for (String domain : domainNameList) {
            domains.append(domain);
            domains.append(",");
        }
        try {
            oldAppHome = System.getProperty("beetle.application.home.path");
            isReloadAppHome = KeyManager.reloadAppHome(appHomePath);
            KeyStore ks = KeyStore.getInstance();
            ks.reload();
            LinkedList<WorkKey> keyList = new LinkedList<WorkKey>();
            for (String domain : domainNameList) {
                List<WorkKey> keysOfDomain = ks.loadAll(domain);
                if (null == keysOfDomain) continue;
                keyList.addAll(keysOfDomain);
            }
            for (WorkKey key : keyList) {
                char[] plainValue = key.getPlainKey();
                key.setValue(plainValue);
            }
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(keyList);
            String base64Export = new String(Base64.encodeBase64((byte[])baos.toByteArray(), (boolean)false, (boolean)true), "UTF-8");
            String cipherExport = CrypterFactory.getCrypter("AES_CBC").encrypt(base64Export, passwd);
            Util.writeFile(outFile, cipherExport);
            Auditor.log("Export WorkKey, domain: " + domains.toString(), true);
        }
        catch (IOException e) {
            try {
                Auditor.log("Export WorkKey, domain: " + domains.toString(), false, e);
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptHelper.close(baos, oos);
                if (isReloadAppHome) {
                    KeyManager.restoreAppHome(oldAppHome);
                }
                throw throwable;
            }
        }
        EncryptHelper.close(baos, oos);
        if (isReloadAppHome) {
            KeyManager.restoreAppHome(oldAppHome);
        }
    }

    public static void importKey(String inFile, String passwd, boolean isAppend) {
        KeyManager.importKey(inFile, passwd, isAppend, null);
    }

    public static void importKey(String inFile, String passwd, boolean isAppend, String appHomePath) {
        if (null == inFile || inFile.isEmpty() || null == passwd || passwd.isEmpty()) {
            throw new AppRuntimeException("Param error. null or empty");
        }
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        boolean isReloadAppHome = false;
        String oldAppHome = null;
        try {
            oldAppHome = System.getProperty("beetle.application.home.path");
            isReloadAppHome = KeyManager.reloadAppHome(appHomePath);
            String cipherImport = Util.readFile(inFile);
            Crypter crypter = CrypterFactory.getCrypter();
            String base64Import = crypter.decrypt(cipherImport, passwd);
            byte[] importBytes = Base64.decodeBase64((String)base64Import);
            bais = new ByteArrayInputStream(importBytes);
            ois = new ObjectInputStream(bais);
            List keyList = (List)ois.readObject();
            KeyStore ks = KeyStore.getInstance();
            if (!isAppend) {
                ks.clear();
            } else {
                ks.reload();
            }
            for (WorkKey key : keyList) {
                char[] value = key.getValue();
                char[] cipherValue = crypter.encryptByRootKey(value);
                Crypter.erase(value);
                key.setValue(cipherValue);
                ks.save(key);
            }
            Auditor.log("Import WorkKey", true);
        }
        catch (Exception e) {
            try {
                Auditor.log("Import WorkKey", false, e);
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptHelper.close(bais, ois);
                if (isReloadAppHome) {
                    KeyManager.restoreAppHome(oldAppHome);
                }
                throw throwable;
            }
        }
        EncryptHelper.close(bais, ois);
        if (isReloadAppHome) {
            KeyManager.restoreAppHome(oldAppHome);
        }
    }

    private static boolean reloadAppHome(String newAppHome) {
        boolean isReloadAppHome = false;
        if (null != newAppHome && !newAppHome.isEmpty()) {
            System.setProperty("beetle.application.home.path", newAppHome);
            isReloadAppHome = true;
            AppProperties.load();
            KeyStore.getInstance().reload();
        }
        return isReloadAppHome;
    }

    private static void restoreAppHome(String oldAppHome) {
        if (null != oldAppHome) {
            System.setProperty("beetle.application.home.path", oldAppHome);
        } else {
            System.clearProperty("beetle.application.home.path");
        }
        AppProperties.load();
        KeyStore.getInstance().reload();
    }

    private static void initLock() {
        processWriteLock = ProcessLocker.getInstance(Util.getSecureHash("KeyManager")).getWriteLock();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        threadWriteLock = lock.writeLock();
    }

    private boolean needUpdate(WorkKey key) {
        if (null == key || !key.isActive()) {
            return false;
        }
        long lifeTime = key.getDomain().getLifeTime();
        long createTime = key.getCreateTime();
        long currentTime = System.currentTimeMillis();
        return currentTime - createTime > lifeTime;
    }
}

