/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wcc.crypt.Auditor;
import org.wcc.crypt.EncryptHelper;
import org.wcc.crypt.ReadLocker;
import org.wcc.crypt.Util;
import org.wcc.crypt.WriteLocker;
import org.wcc.framework.AppProperties;
import org.wcc.framework.AppRuntimeException;

public class ProcessLocker {
    protected static final int RETRY_TIME = 3;
    private static final String DEFAULT_LOCKER_NAME_STRING = "_wcc_file_locker_";
    private static Map<String, ProcessLocker> instances = new ConcurrentHashMap<String, ProcessLocker>();
    private static final int READ_LOCK = 0;
    private static final int WRITE_LOCK = 1;
    private static final int LOCK_MAP_SIZE = 2;
    private static Map<String, ProcessLocker[]> lockerMap = new HashMap<String, ProcessLocker[]>();
    private static final String PROP_RUN_MODE = "crypt_run_mode";
    private static final String PROP_RUN_MODE_USER = "crypt_run_mode_user";
    private static final String PROP_RUN_MODE_GROUP = "crypt_run_mode_group";
    private static final String PROP_LOCK_DIR = "crypt_lock_dir";
    protected int count = 0;
    protected FileChannel fc = null;
    protected FileLock flocker = null;
    protected String lockName = null;
    protected RandomAccessFile lockRandomAccessFile = null;
    protected File lockFile = null;

    protected ProcessLocker(String lockFileName) throws AppRuntimeException {
        File lockDirFile;
        this.lockName = lockFileName;
        String lockDir = AppProperties.get((String)PROP_LOCK_DIR);
        if (null == lockDir || lockDir.isEmpty()) {
            lockDir = Util.getTempFilePath();
        }
        if (!(lockDirFile = new File(lockDir = Util.toAbsolutePath(lockDir) + File.separator)).exists()) {
            lockDirFile.mkdirs();
        }
        this.lockFile = new File(lockDir + this.lockName);
        if (!this.lockFile.exists()) {
            try {
                if (!this.lockFile.createNewFile()) {
                    throw new AppRuntimeException("failed to create lock file: " + this.lockName);
                }
            }
            catch (IOException e) {
                throw new AppRuntimeException((Throwable)e);
            }
        }
        this.setLockPermission();
    }

    public static synchronized ProcessLocker getInstance(String name) {
        ProcessLocker instance = instances.get(name);
        if (null == instance) {
            instance = new ProcessLocker(name);
            instances.put(name, instance);
        }
        return instance;
    }

    public static void unlock(ProcessLocker ... locks) {
        if (null == locks) {
            return;
        }
        for (ProcessLocker lock : locks) {
            try {
                if (null == lock) continue;
                lock.unlock();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public ProcessLocker getReadLock() {
        return this.getLock(0);
    }

    public ProcessLocker getWriteLock() {
        return this.getLock(1);
    }

    public synchronized void lock() throws AppRuntimeException {
        this.getWriteLock().lock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void unlock() throws AppRuntimeException {
        block8: {
            block7: {
                if (null != this.flocker && null != this.fc && this.flocker.isValid()) break block7;
                this.count = 0;
                if (0 != this.count) return;
                EncryptHelper.close(this.fc, this.lockRandomAccessFile);
                return;
            }
            if (0 != this.count) break block8;
            if (0 != this.count) return;
            EncryptHelper.close(this.fc, this.lockRandomAccessFile);
            return;
        }
        try {
            --this.count;
            if (0 == this.count) {
                this.flocker.release();
            }
            if (0 != this.count) return;
        }
        catch (Exception e) {
            try {
                throw new AppRuntimeException("Unlock error(flocker) : " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (0 != this.count) throw throwable;
                EncryptHelper.close(this.fc, this.lockRandomAccessFile);
                throw throwable;
            }
        }
        EncryptHelper.close(this.fc, this.lockRandomAccessFile);
        return;
    }

    public static synchronized ProcessLocker getInstance() {
        return ProcessLocker.getInstance(DEFAULT_LOCKER_NAME_STRING);
    }

    private synchronized ProcessLocker getLock(int type) {
        ProcessLocker[] lockPair = lockerMap.get(this.lockName);
        if (null == lockPair) {
            lockPair = new ProcessLocker[]{new ReadLocker(this.lockName), new WriteLocker(this.lockName)};
            lockerMap.put(this.lockName, lockPair);
        }
        return lockPair[type];
    }

    private void setLockPermission() {
        if (EncryptHelper.isWindows()) {
            return;
        }
        String runMode = AppProperties.get((String)PROP_RUN_MODE, (String)"multigroup").toLowerCase();
        String permission = "";
        if (runMode.equals("singleuser")) {
            permission = "600";
        } else if (runMode.equals("singlegroup")) {
            permission = "660";
        } else if (runMode.equals("multigroup")) {
            permission = "666";
        } else {
            throw new AppRuntimeException("crypt_run_mode has wrong value,it should be singleuser, singlegroup or multigroup");
        }
        String user = AppProperties.get((String)PROP_RUN_MODE_USER);
        String group = AppProperties.get((String)PROP_RUN_MODE_GROUP);
        try {
            EncryptHelper.setFilePermission(this.lockFile, permission, user, group);
        }
        catch (IOException e) {
            Auditor.log("setLockPermission error", false, e);
        }
    }
}

