/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.util.LinkedList;
import java.util.List;
import org.wcc.crypt.Auditor;
import org.wcc.crypt.Crypter;
import org.wcc.crypt.CrypterFactory;
import org.wcc.crypt.KeyStore;
import org.wcc.crypt.RootKeyUpdateHandler;
import org.wcc.crypt.WorkKey;
import org.wcc.framework.AppRuntimeException;

class RKUpdateHandler
implements RootKeyUpdateHandler {
    private List<WorkKey> keys = null;
    private List<char[]> plainValues = new LinkedList<char[]>();

    RKUpdateHandler() {
    }

    @Override
    public boolean doBeforeUpdate() {
        this.keys = KeyStore.getInstance().loadAll();
        for (WorkKey key : this.keys) {
            this.plainValues.add(key.getPlainKey());
        }
        return true;
    }

    @Override
    public boolean doAfterUpdate() {
        try {
            KeyStore ks = KeyStore.getInstance();
            Crypter c = CrypterFactory.getCrypter();
            int i = 0;
            for (char[] plainValue : this.plainValues) {
                char[] cipher = c.encryptByRootKey(plainValue);
                WorkKey key = this.keys.get(i);
                key.setValue(cipher);
                ks.save(key);
                ++i;
            }
            Auditor.log("Refresh WorkKey after RootKey Update", true);
            return true;
        }
        catch (Exception e) {
            Auditor.log("Refresh WorkKey after RootKey Update", false, e);
            throw new AppRuntimeException((Throwable)e);
        }
    }
}

