/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.OverlappingFileLockException;
import org.wcc.crypt.ProcessLocker;
import org.wcc.framework.AppRuntimeException;

class ReadLocker
extends ProcessLocker {
    protected ReadLocker(String lockFileName) throws AppRuntimeException {
        super(lockFileName);
    }

    @Override
    public synchronized void lock() throws AppRuntimeException {
        boolean tryAgain = false;
        boolean interrupted = false;
        int retryTimes = 0;
        do {
            if (tryAgain && ++retryTimes > 3) {
                throw new AppRuntimeException("Error: Too many interruptions");
            }
            tryAgain = false;
            try {
                if (0 == this.count) {
                    this.lockRandomAccessFile = new RandomAccessFile(this.lockFile, "rw");
                    this.fc = this.lockRandomAccessFile.getChannel();
                    this.flocker = this.fc.lock(0L, Long.MAX_VALUE, true);
                }
                ++this.count;
            }
            catch (OverlappingFileLockException e) {
                throw new AppRuntimeException("Another thread has locked. lock = " + this.lockName);
            }
            catch (FileNotFoundException e) {
                throw new AppRuntimeException("FileNotFound");
            }
            catch (Exception e) {
                if (e instanceof ClosedByInterruptException || e instanceof ClosedChannelException || e instanceof InterruptedException || e instanceof FileLockInterruptionException) {
                    interrupted = Thread.interrupted();
                    tryAgain = true;
                    continue;
                }
                throw new AppRuntimeException("Lock error : " + e.getMessage(), (Throwable)e);
            }
        } while (tryAgain);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

