/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;
import org.wcc.crypt.Auditor;
import org.wcc.crypt.EncryptHelper;
import org.wcc.crypt.ProcessLocker;
import org.wcc.crypt.Util;
import org.wcc.framework.AppProperties;
import org.wcc.framework.AppRuntimeException;

class RootKeyComponent {
    protected static final int ROOT_KEY_COMPS_SIZE_MIN = 2;
    private static final String PROP_ROOT_KEY_COMPONENTS = "crypt_keygen_rootkey_components";
    private static final String PROP_ROOT_KEY_COMPONENTS_LEN = "crypt_keygen_rootkey_components_length";
    private static final int ROOT_KEY_COMPONENTS_LEN_MIN = 16;
    private static final int DEFAULT_ROOT_KEY_COMPONENTS_LEN = 16;
    private static final String MAGIC = "wcc_rkc";
    private static final byte RKC_VERSION = 1;
    private static final int CONTENT_START_INDEX = "wcc_rkc".length() + 1;
    private static final String FORMAT_SEPARATOR = ";";
    private static final int VALUE_INDEX = 0;
    private static final int TIMESTAMP_INDEX = 1;
    private static final long INVALID_TIMESTAMP = -1L;
    private static ProcessLocker locker = ProcessLocker.getInstance();
    private String value = null;
    private long timeStamp = -1L;
    private int length = -1;

    public RootKeyComponent() {
        this(RootKeyComponent.getKeyLength());
    }

    public RootKeyComponent(int length) throws AppRuntimeException {
        if (length < 16) {
            throw new AppRuntimeException("Components of RootKey must not less than 128 bits");
        }
        try {
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            byte[] data = new byte[length];
            rand.nextBytes(data);
            this.value = EncryptHelper.parseByte2HexStr(data);
            this.length = length;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    public RootKeyComponent(File rkcFile) throws AppRuntimeException, FileNotFoundException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(rkcFile);
            this.init(in, rkcFile);
        }
        catch (Throwable throwable) {
            EncryptHelper.close(in);
            throw throwable;
        }
        EncryptHelper.close(in);
    }

    private RootKeyComponent(InputStream in, File file) throws AppRuntimeException {
        this.init(in, file);
    }

    private RootKeyComponent(String value) {
        this.value = value;
        this.length = value.length();
    }

    public static RootKeyComponent[] generateBatch(int size) {
        RootKeyComponent[] comps = new RootKeyComponent[size];
        for (int i = 0; i < size; ++i) {
            comps[i] = new RootKeyComponent();
        }
        return comps;
    }

    public static synchronized void saveBatch(RootKeyComponent[] comps, String[] paths) {
        if (null == comps || null == paths || comps.length != paths.length) {
            throw new AppRuntimeException("Param Illegal");
        }
        ProcessLocker writeLock = locker.getWriteLock();
        try {
            writeLock.lock();
            int length = comps.length;
            for (int i = 0; i < length; ++i) {
                comps[i].saveTo(new File(paths[i]));
            }
        }
        catch (Exception e) {
            try {
                Auditor.log("generate and save rkc", false, e);
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                ProcessLocker.unlock(writeLock);
                throw throwable;
            }
        }
        ProcessLocker.unlock(writeLock);
        Auditor.log("generate and save rkc", true);
    }

    public static long currentTimeStamp() {
        return RootKeyComponent.getKeyComps()[0].getTimeStamp();
    }

    public RootKeyComponent combine(RootKeyComponent that) throws AppRuntimeException {
        if (null == that) {
            throw new AppRuntimeException("Param is Null");
        }
        return new RootKeyComponent(this.xor(this.value, that.value));
    }

    public String format() {
        String out = "wcc_rkc\u0001" + this.value + FORMAT_SEPARATOR + this.timeStamp;
        try {
            return new String(Base64.encodeBase64((byte[])out.getBytes("UTF-8"), (boolean)false, (boolean)true), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    public static String[] parse(String rkc) {
        String decoded;
        try {
            decoded = new String(Base64.decodeBase64((String)rkc), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AppRuntimeException((Throwable)e);
        }
        if (decoded.substring(0, MAGIC.length()).equals(MAGIC)) {
            return decoded.substring(CONTENT_START_INDEX).split(FORMAT_SEPARATOR);
        }
        return new String[]{rkc, null};
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getLength() {
        return this.length;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    protected static String[] getRKCPaths() {
        String keyCompPaths = AppProperties.get((String)PROP_ROOT_KEY_COMPONENTS);
        if (null == keyCompPaths) {
            return new String[0];
        }
        String[] rkcPaths = keyCompPaths.split(FORMAT_SEPARATOR);
        if (rkcPaths.length < 2) {
            throw new AppRuntimeException("Config Error. crypt_keygen_rootkey_components in config file is wrong");
        }
        int length = rkcPaths.length;
        for (int i = 0; i < length; ++i) {
            rkcPaths[i] = Util.toAbsolutePath(rkcPaths[i]);
        }
        return rkcPaths;
    }

    protected static RootKeyComponent[] getKeyComps() {
        RootKeyComponent[] comps;
        String[] paths = RootKeyComponent.getRKCPaths();
        if (paths.length > 0) {
            if (paths.length < 2) {
                throw new AppRuntimeException("Config Error. Key Component Path in config file is wrong");
            }
            if (!RootKeyComponent.isValid(paths)) {
                comps = RootKeyComponent.generateBatch(paths.length);
                RootKeyComponent.saveBatch(comps, paths);
            }
            comps = RootKeyComponent.getExternKeyComps(paths);
        } else {
            comps = RootKeyComponent.getDefaultKeyComps();
        }
        return comps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream in, File file) {
        ProcessLocker readLock = null;
        ProcessLocker writeLock = null;
        Class<RootKeyComponent> clazz = RootKeyComponent.class;
        synchronized (RootKeyComponent.class) {
            block7: {
                try {
                    readLock = locker.getReadLock();
                    readLock.lock();
                    String[] content = RootKeyComponent.readFrom(in);
                    this.value = content[0];
                    this.length = this.value.length();
                    String stamp = content[1];
                    if (null == stamp) break block7;
                    this.timeStamp = Long.parseLong(stamp);
                }
                catch (Throwable throwable) {
                    ProcessLocker.unlock(readLock, writeLock);
                    throw throwable;
                }
                ProcessLocker.unlock(readLock, writeLock);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            this.timeStamp = System.currentTimeMillis();
            if (null != file) {
                readLock.unlock();
                readLock = null;
                writeLock = locker.getWriteLock();
                writeLock.lock();
                this.saveTo(file);
            }
            ProcessLocker.unlock(readLock, writeLock);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private static int getKeyLength() {
        return AppProperties.getAsInt((String)PROP_ROOT_KEY_COMPONENTS_LEN, (int)16);
    }

    private void saveTo(File file) throws AppRuntimeException {
        if (null == file) {
            throw new AppRuntimeException("file is null");
        }
        if (!file.exists()) {
            EncryptHelper.createFile(file);
        }
        if (!file.setWritable(true)) {
            throw new AppRuntimeException(file.getName() + "can not be written");
        }
        if (-1L == this.timeStamp) {
            this.timeStamp = System.currentTimeMillis();
        }
        EncryptHelper.saveToFile(file, this.format());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] readFrom(InputStream in) {
        String[] stringArray;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(in, "UTF-8");
            br = new BufferedReader(isr);
            stringArray = RootKeyComponent.parse(br.readLine());
        }
        catch (IOException e) {
            try {
                throw new AppRuntimeException("IOException in reading rkc");
                catch (Exception e2) {
                    throw new AppRuntimeException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                EncryptHelper.close(br, isr);
                throw throwable;
            }
        }
        EncryptHelper.close(br, isr);
        return stringArray;
    }

    private String xor(String left, String right) {
        if (null == left || null == right || left.length() != right.length()) {
            throw new AppRuntimeException("Parameter illegal: null or size not equal");
        }
        byte[] bl = EncryptHelper.parseHexStr2Byte(left);
        byte[] br = EncryptHelper.parseHexStr2Byte(right);
        int size = bl.length;
        byte[] bresult = new byte[size];
        for (int i = 0; i < size; ++i) {
            bresult[i] = (byte)(bl[i] ^ br[i]);
        }
        return EncryptHelper.parseByte2HexStr(bresult);
    }

    private static RootKeyComponent[] getExternKeyComps(String[] paths) throws AppRuntimeException {
        int size = paths.length;
        Closeable[] in = new FileInputStream[size];
        RootKeyComponent[] comps = new RootKeyComponent[size];
        try {
            for (int i = 0; i < size; ++i) {
                File f = new File(paths[i]);
                in[i] = new FileInputStream(f);
                comps[i] = new RootKeyComponent((InputStream)in[i], f);
            }
        }
        catch (FileNotFoundException e) {
            throw new AppRuntimeException("File Not Found");
        }
        finally {
            EncryptHelper.close(in);
        }
        return comps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RootKeyComponent[] getDefaultKeyComps() throws AppRuntimeException {
        String[] defaultKeyCompsPath = new String[]{"org/wcc/crypt/rkc1", "org/wcc/crypt/rkc2", "org/wcc/crypt/rkc3"};
        int compsNum = defaultKeyCompsPath.length;
        RootKeyComponent[] comps = new RootKeyComponent[compsNum];
        Closeable[] in = new InputStream[compsNum];
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (null == loader) {
                throw new AppRuntimeException("Thread.currentThread().getContextClassLoader() return null");
            }
            for (int i = 0; i < compsNum; ++i) {
                in[i] = loader.getResourceAsStream(defaultKeyCompsPath[i]);
                if (null == in[i]) {
                    throw new AppRuntimeException("Get Key Components from jar error");
                }
                comps[i] = new RootKeyComponent((InputStream)in[i], null);
            }
        }
        finally {
            EncryptHelper.close(in);
        }
        return comps;
    }

    private static boolean isValid(String[] paths) throws AppRuntimeException {
        if (null == paths) {
            return false;
        }
        for (String path : paths) {
            if (null == path) {
                return false;
            }
            File file = new File(path);
            if (file.exists() && file.canRead() && 0L != file.length()) continue;
            return false;
        }
        return true;
    }
}

