/*
 * Decompiled with CFR 0.152.
 */
package org.wcc.crypt;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wcc.crypt.EncryptHelper;
import org.wcc.framework.AppProperties;
import org.wcc.framework.AppRuntimeException;

public class Util {
    private static final int SIZE_4_KB = 4096;

    public static Document loadFromXML(String file) {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        ByteArrayInputStream in = null;
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            String content = Util.readFile(file);
            in = new ByteArrayInputStream(content.getBytes("UTF-8"));
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(in);
        }
        catch (Exception e) {
            try {
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptHelper.close(in);
                throw throwable;
            }
        }
        EncryptHelper.close(in);
        return document;
    }

    public static boolean storeToXml(Node doc, OutputStream out) {
        DOMImplementationRegistry registry;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        if (null == impl) {
            throw new AppRuntimeException("getDOMImplementation(\"LS\") returns null");
        }
        LSSerializer writer = impl.createLSSerializer();
        writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        LSOutput output = impl.createLSOutput();
        output.setByteStream(out);
        return writer.write(doc, output);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean storeToXml(Node doc, String file) {
        boolean bl;
        block9: {
            FileOutputStream out;
            block7: {
                boolean bl2;
                block8: {
                    out = null;
                    File f = new File(file);
                    if (f.exists() || f.createNewFile()) break block7;
                    bl2 = false;
                    if (null == out) break block8;
                    EncryptHelper.close(out);
                }
                return bl2;
            }
            try {
                out = new FileOutputStream(file);
                bl = Util.storeToXml(doc, out);
                if (null == out) break block9;
            }
            catch (FileNotFoundException e) {
                try {
                    throw new AppRuntimeException("file not found");
                    catch (IOException e2) {
                        throw new AppRuntimeException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (null != out) {
                        EncryptHelper.close(out);
                    }
                    throw throwable;
                }
            }
            EncryptHelper.close(out);
        }
        return bl;
    }

    public static NodeList searchByXPath(Node doc, String xpath) {
        return (NodeList)Util.searchByXPath(doc, xpath, XPathConstants.NODESET);
    }

    public static Object searchByXPath(Node doc, String xpath, QName returnType) {
        XPath xp = XPathFactory.newInstance().newXPath();
        XPathExpression expression = null;
        try {
            expression = xp.compile(xpath);
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        Class<Util> clazz = Util.class;
        synchronized (Util.class) {
            try {
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return expression.evaluate(doc, returnType);
            }
            catch (XPathExpressionException e) {
                throw new AppRuntimeException((Throwable)e);
            }
        }
    }

    public static String getNodeAttr(Node node, String attrName) {
        String attrValue = null;
        NamedNodeMap attrs = node.getAttributes();
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            Node attr = attrs.item(i);
            if (!attr.getNodeName().equals(attrName)) continue;
            attrValue = attr.getNodeValue();
            break;
        }
        return attrValue;
    }

    public static String getNodeValue(Node node) {
        return node.getTextContent();
    }

    public static String getSecureHash(String content) {
        if (null == content) {
            return null;
        }
        try {
            byte[] bytes = content.getBytes("UTF-8");
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] result = digest.digest(bytes);
            return EncryptHelper.parseByte2HexStr(result);
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    public static byte[] getRandom(int length) throws AppRuntimeException {
        try {
            if (length <= 0) {
                throw new AppRuntimeException("length must bigger than 0");
            }
            byte[] random = new byte[length];
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            rand.nextBytes(random);
            return random;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    public static String toAbsolutePath(String path) {
        if (null == path || path.isEmpty()) {
            return null;
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            return path;
        }
        if (AppProperties.getAsBoolean((String)"crypt_enable_user_dir", (boolean)false)) {
            return file.getAbsolutePath();
        }
        return AppProperties.getAppHome() + "/" + path;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(String fileName) throws AppRuntimeException {
        String string;
        if (null == fileName || fileName.isEmpty()) {
            throw new AppRuntimeException("Param error: null or empty");
        }
        FileInputStream fis = null;
        FileChannel channel = null;
        try {
            fis = new FileInputStream(fileName);
            channel = fis.getChannel();
            if (null == channel) {
                throw new AppRuntimeException("getChannel() return null");
            }
            StringBuilder sb = new StringBuilder();
            Charset charset = Charset.forName("UTF-8");
            CharsetDecoder decoder = charset.newDecoder();
            ByteBuffer buff = ByteBuffer.allocate(4096);
            while (channel.read(buff) != -1 || buff.position() > 0) {
                buff.flip();
                CharBuffer charBuffer = decoder.decode(buff.asReadOnlyBuffer());
                sb.append(charBuffer.toString());
                buff.clear();
            }
            string = sb.toString();
        }
        catch (FileNotFoundException e) {
            try {
                throw new AppRuntimeException("readFile error. file not found");
                catch (Exception e2) {
                    throw new AppRuntimeException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                EncryptHelper.close(channel, fis);
                throw throwable;
            }
        }
        EncryptHelper.close(channel, fis);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFile(String fileName, String content) throws AppRuntimeException {
        if (null == fileName) throw new AppRuntimeException("Param error: null or empty");
        if (fileName.isEmpty()) throw new AppRuntimeException("Param error: null or empty");
        if (null == content) {
            throw new AppRuntimeException("Param error: null or empty");
        }
        FileOutputStream out = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            out = new FileOutputStream(fileName);
            osw = new OutputStreamWriter((OutputStream)out, Charset.forName("UTF-8"));
            bw = new BufferedWriter(osw);
            bw.write(content);
        }
        catch (FileNotFoundException e) {
            try {
                throw new AppRuntimeException("writeFile error. file not found");
                catch (IOException e2) {
                    throw new AppRuntimeException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                EncryptHelper.close(bw, osw, out);
                throw throwable;
            }
        }
        EncryptHelper.close(bw, osw, out);
    }

    public static void deleteFile(String file) {
        File f = new File(file);
        if (!f.delete()) {
            throw new AppRuntimeException("failed to delete file");
        }
    }

    public static String getTempFilePath() {
        String os = System.getProperty("os.name");
        if (null != os && !os.isEmpty() && os.toLowerCase(Locale.ENGLISH).contains("linux")) {
            return "/tmp/";
        }
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("_wcc_test_", null);
            File parentFile = tmpFile.getParentFile();
            if (null == parentFile) {
                throw new AppRuntimeException("does not name a parent directory");
            }
            String string = parentFile.getCanonicalPath() + "/";
            return string;
        }
        catch (IOException e) {
            throw new AppRuntimeException("getTmpDir Error");
        }
        finally {
            if (null != tmpFile && tmpFile.exists()) {
                tmpFile.delete();
            }
        }
    }
}

