/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.connector.exceptions;

import com.google.common.base.MoreObjects;
import com.huawei.sdk.connector.exceptions.AuthenticationException;
import com.huawei.sdk.connector.exceptions.ClientResponseException;
import com.huawei.sdk.connector.exceptions.ServerResponseException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;

public class ResponseException
extends Exception {
    private static final long serialVersionUID = -8878301853894986117L;
    private final int status;
    private HttpUriRequestBase httpRequest;

    public ResponseException(String message, int status) {
        super(message);
        this.status = status;
    }

    public ResponseException(String message, int status, Throwable cause) {
        super(message, cause);
        this.status = status;
    }

    public static ResponseException convert(String message, int status, Throwable cause) {
        if (status == 401) {
            return new AuthenticationException(message, status, cause);
        }
        if (status >= 500) {
            return new ServerResponseException(message, status, cause);
        }
        if (status >= 400) {
            return new ClientResponseException(message, status, cause);
        }
        return new ResponseException(message, status, cause);
    }

    public static ResponseException convert(String message, int status) {
        if (status == 401) {
            return new AuthenticationException(message, status);
        }
        if (status >= 500) {
            return new ServerResponseException(message, status);
        }
        if (status >= 400) {
            return new ClientResponseException(message, status);
        }
        return new ResponseException(message, status);
    }

    public int getStatus() {
        return this.status;
    }

    public void setRequestInfo(HttpUriRequestBase request) {
        this.httpRequest = request;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("message", (Object)this.getMessage()).add("status", this.getStatus()).add("request", (Object)this.httpRequest).toString();
    }
}

