/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.connector.http;

import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public class CustomObjectMapper
extends ObjectMapper {
    private boolean hasJsonRootName(JavaType valueType) {
        if (valueType.getRawClass() == null) {
            return false;
        }
        JsonRootName rootAnnotation = valueType.getRawClass().getAnnotation(JsonRootName.class);
        return rootAnnotation != null;
    }

    public <T> T readValue(String content, Class<T> clazz) throws JsonProcessingException, JsonMappingException {
        JavaType valueType = this._typeFactory.constructType(clazz);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, this.hasJsonRootName(valueType));
        return (T)super.readValue(content, clazz);
    }

    public String writeValueAsString(Object value) throws JsonProcessingException, JsonMappingException {
        if (value != null) {
            Class<?> clazz = value.getClass();
            JavaType valueType = this._typeFactory.constructType(clazz);
            this.configure(SerializationFeature.WRAP_ROOT_VALUE, this.hasJsonRootName(valueType));
        }
        return super.writeValueAsString(value);
    }
}

