/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.connector.http;

import com.huawei.sdk.connector.http.RetryStrategy;
import java.util.HashSet;
import java.util.Set;

public class DefaultRetryStrategy
implements RetryStrategy {
    private static final int RETRY_INTERVAL = 60000;
    private static final int RETRY_MAX_COUNT = 3;
    private boolean enabled = true;
    private int interval;
    private int maxCount;
    private Set<String> retryCodes = new HashSet<String>();
    private Set<Class<?>> retryExceptionClasses = new HashSet();

    public DefaultRetryStrategy() {
        this(60000, 3);
    }

    public DefaultRetryStrategy(int interval, int maxCount) {
        this.interval = interval;
        this.maxCount = maxCount;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isRetry(int retryCount) {
        return this.enabled && retryCount < this.getMaxCount();
    }

    @Override
    public boolean isRetry(int retryCount, String errorCode) {
        return this.enabled && retryCount < this.getMaxCount() && this.retryCodes.contains(errorCode);
    }

    @Override
    public boolean isRetry(int retryCount, Class<?> exceptionClass) {
        return this.enabled && retryCount < this.getMaxCount() && this.retryExceptionClasses.contains(exceptionClass);
    }

    @Override
    public boolean isRetry(int retryCount, String errorCode, Class<?> exceptionClass) {
        return this.enabled && retryCount < this.getMaxCount() && this.retryCodes.contains(errorCode) && this.retryExceptionClasses.contains(exceptionClass);
    }

    @Override
    public int getRetryInterval() {
        return this.getInterval();
    }

    @Override
    public int getRetryMaxCount() {
        return this.getMaxCount();
    }

    public int getInterval() {
        return this.interval;
    }

    public DefaultRetryStrategy setInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public DefaultRetryStrategy setMaxCount(int maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public Set<String> getRetryCodes() {
        return this.retryCodes;
    }

    public DefaultRetryStrategy setRetryCodes(Set<String> retryCodes) {
        this.retryCodes = retryCodes;
        return this;
    }

    public Set<Class<?>> getRetryExceptionClasses() {
        return this.retryExceptionClasses;
    }

    public DefaultRetryStrategy setRetryExceptionClasses(Set<Class<?>> retryExceptionClasses) {
        this.retryExceptionClasses = retryExceptionClasses;
        return this;
    }

    public DefaultRetryStrategy setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

