/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.connector.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.connector.http.CustomObjectMapper;
import com.huawei.sdk.connector.http.DefaultRetryStrategy;
import com.huawei.sdk.connector.http.HttpMethod;
import com.huawei.sdk.connector.http.RequestInvocation;
import com.huawei.sdk.connector.http.RetryStrategy;
import com.huawei.sdk.connector.model.RespEntity;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;

public class RestHttpClient {
    private static final Log logger = LogFactory.getInstance(RestHttpClient.class);
    private static final String TLSV1_2 = "TLSv1.2";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String EMPTY_BODY = "{}";
    private static final String X_AUTH_TOKEN = "X-Auth-Token";
    private static final int CONNECTION_TIME_OUT = 60000;
    private static final int SOCKET_TIME_OUT = 60000;
    private static final ObjectMapper OBJECT_MAPPER = new CustomObjectMapper();
    private String endpoint;
    private Credential credential;
    private RetryStrategy retryStrategy;

    public RestHttpClient(Credential credential) {
        this(null, credential, new DefaultRetryStrategy());
    }

    public RestHttpClient(String endpoint, Credential credential) {
        this(endpoint, credential, new DefaultRetryStrategy());
    }

    public RestHttpClient(String endpoint, Credential credential, RetryStrategy retryStrategy) {
        this.endpoint = endpoint;
        this.credential = credential;
        this.retryStrategy = retryStrategy;
    }

    public <T> T get(RequestInvocation invocation, Class<T> responseType) throws ResponseException, ClientException, IOException {
        return this.invoke(HttpMethod.GET, invocation, responseType);
    }

    public <T> T post(RequestInvocation invocation, Class<T> responseType) throws ResponseException, ClientException, IOException {
        return this.invoke(HttpMethod.POST, invocation, responseType);
    }

    public void post(RequestInvocation invocation) throws ResponseException, ClientException, IOException {
        this.invoke(HttpMethod.POST, invocation);
    }

    public <T> T delete(RequestInvocation invocation, Class<T> responseType) throws ResponseException, ClientException, IOException {
        return this.invoke(HttpMethod.DELETE, invocation, responseType);
    }

    public void delete(RequestInvocation invocation) throws ResponseException, ClientException, IOException {
        this.invoke(HttpMethod.DELETE, invocation);
    }

    public <T> T put(RequestInvocation invocation, Class<T> responseType) throws ResponseException, ClientException, IOException {
        return this.invoke(HttpMethod.PUT, invocation, responseType);
    }

    public void put(RequestInvocation invocation) throws ResponseException, ClientException, IOException {
        this.invoke(HttpMethod.PUT, invocation);
    }

    public <T> T head(RequestInvocation invocation, Class<T> responseType) throws ResponseException, ClientException, IOException {
        return this.invoke(HttpMethod.HEAD, invocation, responseType);
    }

    public void head(RequestInvocation invocation) throws ResponseException, ClientException, IOException {
        this.invoke(HttpMethod.HEAD, invocation);
    }

    public <T> T patch(RequestInvocation invocation, Class<T> responseType) throws ResponseException, ClientException, IOException {
        return this.invoke(HttpMethod.PATCH, invocation, responseType);
    }

    public void patch(RequestInvocation invocation) throws ResponseException, ClientException, IOException {
        this.invoke(HttpMethod.PATCH, invocation);
    }

    public void invoke(HttpMethod httpMethod, RequestInvocation invocation) throws ClientException, IOException, ResponseException {
        this.doExecute(invocation, httpMethod);
    }

    public <T> T invoke(HttpMethod httpMethod, RequestInvocation invocation, Class<T> responseType) throws ClientException, IOException, ResponseException {
        CloseableHttpResponse response = this.doExecute(invocation, httpMethod);
        String respStr = null;
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw ResponseException.convert("The response content of url(" + invocation.getUrl() + ") is null", response.getCode(), null);
        }
        try {
            respStr = EntityUtils.toString((HttpEntity)entity, (String)DEFAULT_CHARSET);
        }
        catch (ParseException err) {
            logger.error((Object)"Parse entity failed, msg: %s", (Throwable)err);
            throw new ClientException("Parse entity failed");
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
        if (String.class.getSimpleName().equals(responseType.getSimpleName())) {
            return (T)respStr;
        }
        return (T)OBJECT_MAPPER.readValue(respStr, responseType);
    }

    public <T> RespEntity<T> invokeWithEntity(HttpMethod httpMethod, RequestInvocation invocation, Class<T> responseType) throws ClientException, IOException, ResponseException {
        CloseableHttpResponse response = this.doExecute(invocation, httpMethod);
        String respStr = null;
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw ResponseException.convert("The response content of url(" + invocation.getUrl() + ") is null", response.getCode(), null);
        }
        RespEntity<Object> respEntity = new RespEntity<Object>();
        try {
            respEntity.setHeaders(response.getHeaders());
            respStr = EntityUtils.toString((HttpEntity)entity, (String)DEFAULT_CHARSET);
        }
        catch (ParseException err) {
            logger.error((Object)"Parse entity failed, msg: %s", (Throwable)err);
            throw new ClientException("Parse entity failed");
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
        if (String.class.getSimpleName().equals(responseType.getSimpleName())) {
            respEntity.setEntity(respStr);
            return respEntity;
        }
        respEntity.setEntity(OBJECT_MAPPER.readValue(respStr, responseType));
        return respEntity;
    }

    public CloseableHttpClient createHttpClient(URL url) throws ClientException {
        SSLContext context;
        try {
            context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new BcmX509TrustManager(url.getHost())}, new SecureRandom());
        }
        catch (Exception err) {
            logger.error((Object)"Init ssl context failed, msg: %s", (Throwable)err);
            throw new ClientException("Init ssl context failed");
        }
        String[] supportedProtocols = new String[]{TLSV1_2};
        SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(context, supportedProtocols, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslFactory).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(registry);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(Timeout.ofMilliseconds((long)60000L));
        builder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)60000L));
        RequestConfig requestConfig = builder.build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connMgr).disableContentCompression().build();
    }

    private URL buildUrl(RequestInvocation invocation) throws ClientException {
        if (this.endpoint == null) {
            this.endpoint = this.credential.getEndpoint();
        }
        try {
            return new URL(this.endpoint + invocation.getUrl());
        }
        catch (Exception err) {
            logger.error((Object)"Url(%s) convert failed, msg: %s", new Object[]{invocation.getUrl(), err});
            throw new ClientException("Url(" + invocation.getUrl() + ") convert failed");
        }
    }

    private CloseableHttpResponse doExecute(RequestInvocation invocation, HttpMethod httpMethod) throws ClientException, IOException, ResponseException {
        URL url = this.buildUrl(invocation);
        CloseableHttpClient httpClient = this.createHttpClient(url);
        HttpUriRequestBase httpRequest = this.createHttpRequest(invocation, httpMethod);
        int retryCount = 0;
        CloseableHttpResponse response = null;
        while (true) {
            block8: {
                try {
                    response = httpClient.execute((ClassicHttpRequest)httpRequest);
                }
                catch (Exception err) {
                    logger.error((Object)"Url(%s) request failed, msg: %s", new Object[]{invocation.getUrl(), err});
                    if (this.retryStrategy.isRetry(retryCount)) break block8;
                    throw err;
                }
            }
            if (response != null) {
                int code = response.getCode();
                if (code < 400) {
                    return response;
                }
                logger.error((Object)"Url(%s) response error, http code: %s, error msg: %s", new Object[]{invocation.getUrl(), code, response.getReasonPhrase()});
                if (!this.retryStrategy.isRetry(retryCount) || code < 500) {
                    throw ResponseException.convert(response.getReasonPhrase(), code, null);
                }
            }
            try {
                Thread.sleep(this.retryStrategy.getRetryInterval());
            }
            catch (InterruptedException e) {
                logger.info((Object)"Thread interrupted.");
            }
            logger.info((Object)"Start retry the url(%s)", new Object[]{invocation.getUrl()});
            ++retryCount;
        }
    }

    private HttpUriRequestBase createHttpRequest(RequestInvocation invocation, HttpMethod httpMethod) throws ClientException {
        HttpGet request;
        URI uri;
        try {
            uri = this.buildUrl(invocation).toURI();
        }
        catch (Exception err) {
            logger.error((Object)"Url(%s) convert failed, msg: %s", new Object[]{invocation.getUrl(), err});
            throw new ClientException("Url(" + invocation.getUrl() + ") convert failed");
        }
        String body = this.buildBody(invocation);
        switch (httpMethod) {
            case GET: {
                request = new HttpGet(uri);
                break;
            }
            case POST: {
                if (VerifyUtil.isEmpty((String)body)) {
                    body = EMPTY_BODY;
                }
                HttpPost httpPost = new HttpPost(uri);
                httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.parse((CharSequence)DEFAULT_CHARSET)));
                request = httpPost;
                break;
            }
            case DELETE: {
                request = new HttpDelete(uri);
                break;
            }
            case PUT: {
                HttpPut httpPut = new HttpPut(uri);
                if (!VerifyUtil.isEmpty((Object)invocation.getEntity())) {
                    httpPut.setEntity((HttpEntity)new StringEntity(body, ContentType.parse((CharSequence)DEFAULT_CHARSET)));
                }
                request = httpPut;
                break;
            }
            case PATCH: {
                if (VerifyUtil.isEmpty((String)body)) {
                    body = EMPTY_BODY;
                }
                HttpPatch httpPatch = new HttpPatch(uri);
                httpPatch.setEntity((HttpEntity)new StringEntity(body, ContentType.parse((CharSequence)DEFAULT_CHARSET)));
                request = httpPatch;
                break;
            }
            case HEAD: {
                request = new HttpHead(uri);
                break;
            }
            default: {
                throw new ClientException("The method(" + (Object)((Object)httpMethod) + ") is not support.");
            }
        }
        this.addRequestHeader((HttpUriRequestBase)request, invocation);
        return request;
    }

    private String buildBody(RequestInvocation invocation) throws ClientException {
        String body = "";
        try {
            if (invocation.getJsonStr() != null) {
                return invocation.getJsonStr();
            }
            if (invocation.getEntity() != null) {
                return OBJECT_MAPPER.writeValueAsString(invocation.getEntity());
            }
        }
        catch (Exception err) {
            logger.error((Object)"Convert body model to string failed, msg: %s", (Throwable)err);
            throw new ClientException("Convert body model to string failed");
        }
        return body;
    }

    private void addRequestHeader(HttpUriRequestBase request, RequestInvocation invocation) throws ClientException {
        request.addHeader("Connection", (Object)"close");
        if (!VerifyUtil.isEmpty(invocation.getHeaders())) {
            for (Map.Entry<String, String> entry : invocation.getHeaders().entrySet()) {
                if (entry == null) continue;
                request.addHeader(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (!request.containsHeader("Content-Type")) {
            request.addHeader("Content-Type", (Object)"application/json;charset=UTF-8");
        }
        if (VerifyUtil.isEmpty((String)this.credential.getToken())) {
            logger.error((Object)"Request(%s) token is null.", new Object[]{request.getRequestUri()});
            throw new ClientException("token is null");
        }
        request.addHeader(X_AUTH_TOKEN, (Object)this.credential.getToken());
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }
}

