/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.configbackup;

import com.huawei.ism.drm.configbackup.ErrHandleTask;
import com.huawei.ism.drm.configbackup.ExceptionUtil;
import com.huawei.ism.drm.configbackup.Printer;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmdUtil {
    private static final Log logger = LogFactory.getInstance(CmdUtil.class);
    private static final String errLog = "logs/importDBErr.log";
    private static final String infoLog = "logs/importDBInput.log";

    public static void runShell(String shPath, String[] params) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(shPath.replace("\\/", "/").replace(" ", "\" \""));
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" " + param);
            }
        }
        CmdUtil.runShell(sb.toString());
    }

    public static boolean checkParam(String param, String match, int minSize, int maxSize) throws Exception {
        if (param == null || match == null || 0 > minSize || 0 > maxSize || minSize > maxSize) {
            StringBuilder sb = new StringBuilder();
            sb.append("check param is error.");
            sb.append(" regEx :");
            sb.append(match);
            sb.append(" minSize :");
            sb.append(minSize);
            sb.append(" maxSize :");
            sb.append(maxSize);
            sb.append(" is error.");
            logger.info((Object)sb.toString(), "");
            throw new Exception();
        }
        if (minSize > param.length() || maxSize < param.length()) {
            return false;
        }
        Pattern pat = Pattern.compile(match);
        Matcher mat = pat.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        return mat.matches() && mat.find(0) && 0 <= mat.groupCount();
    }

    private static void runShell(String shStr) throws Exception {
        logger.info((Object)"start restore configdata, please wait...", "");
        Printer.println("Start restore configdata, please wait...");
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", shStr}, null, null);
            InputStreamReader input = new InputStreamReader(process.getInputStream(), "utf8");
            BufferedReader inputBr = new BufferedReader(input);
            ErrHandleTask inputTask = new ErrHandleTask(inputBr, infoLog);
            InputStreamReader err = new InputStreamReader(process.getErrorStream(), "utf8");
            BufferedReader errBr = new BufferedReader(err);
            ErrHandleTask errTask = new ErrHandleTask(errBr, errLog);
            Thread inputT = new Thread(inputTask);
            Thread errT = new Thread(errTask);
            inputT.start();
            errT.start();
            process.waitFor();
            logger.info((Object)"restore successfully, Please restart the Server.", "");
            Printer.println("Restore successfully, please restart the Server.");
        }
        catch (Exception e) {
            logger.error((Object)("failed restoreLinuxMysql:" + ExceptionUtil.getErrorMessage(e)));
            Printer.println("Failed restoreLinuxMysql.");
        }
    }
}

