/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.configbackup;

import java.io.FileNotFoundException;
import java.net.BindException;
import java.security.GeneralSecurityException;
import java.security.acl.NotOwnerException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.jar.JarException;
import javax.naming.InsufficientResourcesException;

public final class ExceptionUtil {
    private static final String[] VALID_PACKAGE_PREFIX_NAMES = new String[]{"com.huawei"};
    private static final List<Class<? extends Throwable>> SPECIAL_EXCEPTION_CLASSES = Arrays.asList(SecurityException.class, GeneralSecurityException.class, ClassNotFoundException.class, FileNotFoundException.class, JarException.class, MissingResourceException.class, NotOwnerException.class, ConcurrentModificationException.class, InsufficientResourcesException.class, BindException.class, OutOfMemoryError.class, StackOverflowError.class, SQLException.class);

    private ExceptionUtil() {
    }

    public static boolean isSpecialException(Throwable exception) {
        for (Class<? extends Throwable> clazz : SPECIAL_EXCEPTION_CLASSES) {
            if (!clazz.isInstance(exception)) continue;
            return true;
        }
        return false;
    }

    public static String getErrorMessage(Throwable exception) {
        StringBuilder strBuilder = new StringBuilder();
        if (null == exception) {
            return strBuilder.toString();
        }
        strBuilder.append("\n");
        Throwable t = exception;
        int index = 0;
        do {
            if (0 < index) {
                strBuilder.append("Caused by: ");
            }
            String message = t.getMessage();
            if (ExceptionUtil.isSpecialException(t)) {
                message = "***";
            }
            strBuilder.append(t.getClass().getName() + ": " + message + "\n");
            StackTraceElement[] elements = t.getStackTrace();
            ExceptionUtil.retrieveStackTraces(elements, strBuilder);
            t = t.getCause();
            ++index;
        } while (null != t);
        return strBuilder.toString();
    }

    private static void retrieveStackTraces(StackTraceElement[] elements, StringBuilder strBuilder) {
        int index = 0;
        for (StackTraceElement element : elements) {
            String clsName = element.getClassName();
            if (1 != ++index && !ExceptionUtil.isValidClass(clsName)) continue;
            strBuilder.append("   at   " + element.toString() + "\n");
        }
    }

    private static boolean isValidClass(String clsName) {
        for (String validClsName : VALID_PACKAGE_PREFIX_NAMES) {
            if (!clsName.startsWith(validClsName)) continue;
            return true;
        }
        return false;
    }
}

